//
//	file name:		$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/AnimServices.h $
//	file version:	$Revision: 1.17 $
//
//	purpose:		The AnimServices utility class
//					Used as the OXF interface to AOM
//
//	author(s):		Amos Ortal
//	date started:	March 2005
//
//	date changed:	$Date: 2007/03/11 11:57:48 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 2005, 2007
//


#ifndef AnimServices_H 
#define AnimServices_H "$Id"

class AOMInstance;
class AOMEvent;
class AOMSState;
class AOMSEvent;

class IOxfActive;
class IOxfEvent;
class IOxfEventGenerationParams;
class IOxfReactive;
class IOxfTimeout;
class IOxfAnimReactive;
class IOxfAnimThreadManager;
class IOxfAnimTimerManager;
class IOxfAnimHelper;

class OMOSEventFlag;

#include "oxf/rp_framework_dll_definition.h"

// The AOM entry point for the OXF
class RP_FRAMEWORK_DLL AnimServices 
{
public :
    // Add the state information to the AOM state vector
    // Argument AOMSState* states : 
    // The AOM states vector
    // Argument const char* state : 
    // The state name
    //## operation addState(AOMSState,char*) 
    static void addState(AOMSState* states, const char* state);
    
    // Add the state information to the AOM state vector
    // Argument AOMSState* states : 
    // The AOM states vector
    // Argument bool shouldTerminate : 
    // true when a terminte should be added
    //## operation addTerminateState(AOMSState,bool) 
    static void addTerminateState(AOMSState* states, bool shouldTerminate);
    
    // de-register an external thread (not related to active instances) that was registered on the animation
    // Argument void* osThread : 
    // The OS thread handle
    //## operation deregisterForeignThread(void *) 
    static void deregisterForeignThread(void* osThread);
    
    // Return the animation instance that is associated with the specified "real" instance
    // Argument void* inst : 
    // The real instance
    //## operation getAnimInstance(void *) 
    static AOMInstance* getAnimInstance(void* inst);
    
	// Return the anim helper
	static const IOxfAnimHelper* getOxfAnimHelper();

	// Return the threads manager
	static IOxfAnimThreadManager* getThreadManager();

	// Return the timer manager
	static IOxfAnimTimerManager* getTimerManager();

    // Initialize the animation
    // Return true if the initialization was sucessful
    // Animated applications should terminate if the return value is false.
    //## operation init(int,char**,unsigned int,char*) 
    static bool init(int argc, char** argv, unsigned int defaultPort, const char* defaultHost);
    
    // Query if the application is terminating, to be used by various AOM algorithms instead of query the OXF implementation
    //## operation isApplicationEnding() 
    static bool isApplicationEnding();
    
    // notify the AOM that the application is about to terminate.
    // The AOM should close the connection to Rhapsody.
	// Argument closeConnection:
	//		When true the connection with Rhapsody is closed immediately, 
	//		otherwise the close of the connection is postponed until the cleanup of the AOM
    //## operation notifyEndApplication() 
    static void notifyEndApplication(bool closeConnection);

	// Perform explicit AOM cleanup
	// Required to cleanup the AOM in adapters that do not support automatic cleanup
	static void cleanupOnEndApplication();
    
    // Nofiy the animation that an error occured
    // Argument const char* msg : 
    // The error message
    //## operation notifyError(char*) 
    static void notifyError(const char* msg);
    
    // Nofiy the animation that an error occured
    // Argument void* context : 
    // The contect (instance) that the error was found in
    // Argument const char* msg : 
    // The error message
    //## operation notifyError(void *,char*) 
    static void notifyError(void* context, const char* msg);
    
    // Notify that an event was canceled (required for direct reactive deletion)
    //## operation notifyEventCancelled(IOxfEvent) 
    static void notifyEventCancelled(void* osThread, const IOxfEvent* ev);
    
    // Notify that an event is about to be destroyed
    //## operation notifyEventDestroyed(IOxfEvent) 
    static void notifyEventDestroyed(const IOxfEvent* ev);
    
    // Notify that the specified thread is about remove an event from the queue
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation notifyEventGetBegin(void *) 
    static void notifyEventGetBegin(void* osThread, bool add2q = true);
    
    // Notify that the specified thread removed the event from the queue
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    // Argument const IOxfEvent* ev : 
    // The event that was removed
    //## operation notifyEventGetEnd(void *,IOxfEvent) 
    static void notifyEventGetEnd(void* osThread, const IOxfEvent* ev, bool add2q = true);
    
    // Notify that the event is about to be put into the thread queue
    // Argument void* osThread : 
    // The thread
    // Argument const IOxfEvent* ev : 
    // The event
    // Argument bool blocking : 
    // If the put of the event queue is expected to be a blocking call for a significant time duration this is indicated by setting this argument to true
    //## operation notifyEventPutBegin(void *,IOxfEvent,bool) 
    static void notifyEventPutBegin(void* osThread, const IOxfEvent* ev, bool blocking, bool add2q = true);
    
    // Notify that the event was put into the thread queue
    // Argument void* osThread : 
    // The thread
    // Argument const IOxfEvent* ev : 
    // The event
    //## operation notifyEventPutEnd(void *,IOxfEvent) 
    static void notifyEventPutEnd(void* osThread, const IOxfEvent* ev, bool add2q = true);

	// Notify that an event step had occured
	// Argument void* osThread : 
    // The thread
    //## operation notifyEventStep(void*)
	static void notifyEventStep(void* osThread);
    
    // Notify that the first step was performed (e.g. OXF::initialize()) in the context of the specified thread.
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation notifyFirstStep(void *) 
    static void notifyFirstStep(void* osThread);
    
    // Notify the AOM that the framework default message loop isactivated
    //## operation notifyFrameworkStarted() 
    static void notifyFrameworkStarted();
    
    // Notify that an event is about to be handled
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    // Argument const IOxfEvent* ev : 
    // The event
    //## operation notifyHandleEvent(IOxfReactive,IOxfEvent) 
    static void notifyHandleEventBegin(const IOxfReactive* instance, const IOxfEvent* ev);
    
    // Notify that an event was handled
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    // Argument const IOxfEvent* ev : 
    // The event
    //## operation notifyHandleEvent(IOxfReactive,IOxfEvent) 
    static void notifyHandleEventEnd(const IOxfReactive* instance, const IOxfEvent* ev);
    
    // Notify that the specified thread is idle (no events to consume)
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation notifyIdle(void *) 
    static void notifyIdle(void* osThread);
    
    // Notify the animation that a thread is going through a mutex.
    // The operation should be called twice, before and after the lock.
    // Argument bool locked : 
    // Indicates if the call was made before (false) or after (true) the lock
    //## operation notifyMutexLock(bool) 
    static void notifyMutexLock(bool locked);
    
    // Notify that a null-transition is about to be taken.
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    //## operation notifyNullTransition(IOxfReactive) 
    static void notifyNullTransition(const IOxfReactive* instance);
    
    // Notify that a reactive instance is deleted
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    static void notifyReactiveInstanceDeleted(const IOxfReactive* instance);

    // Notify that the specified thread is ready to run.
    // This is used by the animation to perform function calls on the context of the thread before continue the event loop.
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation notifyReady(void *) 
    static void notifyReady(void* osThread);
    
    // Notify that an event is being send
    // Argument const IOxfEvent* ev : 
    // The event
    // Argument const IOxfEventGenerationParams& params : 
    // The event sending parameters
    //## operation notifySendingEvent(IOxfEvent) 
    static void notifySendingEvent(const IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
    // Notify that the behavior (i.e. statemachine) of a reactive instance is about to be activated.
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    //## operation notifyStartBehavior(IOxfReactive) 
    static void notifyStartBehaviorBegin(const IOxfReactive* instance);
    
    // Notify that the behavior (i.e. statemachine) of a reactive instance is completed.
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    //## operation notifyStartBehavior(IOxfReactive) 
    static void notifyStartBehaviorEnd(const IOxfReactive* instance);
    
    // Notify that a state was entered
    // Argument const IOxfReactive* instance : 
    // The state machine owner
    // Argument const char* state : 
    // The state vector as string
    //## operation notifyStateEntered(IOxfReactive,char*) 
    static void notifyStateEntered(const IOxfReactive* instance, const char* state);
    
    // Notify that a state was entered
    // Argument const AOMInstance* instance : 
    // The state machine owner
    // Argument const char* state : 
    // The state vector as string
    //## operation notifyStateEntered(AOMInstance,char*) 
    static void notifyStateEntered(const AOMInstance* instance, const char* state);
    
    // Notify that a state was exited
    // Argument const IOxfReactive* instance : 
    // The state machine owner
    // Argument const char* state : 
    // The state vector as string
    //## operation notifyStateExited(IOxfReactive,char*) 
    static void notifyStateExited(const IOxfReactive* instance, const char* state);
    
    // Notify that a state was exited
    // Argument const AOMInstance* instance : 
    // The state machine owner
    // Argument const char* state : 
    // The state vector as string
    //## operation notifyStateExited(AOMInstance,char*) 
    static void notifyStateExited(const AOMInstance* instance, const char* state);
    
    // Notify that the reactive instance reached a terminate connector
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    // Argument const char* connector : 
    // The terminate connector full name
    //## operation notifyTerminateConnector(IOxfReactive,char*) 
    static void notifyTerminateConnector(const IOxfReactive* instance, const char* connector);
    
    // Notify that a thread was created
    // Argument const IOxfActive* context : 
    // The active class
    // Argument void* osThread : 
    // The OS thread handle
    //## operation notifyThreadCreated(IOxfActive,void *) 
    static void notifyThreadCreated(IOxfActive* context, void* osThread);
    
    // Notify that a thread is about to be destroyed
    // Argument void* osThread : 
    // The OS thread handle
    //## operation notifyThreadDestroyed(void *) 
    static void notifyThreadDestroyed(void* osThread);
    
    // Notify that a timeout was canceled
    //## operation notifyTimeoutCancelled(IOxfTimeout) 
    static void notifyTimeoutCancelled(const IOxfTimeout* tm);
    
    // Notify that an animated framework event was created
    //## operation notifyFrameworkEventCreated(IOxfEvent) 
    static void notifyFrameworkEventCreated(IOxfEvent* tm);
    
    // Notify that a timeout was scheduled
    //## operation notifyTimeoutSet(IOxfTimeout) 
    static void notifyTimeoutSet(const IOxfTimeout* tm);
   
	// register the singleton implementation of IOxfAnimHelper
	static void registerAnimHelper(const IOxfAnimHelper* helper);

	// Register the threads manager to enable the animation to control threads behavior
	static void registerAnimThreadManager(IOxfAnimThreadManager* threadManager);

    // Register the IOxfAnimTimerManager on the AOM to enable time control (stop timeouts in breakpoints, advance the time on go idle commands, etc.)
    //## operation registerAnimTimerManager(IOxfAnimTimerManager) 
    static void registerAnimTimerManager(IOxfAnimTimerManager* timerManager);
    
    // register an external thread (not related to active instances) that was registered on the animation
    // Argument void* osThread : 
    // The OS thread handle
    // Argument const char* name : 
    // The thread name
    //## operation registerForeignThread(void *,char*) 
    static void registerForeignThread(void* osThread, const char* name);
    
    // Register a reactive instance with its animation proxy
    // Argument const IOxfReactive* instance : 
    // The reactive instance
    // Argument const IOxfAnimReactive* proxy : 
    // The animation proxy
    //## operation registerReactiveInstance(IOxfReactive,IOxfAnimReactive) 
    static void registerReactiveInstance(const IOxfReactive* instance, IOxfAnimReactive* proxy);
    
    // Reset the call stack associated with the specified thread
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation resetCallStack(void *) 
    static void resetCallStack(void* osThread);

	// Reset the default thread RTOS identifier
	static void resetDefaultThread(IOxfActive* oxfContext, void* osThread);
    
    // Set the animation thread name
    // Argument void* osThread : 
    // The OS thread handle
    // Argument const char* name : 
    // The thread name
    //## operation setThreadName(void *,char*) 
    static void setThreadName(void* osThread, const char* name);
    
    // Set the animation thread name by an animation instance
    // Argument IOxfActive* oxfContext : 
    // The active context
    // Argument AOMInstance* instance : 
    // The instance to set as the thread context
    //## operation setThreadContext(void *,char*) 
    static void setThreadContext(IOxfActive* oxfContext, AOMInstance* instance);
    
    // Check if the specified thread should become idle.
    // If this operation returns true notifyIdle() should be called otherwise you should call notifyWaitingForEvents()
    // Argument void* osThread : 
    // The OS thread handle, when 0 the animation assumes that the context is the current thread
    //## operation shouldNotifyIdle(void *) 
    static bool shouldNotifyIdle(void* osThread);
    
    // Switch the thread used by an implementation of IOxfActive (typically called by the default active class on the event loop initialization).
    // Argument void* oldThread : 
    // The old OS thread handle
    // Argument void* newThread : 
    // The new OS thread handle
    //## operation switchOSThread(void *,void *) 
    static void switchOSThread(void* oldThread, void* newThread);

	// used by threads (other than the one that called init) to wait
	// until the init is complete before sending an animation message
	static void waitForInit();
private:

	// event serialization helper
	static AOMSEvent* serializeUserEvent(AOMInstance* aomInst, AOMEvent* aomEv);
	// event serialization helper
	static AOMSEvent* serializeFrameworkEvent(const IOxfEvent* ev, bool& animatedEvent);

	// Indicator that the application is terminating
	// Set by calling notifyEndApplication()
	static bool endingApplication_;

	// the animation helper
	static const IOxfAnimHelper* theAnimHelper_;

	// the threads manager
	static IOxfAnimThreadManager* threadManager_;

	// the timer manager
	static IOxfAnimTimerManager* timerManager_;

	// flag to indicate if animation were initialized
	static bool animInitialized;

	// used to identify if the current thread is the initializer thread
	static void* initThreadHandle;

	// event flag for init
	static OMOSEventFlag* initEventFlag;
};


#endif  // AnimServices_H

// $Log: AnimServices.h $
// Revision 1.17  2007/03/11 11:57:48  ilgiga
// Change copyright comment
// Revision 1.16  2007/03/01 16:31:20  ilgiga
// Telelogic instead of i-Logix
// Revision 1.15  2006/03/19 15:23:02  eldad
// Fixed 90635:
// Non-main thread should wait for AnimServices::init() to complete before 
// communicating animation messages to Rhapsody.
// Revision 1.14  2005/09/25 16:37:13  vova
// 
// --- Added comments ---  vova [2005/09/25 17:13:54 GMT]
// AnimServices:
// - add public static operation 
//   void resetDefaultThread(IOxfActive* oxfContext, void* osThread)
//   The operation reset the default AOMThread OS thread id
//   Used to overcome an issue in VxWorks where the globals initialization thread is not an application thread
// 
// OMOSThread:
// - Add public virtual operation void resetWrapperThreadOsHandle(void*)
//   The operation reset the thread OS handle
//   it Should be used with care and only for wrapper threads
//   The operation has an empty implementation by default and is implemented in the VxWorks adapter
// 
// OMMainThread:
// - Add public virtual operation void resetWrapperThreadOsHandle(void*)
//   The operation calls the OS thread resetWrapperThreadOsHandle()
// 
// OXF::initialize() - call AnimServices::resetDefaultThread() and 
//   OMMainThread::instance()->resetWrapperThreadOsHandle() with the current thread to make sure the correct thread is used
// Revision 1.13  2005/09/15 07:29:24  vova
// AOM shadow queue will not be modified when timeouts expire (we need to simulate the enter to/exit from queue of the timeouts in order for the animation to display them properly).
// Revision 1.12  2005/08/03 12:39:46  amos
// Fix AnimServices support for end application to support the various RTOS needs
// - Add a boolean argument to notifyEndApplication() that controls the closing of the connection to Rhapsody
// - Add new public static operation cleanupOnEndApplication() that destroys the anim dispatcher
// - Modify the adapters usage of these operations besed on the 6.0 version of the adapters
// Revision 1.11  2005/06/06 15:34:23  amos
// Revision 1.10.1.2  2005/06/06 12:41:03  amos
// AnimServices:
// Add reference to the IOxfAnimHelper implementation
// Add new static operation void notifyReactiveInstanceDeleted(const IOxfReactive* instance) that is called by IOxfReactive implementation to destroy the IOxfAnimReactive proxy
// Revision 1.10  2005/04/18 12:08:59  amos
// Revision 1.9  2005/04/10 15:25:19  amos
// Revision 1.8  2005/04/06 11:41:47  amos
// Add IOxfAnimThreadManager
// Revision 1.7  2005/04/04 13:42:07  amos
// Add two new operations
// - notifyEventStep() that indicates that the an event dispatcing was completed
// - setThreadContext() that set the AOMInstance associated with a specific thread
// Revision 1.6  2005/03/20 12:05:09  amos
// Expose the Anim timer manager
// Revision 1.5  2005/03/16 14:02:25  amos
// Revision 1.4  2005/03/10 14:25:05  amos
// Implementing AnimServices
//
