#ifndef toxf_H
#define toxf_H "$Id: toxf.h 1.25 2007/03/11 13:14:48 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/toxf.h $
//	file version:	$Revision: 1.25 $
//
//	purpose:	Definitions of types and classes for TOM classes
//
//	author(s):	  Yachin Pnueli
//	date started:	8.10.96
//	date changed:	$Date: 2007/03/11 13:14:48 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif 

#ifdef OMANIMATOR
// The setting for the 'o-mate case'

// Protect against both flags 'on'
#ifdef	OMTRACER
#error "toxf.h cannot use both 'OMANIMATOR' and 'OMTRACER'"
#endif 

#define OMOMATE

#else
#ifdef	OMTRACER
// The setting for the 'application case'

#ifndef OMAPPLICATION
#define	OMAPPLICATION
#endif // OMAPPLICATION

// Protect against niether flag 'on'
#else
#error "toxf.h needs either 'OMANIMATOR' or 'OMTRACER'"
#endif 
#endif 


#define OMCAST_CLASS TOMProxyItem
#include <omcom/om.h>
#include <omcom/ommask.h>
#include <omcom/omnote.h>
#include <omcom/omsdata.h>
#include <oxf/omlist.h>
#ifdef OM_STL
#include <cctype>
#else
#include <ctype.h>
#endif 

// A (return) code for name 2 item functions
#define TOMPossibleButNonExistent	OMInConstruction

// Functions about call Strings 
RP_ANIM_DLL const char* getInstaceCallString();
RP_ANIM_DLL const char* getClassCallString();
extern const char* objectCallString;
extern const char* packageCallString;

OMBoolean isXString(const char * c, const char* x);
inline OMBoolean isInstanceCallString(char * c) {
	return isXString(c,getInstaceCallString());
}

inline OMBoolean isClassCallString(char * c) {
	return isXString(c,getClassCallString());
}

inline OMBoolean isObjectCallString(char * c) {
	return isXString(c,objectCallString);
}

inline OMBoolean isInstanceOrObjectCallString(char *c) {
	return (isInstanceCallString(c) || isObjectCallString(c));
}

inline OMBoolean isPackageCallString(char * c) {
	return isXString(c,packageCallString);
}

char* skipXString(char*& c, const char* x);
inline char * skipInstanceCallString(char*& c) {
	return skipXString(c,getInstaceCallString());
}

inline char * skipClassCallString(char*& c) {
	return skipXString(c,getClassCallString());
}

inline char * skipObjectCallString(char*& c) {
	return skipXString(c,objectCallString);
}

inline char * skipPackageCallString(char*& c) {
	return skipXString(c,packageCallString);
}

inline char* skipInstanceOrObjectCallString(char*& c) {
	char *res = NULL;
	if (isInstanceCallString(c))
		res = skipInstanceCallString(c);
	else if (isObjectCallString(c))
		res = skipObjectCallString(c);
	return res;
}

inline OMBoolean isEndOfName(char *c) {
	return isspace(c[0]) ||
		c[0]=='\0' ||
		c[0]==',' ||
		c[0]==')' ||
		c[0]==';' ||
		c[0]==':' ;
}


RP_ANIM_DLL void tomSendError(const char * msg);

RP_ANIM_DLL void tomOutputString(const char * msg);

inline void tomSendError(OMString& msg) {
	tomSendError(msg.GetBuffer(0));
}

inline void tomSendWarning(OMString& msg) {
	tomOutputString(msg.GetBuffer(0));
}

inline unsigned int method2Interest(OMMethodType type) {
	switch (type) {
	case omBehaviourMethod:
	case omNullTransition:
	case omTriggerMethod:
	case omMethodMethod:		return OMMethodsInterest;
	case omDestructorMethod:	return OMDestructorsInterest;
	case omConstructorMethod:	return OMConstructorsInterest;
	default:					return OMNoInterest;
	}
}


class RP_ANIM_DLL TOMSData : public OMSData {
	// This class is implemented in tommsg.cpp
public:
	TOMSData(const char * item):OMSData(item) { }
	TOMSData() { }

	void*	safeGetPointer(OMSPosition& position);
	void*	getPointer(OMSPosition& position);
	TOMSData* safeGetOMSData(OMSPosition& position) {
		return (TOMSData*)OMSData::safeGetOMSData(position);
	}

};


//
// $Log: toxf.h $
// Revision 1.25  2007/03/11 13:14:48  ilgiga
// Change copyright comment
// Revision 1.24  2007/03/04 15:07:40  ilgiga
// Telelogic instead of i-Logix
// Revision 1.23  2004/01/12 10:31:05  eldad
// Allow dor (.) notation in C++\Java
// Revision 1.22  2002/07/15 12:29:35  avrahams
// Back to main
// Revision 1.21.1.2  2002/07/04 11:27:08  avrahams
// Cleanup std namespace usage
// Revision 1.21.1.1  2001/10/01 10:18:29  avrahams
// Duplicate revision
// Revision 1.21  2001/10/01 10:18:29  Eldad
// 1.20.1.2 to main branch.
// Revision 1.20.1.2  2001/09/26 00:48:49  Eldad
// Changed some of the erros to warnings that are not to be shown in popup 
// message box.
// Revision 1.20.1.1  2001/05/02 12:46:49  Eldad
// Duplicate revision
// Revision 1.19  2000/12/27 12:10:26  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.18  2000/01/19 12:34:45  amos
// back to main branch
// Revision 1.17.1.1  2000/01/06 14:01:23  amos
// Revision 1.17  1999/11/08 15:09:42  zvika
// Add DLLs.
// Revision 1.16  1999/10/12 13:33:03  yachin
// Fix bugs
// Revision 1.15  1999/08/30 11:31:45  yachin
// Fix bug 'rhapsody gets stuck on show #Thread @@SubB[0]->#Eventqueue
// Revision 1.14  1999/07/15 13:42:06  yachin
// change 'instanceCallString from '->' to '.'
// Revision 1.13  1999/07/12 08:21:47  yachin
// Treat global rename correctly
// Revision 1.12  1999/02/16 05:57:04  yachin
// Speed up of constructors
// Revision 1.11  1998/08/02 15:05:15  beery
// changing boolean->OMBoolean
// Revision 1.10  1998/04/13 07:59:04  ofer
// keep "using namespace std;"
// only after include to <XXXstream>
// Revision 1.9  1998/04/13 07:41:00  ofer
// added "using namespace std;" after each include to stl files
// Revision 1.8  1998/04/12 12:17:46  ofer
// Change includes to Stl format ifdefed by OM_USE_STL
// Revision 1.7  1997/04/07 23:06:12  ofer
// Move file names and includes to lowercase
// so UNIX will work with lowercase versions
// Revision 1.6  1997/02/11 12:54:39  yachin
// Adding Name spaces
// Revision 1.5  1997/02/03 13:39:38  yachin
// Revision 1.4  1997/01/21 11:08:53  yachin
// changed _int32 to int
// Revision 1.3  1996/12/19 13:15:14  yachin
// Revision 1.2  1996/11/24 12:40:47  yachin
// Revision 1.1  1996/10/10 08:49:44  yachin
// Initial revision
//

#endif 
