#ifndef tomthrd_H
#define tomthrd_H "$Id: tomthrd.h 1.22 2007/03/11 13:14:47 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomthrd.h $
//	file version:	$Revision: 1.22 $
//
//	purpose:	Define the TOMThread and TOMThreadManager classes
//				the proxy of a thread and the "list of threads"
//
//	author(s):	Yachin Pnueli
//	date started:	25.12.96
//	date changed:	$Date: 2007/03/11 13:14:47 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1996, 2007
//
#include	"tomproxy.h"
#include	<oxf/ommap.h>

//
//	Class TOMThread - the proxy of AOMThread (either an OMThread
//	or a user defined thread interacting with O-Mate classes).
//
//	Subjects:
//	1. Name - A TOMThread is either "named" or "unnamed". A "named"
//		thread is created with theName!=NULL. "theName" is stored
//		in "myName" which is the name of th thread.
//		An "unnamed" thread is a thread created for some "Active"
//		instance. During construction theName==NULL. Since the thread
//		is created before construction of the "owning" instance is
//		completed, the thread is created with myName==NULL and
/*
	Old description
//		myRealOwner==TOMInConstruction. During the construction of the 
//		instance (when its "this" becomes known) thw instance gets
//		connected to the thread via "setOwner".
//		Finally the proxy of the owner is placed in myContext.
//		Since the search for this proxy is expensive and we do not 
//		know when it should be performed, we do it only when we are
//		prompted to display the name of the thread.
*/
//	New description
//		myContext==TOMInConstruction.
//		Finally the proxy of the owner is placed in myContext.
//
//
//
class TOMCallStack;
class TOMEventQueue;
class TOMStepper;
class TOMSystem;
class TOMThreadManager;
class TOMInstance;


class RP_ANIM_DLL TOMThread: public TOMProxyItem {
	friend class TOMThreadManager;
private:
	TOMCallStack* myCallStack;
	TOMStepper* myStepper;
	TOMEventQueue* myEventQueue;
	OMBoolean suspended;
//	void* *myRealOwner;
	int myOsHandle;

	void setContext(TOMProxyItem* context) { myContext = context; }
//	void setOwner(TOMProxyItem* theOwner) { myOwner = theOwner; }

	void notifyLostFocus();

	TOMThread(void * theReal,
		OMInterestMask theStepperMask,
		void * realCallStack,
		void * realStepper,
		void * realEventQueue,
		int realOsHandle);
public:
	~TOMThread();
	void setName(char * theName);

	// Simple accessors
	TOMCallStack* getCallStack() const { return myCallStack; }
	TOMStepper* getStepper() const { return myStepper; }
	TOMEventQueue* getEventQueue() const { return myEventQueue; }

	// Name agenda
	virtual OMString& outputFirstName(OMString& s) const;
	OMString& outputFullName(OMString& s, 
			const TOMProxyItem * /* theContext */ = OMSystemContext) const {
		return outputFirstName(s);
	}

	// Execution agenda
	OMBoolean isSuspended() const { return suspended; }
	void suspend();
	void resume();

	void handleMessage(OMNotify msgCode, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage* msg) { TOMProxyItem::handleMessage(msg); }

	int getOsHandle() const { return myOsHandle; }

	// accept a visitor, and execute all its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);

};


class RP_ANIM_DLL TOMThreadManager: public TOMProxyItem	 {
	friend class TOMSystem;
	friend class TOMThread;
	TOMThread *focusThread;

	void remove(TOMThread*t);
	void add(TOMThread*t) { threadList.add(t); }
	TOMThread* add(void* real, OMSData* s, OMSPosition p);
	
	TOMThread* name2Thread(const OMString& name);
	

	TOMThreadManager();
	virtual ~TOMThreadManager();
protected:
	void _showYourself(TOMUniversalObserver*,int& theMask);
	OMList<TOMThread *> threadList;
	OMMap<void*, TOMThread*> _socket2FocusThreadMap;
public:
	TOMThread* name2Thread(char *& itemName);
	TOMThread* osHandle2Thread(int osHandle);

	TOMProxyItem* name2ThreadObject(char *& itemName);

	// Focus agenda
	TOMThread* getFocusThread();// { return focusThread; }
	void setFocusThread(TOMThread*);
	void setFocusThread(TOMStepper*);

	OMBoolean showYourself(TOMUniversalObserver*, int);
	void replaceItemByDestroyed(TOMInstance* destroyed);

	// accept a visitor, and execute all its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);
	OMList<TOMThread *> * getThreadList() { return &threadList;}

};

//
// $Log: tomthrd.h $
// Revision 1.22  2007/03/11 13:14:47  ilgiga
// Change copyright comment
// Revision 1.21  2007/03/04 15:07:39  ilgiga
// Telelogic instead of i-Logix
// Revision 1.20  2006/10/31 08:58:57  ccohen
// support running multiple animation processes.
// Revision 1.19  2003/05/27 09:09:21  vova
// Getter added
// Revision 1.18  2003/05/26 11:06:22  vova
// ESTL-Embedded C++ with Standard Templates Libraries
// Revision 1.17  2002/08/06 08:25:04  Eldad
// Fixed warnings in Solaros Adaptor.
// Revision 1.16  2000/12/25 10:39:51  amos
// move to warning level 4
// Revision 1.15  1999/11/08 15:09:41  zvika
// Add DLLs.
// Revision 1.14  1999/02/16 05:57:04  yachin
// Speed up of constructors
// Revision 1.13  1998/12/17 14:36:43  ofer
// handle aomdbgstop message which is breakpoint from debugger
// Revision 1.12  1998/11/19 17:59:22  beery
// Revision 1.11  1998/11/17 12:33:25  beery
// Revision 1.10  1998/08/02 15:05:15  beery
// changing boolean->OMBoolean
// Revision 1.9  1998/06/25 08:46:19  yachin
// Fix bug 6515 - rereference deleted instances on call stack to 'inDestruction"
// Revision 1.8  1998/05/21 11:24:09  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.7  1997/01/30 13:32:18  yachin
// Revision 1.6  1997/01/21 11:08:52  yachin
// changed _int32 to int
// Revision 1.5  1997/01/21 10:52:52  yachin
// User Threads part I
// Revision 1.4  1997/01/12 13:36:22  yachin
// Revision 1.3  1996/12/30 09:56:50  yachin
// Multi Thread support part III
// Revision 1.2  1996/12/26 09:48:46  yachin
// Revision 1.1  1996/12/25 13:49:41  yachin
// Initial revision
//

#endif
