#ifndef tomsys_H
#define tomsys_H "$Id: tomsys.h 1.60 2007/06/10 07:49:40 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomsys.h $
//	file version:	$Revision: 1.60 $
//
//	purpose:	Define the TOMSystem class - the proxy class of the entire
//				animated/traced system
//				Main responsibilities:
//				1. Create proxies for "Static" animation items
//				2. Be the adress of messages with no other "destination"
//				3. Serve as starting point for global searches
//					(name to item) and global notifications
//
//	author(s):	Yachin Pnueli
//	date started:	23.7.96
//	date changed:	$Date: 2007/06/10 07:49:40 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic 1996, 2007
//
#include	"tomproxy.h"
#include <oxf/ommap.h>
#include	"tomsilent.h"

class TOMThreadManager;
class TOMInstance;
class TOMClass;
class TOMEventClass;
class TOMPackage;
class TOMPartObserver;

class AnimOpReturn;
class AnimStringOrPointerField;
class AnimOpCallReply;

class RP_ANIM_DLL TOMSystem : public TOMProxyItem {
	static OMBoolean _animationIsActive;

	// TRUE when the singelton is well set
	static OMBoolean _systemIsCreated;

	OMList <TOMPackage *> packages;
	OMList<const TOMInstance*> m_renamedInstances;
	OMMap <void*,TOMProxyItem*> real2Proxy;

	OMMap <int, OMString> reqID2CallStr;

	TOMThreadManager* threadManager;

	TOMProxyItem* name2Internal(char *&name) const;

	TOMPackage * findOrMakePackage(OMSData* s, OMSPosition& p);
	void addPackage(TOMPackage * p);

	void makeProxy(OMSData* s, OMSPosition p, void* pSocket);
				// Make a static proxy according to "s"
	void real2ProxyAdd(void* r, TOMProxyItem*p);

	TOMSystem();
	static TOMSystem * _instance;

#ifdef OM_OS_NEED_EXPLICIT_DISABLE_COPY_CTOR
	// explicitly disable the copy CTOR & operator = ()
	TOMSystem(TOMSystem&) : TOMProxyItem("") { }
	TOMSystem& operator = (TOMSystem&) { return *this; }
#endif // OM_OS_NEED_EXPLICIT_DISABLE_COPY_CTOR

public:
	virtual ~TOMSystem();
	static TOMSystem * createInstance() {
		if (_instance == NULL) new TOMSystem();
		return _instance;
	}
	static TOMSystem * instance() {
		if (_instance == NULL) new TOMSystem();
			return _instance;
	}
	static TOMThreadManager* threadManagerInstance() {
		return instance()->threadManager;
	}

	static void setAnimationIsOver() { _animationIsActive = FALSE; }
	static OMBoolean animationIsActive() { return _animationIsActive; }
	// the system is in silent mode
	static OMBoolean sysInSilentMode(); 

	int numberOfPackages() const {
		// The '-1' since OMInternal does not count
		return packages.getCount()-1;
	}

	TOMProxyItem* name2Item(char *& name) const;
	TOMPackage* name2Package(const OMString& name) const;
	TOMClass* name2Class(const OMString& name) const;
	TOMClass* name2Class(const OMString& packageName,const OMString& className) const;
	TOMInstance* name2Instance(char *& name) const;
	TOMEventClass* name2EventClass(const OMString& name, void* pSocket = NULL) const;
	TOMEventClass* name2EventClass(const OMString& packageName,const OMString& eventName, void* pSocket = NULL) const;

	// This is here for the MSC
	TOMInstance* name2Instance(OMString name) const{
		char *c = name.GetBuffer(0);
		return name2Instance(c);
	}

	TOMProxyItem * getInstanceByReal(void* real);


	void handleMessage(OMNotify r, TOMSData *s, OMSPosition p, void* pSocket);

	void handleMessage(OMNotify r, TOMSData *s, OMSPosition p) { handleMessage(r,s,p,NULL); }
	
	void handleMessage(AnimMessage*);

	void notifyTimeChange(timeUnit time); 

	void notifyTimer(timeUnit delay, timeUnit actualDelay, timeUnit elapsedTime); 

	TOMProxyItem * tryToRegisterObserver(TOMUniversalObserver* obs, 
									OMInterestMask theMask,
									const char * theName);
	TOMProxyItem * registerObserver(TOMUniversalObserver* obs, 
									OMInterestMask theMask,
									const char * theName);
	void deregisterObserver(TOMUniversalObserver * obs,
							const char * name,
							OMInterestMask theMask = OMAllInterest);

	TOMProxyItem* registerPartObserver(TOMPartObserver *theObserver, TOMInstance *theInstance);
	
	// This should never be called - its here to avoid a "hide" warning
	void deregisterObserver(TOMUniversalObserver * obs,
							OMInterestMask theMask = OMAllInterest);
	// theMask here is meaningful only if "name" is a TOMClass

	OMBoolean showYourself(TOMUniversalObserver*, int);
	void _showYourself(TOMUniversalObserver*, int&);
	void registerObserver(TOMUniversalObserver*, OMInterestMask);
	void reRegisterObserver(TOMUniversalObserver*, OMInterestMask);
	void addToObserver(TOMUniversalObserver*, OMInterestMask);
	void subtractFromObserver(TOMUniversalObserver*, OMInterestMask);

	OMBoolean addBreakPoint(OMNotify theType, const char *theData="");

	void replaceItemByDestroyed(TOMInstance* destroyed);

	// accept a visitor, and execute all its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);
	OMList<TOMPackage *> *getPackageList() { return &packages; }

	// manage the renamed instances table
	void addRenamedInstance(const TOMInstance * t)
	{
		if (!m_renamedInstances.find(t)) {
			m_renamedInstances.add(t);
		}
	}
	OMBoolean isRenamedInstance(const TOMInstance * t)
	{
		return (m_renamedInstances.find(t) != 0);
	}
	void removeRenamedInstance(const TOMInstance * t)
	{
		m_renamedInstances.remove(t);
	}

	void notifyReadyForInput();

	void notifyOpCallRequestSent();
	
	void notifyForeignMessage(OMString& paylod);

	void notifyOpCallReply(AnimOpCallReply* reply);


	void notifyOpReturn(AnimOpReturn* retMsg);

	void notifyApplicationIdle();

	void logOpRequest(int, OMString);
	OMString reqIDToCallStr(int);

	/* helper function to extract a string form a StringOrPointerField */
	static OMString getStringOrPointerFieldValue(AnimStringOrPointerField *theField);

#ifdef OMANIMATOR
	void DestroyAllItemsWithSpecificSocket(void* pSocket);
#endif

private:
	// since we had to split the makeProxy to several small functions
	TOMProxyItem* makeProxyClass(void* realP, OMSData* s, OMSPosition& p);
	TOMProxyItem* makeProxyEventClass(void* realP, OMSData* s, OMSPosition& p);
	TOMProxyItem* makeProxyPackage(void* realP, OMSData* s, OMSPosition& p);
	TOMProxyItem* makeProxyThread(void* realP, OMSData* s, OMSPosition& p);

};



//
// $Log: tomsys.h $
// Revision 1.60  2007/06/10 07:49:40  ilelpa
// Fixed timer service for OSC
// Revision 1.59  2007/03/21 14:22:56  ilelpa
// Added a notification for operation call reply
// Revision 1.58  2007/03/11 13:14:47  ilgiga
// Change copyright comment
// Revision 1.57  2007/03/04 15:07:39  ilgiga
// Telelogic instead of i-Logix
// Revision 1.56  2007/02/08 10:38:41  ilelpa
// Added the ability to get time notifications to observer. This is used for test conductor
// to get the time from Rhapsody instead of relying on the OS clock.
// Revision 1.55  2006/11/06 09:46:29  ccohen
// fixed compilation errors/warnings in vxworks/integrity.
// Revision 1.54  2006/10/31 08:58:56  ccohen
// support running multiple animation processes.
// Revision 1.53  2004/06/27 15:30:21  amos
// move to model-based oxf in RiC++
// Revision 1.51.1.3  2004/06/17 06:52:56  vova
// Merge with r52 (v1.52)
// Revision 1.51.1.2  2004/02/09 09:27:56  amos
// changes due to OMBoolean type change
// Revision 1.51.1.1  2003/12/24 14:34:28  amos
// Duplicate revision
// Revision 1.50.1.2  2003/12/23 16:18:52  eldad
// Revision 1.50.1.1  2003/05/15 07:02:01  eldad
// Duplicate revision
// Revision 1.49.1.1  2003/05/08 10:07:44  Eldad
// Duplicate revision
// Revision 1.48.1.1  2002/11/25 11:50:01  Eldad
// Duplicate revision
// Revision 1.47  2002/07/29 09:32:19  Eldad
// Merge 1.45.2.2 + 1.46
// Revision 1.46  2002/07/07 13:52:26  amos
// framework cleanup from RTOS specific code - back to r41 main branch
// Revision 1.45.1.2  2002/07/07 13:52:26  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.45.1.1  2001/05/21 10:25:47  amos
// Duplicate revision
// Revision 1.45.2.2  2002/07/29 09:30:58  Eldad
// Revision 1.45  2001/05/21 10:25:47  Eldad
// 1.44.1.2 to main branch
// Revision 1.44.1.2  2001/05/17 09:48:17  Eldad
// Notification when user has control.
// Revision 1.44.1.1  2000/12/25 10:49:34  Eldad
// Duplicate revision
// Revision 1.43  2000/11/14 14:29:30  ofer
// teak the code so GNU compiler  for PPC ( VxWorks )  will work
// bugfix 30417
// Revision 1.42  2000/07/11 12:45:59  amos
// changes related to modify char* to const char*.
// Revision 1.41  1999/11/08 15:09:41  zvika
// Add DLLs.
// Revision 1.40  1999/10/12 13:33:03  yachin
// Fix bugs
// Revision 1.39  1999/08/03 11:19:09  yachin
// Some fixes related to name2Item
// Revision 1.38  1999/07/11 09:21:55  amos
// add a table for renamed global instances
// Revision 1.37  1999/06/18 09:07:51  beery
// due to lazy evaluation, make sure that new package/class/classevent are observed my the console 
// so when a new object or event are created they "inherite" their initial mask from their logical parent
// Revision 1.36  1999/02/21 09:31:19  yachin
// Fix bugs on unique name and name2class
// Revision 1.35  1999/02/18 11:27:16  yachin
// Fix regression on initial call stack entry
// Revision 1.34  1999/02/16 05:57:03  yachin
// Speed up of constructors
// Revision 1.33  1998/12/20 13:05:42  yaniv
// 
// Revision 1.32  1998/11/19 17:59:08  beery
// Revision 1.31  1998/11/17 12:32:23  beery
// Revision 1.30  1998/08/02 15:05:14  beery
// changing boolean->OMBoolean
// Revision 1.29  1998/06/25 08:46:19  yachin
// Fix bug 6515 - rereference deleted instances on call stack to 'inDestruction"
// Revision 1.28  1997/07/27 08:54:04  yachin
// make tomSystem start from instance too
// Revision 1.27  1997/04/30 10:57:22  yachin
// small bug fix
// Revision 1.26  1997/03/31 09:29:52  yachin
// Fix Unix Warnings
// Revision 1.25  1997/02/19 07:51:53  yachin
// Revision 1.24  1997/02/19 07:46:56  yachin
// Revision 1.23  1997/02/11 12:54:39  yachin
// Adding Name spaces
// Revision 1.22  1997/01/21 11:08:52  yachin
// changed _int32 to int
// Revision 1.21  1996/12/30 09:56:49  yachin
// Multi Thread support part III
// Revision 1.20  1996/12/25 13:38:35  yachin
// Multi-Threading first shot
// Revision 1.19  1996/12/22 13:13:53  yachin
// Revision 1.17  1996/11/24 12:40:47  yachin
// Revision 1.16  1996/11/18 07:37:52  yachin
// fixed bug in "current Thread"
// Revision 1.15  1996/11/13 12:48:44  yachin
// Revision 1.14  1996/11/11 11:54:30  yachin
// Support multi-thread part I
// Revision 1.13  1996/10/28 09:49:59  yachin
// Revision 1.12  1996/10/24 12:56:42  yachin
// Rewrite of observer registration mechanism + new instance iterators
// Revision 1.11  1996/10/09 07:37:13  yachin
// Revision 1.10  1996/09/16 09:28:40  yachin
// Revision 1.9  1996/09/08 13:29:01  yachin
// Registeration of items which do not yet exist
// Revision 1.8  1996/09/05 13:35:58  yachin
// Revision 1.7  1996/09/04 13:16:13  yachin
// Connect with Israel
// Revision 1.6  1996/09/03 12:01:17  yachin
// Alow show #callStack
// Revision 1.5  1996/08/28 05:38:08  ofer
// Revision 1.4  1996/08/12 12:28:52  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.3  1996/08/08 08:23:32  yachin
// Revision 1.2  1996/08/06 12:55:59  yachin
// Revision 1.1  1996/08/06 12:53:28  yachin
// Initial revision
//

#endif
