#ifndef tomstr_H
#define tomstr_H "$Id: tomstr.h 1.18 2007/03/11 13:14:47 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomstr.h $
//	file version:	$Revision: 1.18 $
//
//	purpose:	Define basic string manipulation - verbatim copy of 
//				Foundtn/Services/ystr.h
//				except BOOL --> OMBoolean and CString --> OMstring
//
//	author(s):	Yachin Pnueli
//	date started:	4.8.96
//	date changed:	$Date: 2007/03/11 13:14:47 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1996, 2007
//

#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif

inline OMBoolean advanceIfStartsWith(const char*& orgStr,
					   const char* pattern) {
	const char* str = orgStr;
	// returns true if "str" starts with "pattern"
	while (*pattern!='\0') {
		if (*str != *pattern)
			return false;
		else {
			++str;
			++pattern;
		}
	}
	orgStr = str;
	return true;
}

inline OMBoolean startsWith(const char* str, const char* pattern)
{
	const char* tmpStr = str;
	return advanceIfStartsWith(tmpStr,pattern);
}

inline OMBoolean startsWith(OMString& s, const char* pattern)
{
	return startsWith(s.GetBuffer(0),pattern);
}

inline void stripComments(char *line, const char* comment)
{
	OMBoolean inBackSlash = false;
	OMBoolean inString = false;

	for (char *pos = line; *pos!='\0'; ++pos) {
		// Take care of strings
		if ( (*pos)=='\"' && !inBackSlash) {
			inString = (!inString);
		}
		// Now look for the comnments
		if (!inBackSlash && !inString && startsWith(pos,comment) ) {
			// We found a comment
			*pos = '\0';
			return;
		}
		// Take care of the '\' problem
		if ( (*pos)=='\\' && !inBackSlash) {
			inBackSlash = true;
		}
		else {
			inBackSlash = false;
		}
	}
}

inline void checkOverFlow(char*& line, char*& pos, int& size)
{
	if (pos>=(line+size)) { // Overflow in next char
		// Allocate new memory
		char * newLine = new char[2*size];
		// Copy from old to new
		strncpy(newLine,line,size);
		// switch cLine and newCLine
		delete[] line;
		line = newLine;
		pos = line + size;
		size*=2; // Must be the last thing done
	}
}


inline OMBoolean isNotSeperator(char c, const char * nonSeperators="") { 
	if (isalnum(c) || c=='_')
		return TRUE;
	else
		return (strchr(nonSeperators,c) != NULL);
 }


inline OMBoolean isExplicitNotSeperator(char c, const char * nonSeperators) { 
	return (strchr(nonSeperators,c) != NULL);
 }

inline OMBoolean isSeperator(char c) { return c=='\0' || !isNotSeperator(c); }

inline void eatWhiteSpaces(char *&c) {
	while ((*c)!='\0' && isspace(*c)) c++;
}

inline void eatOneTokenRaw(char *&c, OMString& token, 
						const char * nonSeperators="") {
	// Copy the non-seperators until next seperator
	while ((*c)!='\0' && isNotSeperator(*c,nonSeperators)) {
		token += *c;
		c++;
	}
}

inline void eatOneTokenNow(char *&c, OMString& token, 
						const char * nonSeperators="") {
	token = "";
	eatOneTokenRaw(c,token,nonSeperators);
}

inline void eatOneToken(char *&c, OMString& token, 
						const char * nonSeperators="") {
	// Eat empty spaces before the Token 
	eatWhiteSpaces(c);
	// Copy the non-seperators until next seperator
	eatOneTokenNow(c,token,nonSeperators);
}

inline void eatOneExplicitTokenRaw(char *&c, OMString& token, 
									const char * nonSeperators) {
	// Copy the non-seperators until next seperator
	while ((*c)!='\0' && isExplicitNotSeperator(*c,nonSeperators)) {
		token += *c;
		c++;
	}
}

inline void eatOneExplicitToken(char *&c, OMString& token, 
						const char * nonSeperators) {
	// Now analyze line
	token = "";
	// Eat empty spaces before the Token 
	eatWhiteSpaces(c);
	// Copy the non-seperators until next seperator
	eatOneExplicitTokenRaw(c,token,nonSeperators);
}

RP_ANIM_DLL const char* rpyGetShortAlphaNumString(omistream& is);
// see rpyraw.cpp for implementation


// A string class not sensitive to case
class RP_ANIM_DLL NoCaseString: public OMString {
public:
	// Coomparison operators
	OMBoolean operator==(const char * other)
	{
		return (CompareNoCase(other) == 0);
	}
	OMBoolean operator!=(const char * other)
	{
		return (CompareNoCase(other) != 0);
	}
	NoCaseString() {}
	NoCaseString(const char *s):OMString(s) { }
};


//
// $Log: tomstr.h $
// Revision 1.18  2007/03/11 13:14:47  ilgiga
// Change copyright comment
// Revision 1.17  2007/03/04 15:07:38  ilgiga
// Telelogic instead of i-Logix
// Revision 1.16  2004/06/27 15:30:19  amos
// move to model-based oxf in RiC++
// Revision 1.15.1.2  2004/02/09 09:07:21  amos
// changes due to OMBoolean type change
// Revision 1.15.1.1  2002/07/15 12:29:35  amos
// Duplicate revision
// Revision 1.14  2000/07/11 15:08:36  amos
// changes related to modify char* to const char*.
// Revision 1.13  1999/11/08 15:09:40  zvika
// Add DLLs.
// Revision 1.12  1999/10/18 08:33:16  yachin
// Fix bug in name2Item
// Revision 1.11  1999/08/03 11:19:08  yachin
// Some fixes related to name2Item
// Revision 1.10  1999/03/22 14:34:53  amos
// fix stripComments() check for comments in a string
// Revision 1.9  1998/08/02 15:05:13  beery
// changing boolean->OMBoolean
// Revision 1.8  1997/05/27 09:02:51  yachin
// Made tomstr == ystr
// Revision 1.7  1996/12/25 13:38:34  yachin
// Multi-Threading first shot
// Revision 1.6  1996/11/24 12:40:46  yachin
// Revision 1.5  1996/09/29 12:16:58  yachin
// Fix bug with commens
// Revision 1.4  1996/08/28 05:38:08  ofer
// Revision 1.3  1996/08/12 12:28:52  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.2  1996/08/06 12:55:58  yachin
// Revision 1.1  1996/08/06 12:53:27  yachin
// Initial revision
//

#endif
