#ifndef tomobs_H
#define tomobs_H "$Id: tomobs.h 1.31 2007/03/11 13:14:44 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomobs.h $
//	file version:	$Revision: 1.31 $
//
//	purpose:	Provide methods and macros related t oobserver
//				+ the ShowObserver class and the BirthObserver class
//		ShowObservers are created when someone wants something to
//		be shown to it. Say X wants to see Y. the showObserver registers
//		on Y and remembers X. When Y sends a notifyShow the shoqw observer
//		determines if it is relevant and if so sends it to X.
//
//		BirthObservers are created when someone wants to register on a none
//		existing object. Say X wants to register on Y. The birthObserver
//		registers on the owner of Y and waits for items to be created
//		if the created item "advances" it, it advances. If this means we 
//		reached the desired instance the birthObserver registers X to Y
//		and terminates itself. else it just deregisters itself from the old
//		item and reregisters itself to the new item.
//
//	author(s):	  Yachin Pnueli
//	date started:	5.9.96
//	date changed:	$Date: 2007/03/11 13:14:44 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "tomabso.h"
#include "tomproxy.h"

class RP_ANIM_DLL TOMCreateObserverItem {
public:
	OMString myName;
	TOMUniversalObserver * myObserver;
	OMInterestMask myMask;
	TOMCreateObserverItem(TOMUniversalObserver * theObserver,
							OMInterestMask theMask,
							char * theName) {
		myName = theName;
		myObserver = theObserver;
		myMask	   = theMask;
	}
	int getSize() const { return myName.GetLength(); }
};

class RP_ANIM_DLL TOMOrderedCOIList : public OMList<TOMCreateObserverItem *> {
public:
	void addInPlace(TOMCreateObserverItem *);
};

class RP_ANIM_DLL TOMCreateObserver {
	TOMOrderedCOIList l;
public:
	~TOMCreateObserver();

	void addObserver(TOMUniversalObserver * theObserver,
					OMInterestMask theMask,
					char * theName) {
		// Make sure I don't have any old copies of this
		removeObserver(theObserver,theName);
		// Add the new entery
		l.addInPlace(
			new TOMCreateObserverItem(theObserver, theMask, theName) );
	}
	void removeObserver(TOMUniversalObserver* theObserver, char* theName);
	void notifyNewItem();
};

extern TOMCreateObserver* createObserver;

//
//	 Actual observers:
//	Case Animator: There are many observers. one of them is proxyConsole
//					each observer should register with the items it observes
//	Case Tracer: There is a single observer "proxyConsole" it should register
//				but it is not kept as a list or pointer. Rather its
//				interest mask the "myMask" of the observed object
//

class RP_ANIM_DLL TOMShowObserver : public TOMUniversalObserver {
	TOMProxyItem * myObserved;
	TOMUniversalObserver * myObserver;
	OMInterestMask myMask;
public:
	TOMShowObserver(TOMProxyItem * theObserved,
					TOMUniversalObserver * theObserver,
					int theMask);

	TOMUniversalObserver * getObserver() { return myObserver; }
	OMBoolean toRemove() const { return !myMask.isInteresting(); }
	void removeYourSelf();

	void notifyItemDeleted(const TOMProxyItem* ) {
		// Possibly should notify "myObserver" as well
		delete this;
	}

	void notifyClassValues(TOMClass *);
	void notifyStateConfiguration(const TOMInstance *,
								  OMList<OMHandle *>*,
								  OMBoolean);
	void notifyRelationsValues(TOMInstance* item);
	void notifyAttributeValues(OMList<TOMAttributeItem *> *, 
							   const TOMProxyItem *, 
							   OMBoolean);
	void notifyCallStackValues(OMSData *);
	void notifyEventQueueValues(OMSData *);

};

#ifdef OMTRACER
// tommask.c contains the "actual" entry for this
extern TOMUniversalObserver * proxyConsole;
#endif

#ifdef OMANIMATOR
#define NOTIFY_OBSERVERS(theMask,theNotify) {						\
	for(OMIterator<TOMMaskedObserver*> i(observerList); *i; ++i)	\
		if ((*i)->getMask().toInt() & (theMask))					\
			(*i)->getObserver()->theNotify;							\
}
#endif
#ifdef OMTRACER
#define NOTIFY_OBSERVERS(theMask,theNotify)							\
	if (myMask.toInt() & (theMask)) if (proxyConsole!=NULL) proxyConsole->theNotify;
#endif

#ifdef OMANIMATOR
#define SAFE_NOTIFY_OBSERVERS(theMask,theNotify) {					\
	OMList<TOMMaskedObserver*> tmpList;								\
    OMIterator<TOMMaskedObserver*> i(observerList);					\
	for(; *i; ++i)													\
		tmpList.add(*i);											\
	OMIterator<TOMMaskedObserver*> tmpPos(tmpList);					\
	TOMUniversalObserver* obs = NULL;								\
	for (; *tmpPos; ++tmpPos)										\
	{																\
		if ((*tmpPos)->getMask().toInt() & (theMask))				\
		{															\
			obs = (*tmpPos)->getObserver();							\
			if (obs != NULL)										\
				obs->theNotify;										\
		}															\
	}																\
}
#endif
#ifdef OMTRACER
#define SAFE_NOTIFY_OBSERVERS(theMask,theNotify)					\
	NOTIFY_OBSERVERS(theMask,theNotify)
#endif

#define MAKE_SHOW_OBSERVER(this, obs, theMask)	\
		new TOMShowObserver(this, obs, theMask);


#define NOTIFY_SHOW_OBSERVERS(theNotify) {						\
	OMList<TOMShowObserver*> toRemove;					        \
	OMIterator<TOMShowObserver*> iter(showObserverList);	    \
	for(; *iter; ++iter) {	                                    \
		(*iter)->theNotify;										\
		if ((*iter)->toRemove()) toRemove.add(*iter);			\
	}															\
	for(iter.reset(toRemove); *iter; ++iter)					\
			(*iter)->removeYourSelf();							\
}

//
// $Log: tomobs.h $
// Revision 1.31  2007/03/11 13:14:44  ilgiga
// Change copyright comment
// Revision 1.30  2007/03/04 15:07:33  ilgiga
// Telelogic instead of i-Logix
// Revision 1.29  2007/01/25 14:25:00  ilgiga
// Part of bug fix 99308
// Revision 1.28.2.2  2007/01/25 12:49:29  ilgiga
// part of bug fix 99308
// Revision 1.28  2000/08/17 13:49:49  Eldad
// Avoid a crash when deleting the current pos element from the list.
// bug 37143
// Revision 1.27  2000/08/14 12:49:20  Eldad
// fix build
// Revision 1.25  2000/08/03 14:10:03  builder
// Fix for Unix compiler
// Revision 1.24  1999/11/08 15:09:37  zvika
// Add DLLs.
// Revision 1.23  1998/12/08 15:03:39  beery
// 28098: check if proxyConsole is not NULL
// Revision 1.22  1998/11/19 17:56:45  beery
// Revision 1.21  1998/08/02 15:06:31  beery
// changing boolean->OMBoolean
// Revision 1.20  1997/09/11 05:38:28  yachin
// createObserver - no longe rallow multiple registries on the same object by the same observer
// Revision 1.19  1997/07/20 11:36:39  yachin
// Adding globals to animation
// Revision 1.18  1997/06/09 09:14:54  nili
// define variables out of the for-loop block
// since it is used after the for-loop 
// tomattr.cpp tomobs.h tomstep.cpp
// Revision 1.17  1997/03/31 08:44:14  yachin
// Fix Warning for Unix
// Revision 1.16  1997/01/21 11:08:47  yachin
// changed _int32 to int
// Revision 1.15  1996/12/30 10:06:23  yachin
// Revision 1.14  1996/12/30 09:56:47  yachin
// Multi Thread support part III
// Revision 1.13  1996/12/24 12:13:59  yachin
// change i++ to ++i
// Revision 1.12  1996/12/19 13:15:13  yachin
// Revision 1.11  1996/11/24 12:40:41  yachin
// Revision 1.10  1996/10/24 12:56:39  yachin
// Rewrite of observer registration mechanism + new instance iterators
// Revision 1.9  1996/10/15 13:29:57  yachin
// add mask and break options to interface
// Revision 1.8  1996/10/09 07:37:09  yachin
// Revision 1.7  1996/10/01 07:48:58  yachin
// Revision 1.6  1996/10/01 06:56:22  yachin
// Fixing the "show class all" bug
// Revision 1.5  1996/09/30 10:05:30  yachin
// Revision 1.4  1996/09/26 09:01:53  yachin
// Fix bug wiht interest masks
// Change instance count to star tat 0
// Revision 1.3  1996/09/19 08:04:07  yachin
// Proper deletion when animation is terminated
// Revision 1.2  1996/09/16 09:28:33  yachin
// Revision 1.1  1996/09/08 13:29:47  yachin
// Initial revision
// Revision 1.5  1996/09/04 13:16:08  yachin
// Connect with Israel
// Revision 1.4  1996/09/03 12:01:15  yachin
// Alow show #callStack
// Revision 1.3  1996/08/28 05:38:08  ofer
// Revision 1.2  1996/08/06 12:55:55  yachin
// Revision 1.1  1996/08/06 12:53:21  yachin
// Initial revision
//

#endif
