#ifndef tomlist_H
#define tomlist_H "$Id: tomlist.h 1.26 2007/03/11 13:14:43 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomlist.h $
//	file version:	$Revision: 1.26 $
//
//	purpose:	TOM List and derived class (proxy relations, proxy classes)
//
//	author(s):	  Yachin Pnueli
//	date started:	25.7.96
//	date changed:	$Date: 2007/03/11 13:14:43 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "toxf.h"

enum TOMListType {
	tomRelation				= 0x02,
	tomRelationSingleton	= 0x03,
	tomComposite			= 0x04,
	tomCompositeSingleton	= 0x05,
	tomClass				= 0x08,
	tomClassSingleton		= 0x09,
	tomOther				= 0x10,
	tomOtherSingleton		= 0x11
};


const int	tomSingletonMask	= 0x01;

//
//	TOMList - a proxy item which is a list of other items
//
class TOMInstance;
class TOMProxy;

class RP_ANIM_DLL TOMList: public OMList<TOMInstance *> {
protected:
	char * name;  // by default not self owned
	TOMListType listType;

	static TOMListType getType(TOMListType mask, OMBoolean isSingleton) {
		if (isSingleton)
			return (TOMListType)( (int)mask | tomSingletonMask);
		else
			return mask;
	}

	// Constructor methods - can only create "derived" instances
	TOMList(char* theName , TOMListType theType) {
		name = theName;
		listType = theType;
	}

	TOMProxyItem* finishName2Item(char *& , TOMInstance*) const;
	TOMInstance* hashExpression2Item(char *& name) const;
	TOMInstance * getInstanceByRelativeMultiplicity(int multiplicity) const;
public:
	virtual ~TOMList() { }
	OMBoolean singleton() const { return ((listType & tomSingletonMask) != 0); }
	OMBoolean composite() const { return ((listType & tomComposite) != 0); }
	int getListType() const { return listType; }
	char * getName() const { return name; }

	virtual void registerItem(TOMInstance *i);
	void deregisterItem(TOMInstance *i) { remove(i); }

	void update(TOMSData *s, OMSPosition& p);


	virtual TOMProxyItem* name2Item(char *& name) const;
};

//
//	TOMRelation - a proxy item of a relation (of one instance
//
class RP_ANIM_DLL TOMRelation : public TOMList {
public:
	TOMRelation(char * theName, OMBoolean isSingle)
		:TOMList(theName, getType(tomRelation,isSingle)) { }
};


//
//	Name Giver - a TOMList that also gives names to its "items".
//
const int TOMNoMultiplicity = (-1);

class RP_ANIM_DLL TOMNameGiver : public TOMList {
protected:
	int nameCounter; // Used to generate new names from myName

	TOMNameGiver(char * theName, TOMListType theListType)
		:TOMList(theName, theListType) { nameCounter = 0; }
	int giveMultiplicity() { 
		if (singleton())
			return TOMNoMultiplicity;
		else
			return nameCounter++;
	}
	TOMInstance* absExpression2Item(char *& name) const;
public:
	virtual ~TOMNameGiver() { }
	virtual TOMProxyItem* name2Item(char *& name) const;
};

//
//	TOMCompositeLink	-	The Proxy of a composite link (a name giver
//
class RP_ANIM_DLL TOMCompositeLink : public TOMNameGiver { // A Composite Link Name giver
	TOMProxyItem* owner;
public:
	virtual ~TOMCompositeLink() { }
	TOMCompositeLink(char * theName, OMBoolean isSingle,
						TOMProxyItem * theOwner)
		:TOMNameGiver(theName, getType(tomComposite,isSingle)) {
		owner = theOwner;
	}
	virtual void registerItem(TOMInstance *i);
};




//
// $Log: tomlist.h $
// Revision 1.26  2007/03/11 13:14:43  ilgiga
// Change copyright comment
// Revision 1.25  2007/03/04 15:07:32  ilgiga
// Telelogic instead of i-Logix
// Revision 1.24  2004/06/27 15:30:16  amos
// move to model-based oxf in RiC++
// Revision 1.23.1.2  2004/02/09 08:56:42  amos
// changes due to OMBoolean type change
// Revision 1.23.1.1  1999/11/08 15:09:36  amos
// Duplicate revision
// Revision 1.22  1999/10/12 13:33:01  yachin
// Fix bugs
// Revision 1.21  1999/02/16 05:56:57  yachin
// Speed up of constructors
// Revision 1.20  1998/08/02 15:07:42  beery
// Revision 1.19  1997/04/09 11:19:02  ofer
// remove class information from method decalaration
// (gnu 2.51 warning)
// tomlist.h
// Revision 1.18  1997/03/04 11:52:14  yachin
// added namegiver::name2item + consequences
// Revision 1.17  1997/02/11 12:54:36  yachin
// Adding Name spaces
// Revision 1.16  1997/01/21 11:08:46  yachin
// changed _int32 to int
// Revision 1.15  1996/12/24 06:29:28  yachin
// Revision 1.14  1996/12/22 09:03:24  yachin
// Has composite notify componentes abou tits new name
// Revision 1.13  1996/11/24 12:40:39  yachin
// Revision 1.12  1996/10/23 10:10:02  yachin
// Revision 1.11  1996/10/09 07:37:07  yachin
// Revision 1.10  1996/10/02 08:40:54  yachin
// Hopefully fixed "early" relation registration bug
// Revision 1.9  1996/10/01 11:42:54  yachin
// Fix registraction bug in relations
// Revision 1.8  1996/09/26 09:01:47  yachin
// Fix bug wiht interest masks
// Change instance count to star tat 0
// Revision 1.7  1996/09/16 13:44:33  yachin
// Revision 1.6  1996/09/08 13:28:57  yachin
// Registeration of items which do not yet exist
// Revision 1.5  1996/09/05 13:35:56  yachin
// Revision 1.4  1996/08/28 05:38:08  ofer
// Revision 1.3  1996/08/08 08:23:29  yachin
// Revision 1.2  1996/08/06 12:55:56  yachin
// Revision 1.1  1996/08/06 12:53:23  yachin
// Initial revision
//

#endif
