#ifndef tomclass_H
#define tomclass_H "$Id: tomclass.h 1.47 2007/03/11 13:14:41 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomclass.h $
//	file version:	$Revision: 1.47 $
//
//	purpose:	Super class of all Tracer "class" items
//
//	author(s):	  Yachin Pnueli
//	date started:	27.5.96
//	date changed:	$Date: 2007/03/11 13:14:41 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "tomlist.h"
#include "tomproxy.h"
#include <oxf/omstack.h>


class AnimMessage;

class TOMClassIteratorPair;
class TOMPackage;
class TOMOperation;

class RP_ANIM_DLL TOMNameSpaced: public TOMProxyItem {
	friend class TOMClassIteratorPair;
	OMBoolean unique;
protected:
	OMList<TOMNameSpaced *> mySuperClasses;
	OMList<TOMNameSpaced *> mySubClasses;

	TOMNameSpaced(	char * theName, 
					OMProxyType theType,
					TOMProxyItem *const theContext)
		:TOMProxyItem(	theName,
						theType,
						theContext) {
		unique = TRUE;
	}
	TOMNameSpaced(	void * theReal, 
					char * theName, 
					OMProxyType theType,
					TOMProxyItem *const theContext)
		:TOMProxyItem(	theReal,
						theName,
						theType,
						OMNoInterest,
						theContext) {
		unique = TRUE;
	}
public:
	virtual ~TOMNameSpaced() { }
	void notifyNonUnique() { unique = FALSE; }
	OMString& outputFullName(OMString& s, 
				const TOMProxyItem * theContext = OMSystemContext) const;
	OMString& outputFullFullName(OMString& s, 
				const TOMProxyItem * theContext = OMSystemContext) const;
	virtual TOMPackage* getPackage() const {
		return (TOMPackage*)myContext; // assumes no class in class
	}

	void notifySubClass(TOMNameSpaced * sub) { mySubClasses.add(sub); }
	void notifySuperClasses();
	void getSuperClassList(TOMSData* s, OMSPosition& p);

	inline const OMList<TOMNameSpaced *>& getMySuperClasses() { return mySuperClasses; }
};

class TOMEventClass: public TOMNameSpaced {
public:
	TOMEventClass(	void * theReal, 
					char * theName, 
					TOMProxyItem *const theContext)
		:TOMNameSpaced(theReal,theName,omProxyEventClass,theContext){}
	~TOMEventClass() {
		// Class currently owns its name
		delete[] myName;
	}

};

//
//	TOMClass	-	The Proxy Classes
//

class RP_ANIM_DLL TOMClassNameGiver : public TOMNameGiver {
public:
	friend class TOMClass;
    TOMClassNameGiver(char * theName, 
			 OMBoolean isSingleton):
	TOMNameGiver(theName, TOMNameGiver::getType(tomClass,isSingleton)){}	
	int getNameCounter() { return nameCounter;}
};

class RP_ANIM_DLL TOMClass : public TOMNameSpaced {

	OMList<char *> myRelations;
	OMBoolean _isImplicit;

	int myDefaultMask() const { return OMExistInterest; }
	void registerItem(TOMInstance *, TOMSData*);
	// This should never be called - its here to avoid a "hide" warning
	void registerItem(TOMInstance *);
	void update(TOMSData *s, OMSPosition& p); // update myself from message
	void _showYourself(TOMUniversalObserver* obs, int& theMask);
public:
	virtual ~TOMClass();
	TOMClass(void * theReal,
			 char * theName, 
			 OMBoolean isSingleton,
			 OMBoolean isImplicit,
			 TOMProxyItem *const theContext):
			TOMNameSpaced(theName, omProxyClass, theContext),
			tomNameGiver(theName, isSingleton)
		  { 
		_isImplicit = isImplicit;
		// Must do setReal here to preserve the virtual myDefaultMask
		setReal(OMExistInterest, theReal);
	}
	
	
	TOMClassNameGiver *getTomNameGiver() { return & tomNameGiver; }

	OMList<TOMOperation *>* findPossibleOperationsToCall(const OMString& opName, const int numOfArgs, const OMString& signature);

	OMList<TOMOperation *> operationList;

	const OMList<TOMOperation *>& getOpList() {return operationList; }

	OMBoolean hasStaticOperationToCall();

	void handleMessage(OMNotify r, TOMSData* s, OMSPosition p);
	virtual void handleMessage(AnimMessage*); 

	int getCount(int theMask = OMNoInterest);
	OMBoolean isImplicit() const { return _isImplicit; }

	void setRelations(OMList<TOMList *>*);
	const OMList<char *> * getRelations() const { return &myRelations; }

	// Observer Handling methods
	virtual void registerObserver(TOMUniversalObserver* obs,
									OMInterestMask theMask);
	virtual void reRegisterObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	virtual void addToObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	virtual void subtractFromObserver(TOMUniversalObserver* obs,
									OMInterestMask newMask);
	virtual void deregisterObserver(TOMUniversalObserver * obs,
									OMInterestMask mask = OMAllInterest);
	// mask with OMSubClassInterest also deregisters from subclasses
	// mask with OMInstanceInterest also deregisters from instances

	virtual OMBoolean showYourself(TOMUniversalObserver* obs,
								 int theMask);

	TOMProxyItem* name2Item(char *& name) const;

	// accept a visitor, and execute its wishes
	virtual void accept(TOMProxyVisitor1Arg & visitor);

	void destroyInstance(TOMInstance* destroyed, TOMInstance* destroyer);
#ifdef OMANIMATOR
	// this is used to revtrieve an expression to create IHandle 
	// that will uniquely identify the corresponding IClass in
	// the repository (this format is internal for Rhapsody)
	// Example: P1::P2::P3::C1#C2#C3
	OMString getRhpFullPathStr(bool assumePart = false) const;
	
#endif

protected :
	TOMClassNameGiver tomNameGiver;
};


class RP_ANIM_DLL TOMClassIteratorPair:private OMIterator<TOMNameSpaced *> {
public:
	TOMClassIteratorPair(TOMClass * theClass) {
		reset(theClass->mySubClasses);
	}
	TOMClass * getNextClass();
};

class RP_ANIM_DLL TOMClassIterator: public OMIterator<TOMInstance *> {
private:
	TOMClass * myClass;
	OMStack<TOMClassIteratorPair *> classIter;
	void advanceToNextNonEmptyClass();
	void clearMe();
	TOMClass * getNextClass();

	TOMClassIterator operator++(int)	{
		// Strictly speaking this is incorrect
		// But works if i++ is used alone
	  return increment();
	}
public:
 	TOMClassIterator(TOMClass *theClass) { reset(theClass); }
 	~TOMClassIterator() { clearMe(); }
	TOMClassIterator& increment();
	TOMClassIterator& operator++()	{ return increment(); }

	void reset(){ reset(myClass); }
	void reset(TOMClass* theClass){ reset(*theClass); }
	void reset(TOMClass& theClass);
};

//
// $Log: tomclass.h $
// Revision 1.47  2007/03/11 13:14:41  ilgiga
// Change copyright comment
// Revision 1.46  2007/03/04 15:07:30  ilgiga
// Telelogic instead of i-Logix
// Revision 1.45  2006/10/31 08:58:50  ccohen
// support running multiple animation processes.
// Revision 1.44  2003/10/08 15:11:35  eldad
// Added special treatment for implicit object for finding classes.
// Revision 1.43  2003/10/02 09:37:51  eldad
// Added getRhpFullPathStr() in facour of Rhapsody GUI to locate 
// the proper IClass.
// Revision 1.42.1.1  2003/05/26 11:06:21  eldad
// Duplicate revision
// Revision 1.41  2002/07/29 09:41:46  Eldad
// Anim Operations Calls.
// Revision 1.40  2002/05/15 14:55:25  Eldad
// To main branch.
// Revision 1.39.1.2  2002/05/13 08:56:41  Eldad
// myName leak.
// Revision 1.39.1.1  1999/11/08 15:09:34  Eldad
// Duplicate revision
// Revision 1.38  1999/10/12 13:33:00  yachin
// Fix bugs
// Revision 1.37  1999/03/08 11:06:19  ofer
// change myDefaultMask method to take OMExistIntereset ONLY
// this solve the problem of newly created instances sending off their 
// attributes before they are initialized.
// Done by yachin
// Revision 1.36  1999/02/16 05:56:53  yachin
// Speed up of constructors
// Revision 1.35  1998/11/23 17:39:34  beery
// Revision 1.34  1998/11/22 14:17:22  beery
// Revision 1.33  1998/11/17 12:15:26  beery
// Revision 1.32  1998/08/02 15:07:41  beery
// Revision 1.31  1998/05/21 11:24:04  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.30  1998/04/02 06:02:18  yachin
// Revision 1.29  1997/04/09 12:13:02  ofer
// calling delete myNmae instead of TOMProxyItem::myName
// since the gnu 2.51 ( under VxWorks environment does not like it)
// tomclass.cpp/h
// Revision 1.28  1997/03/31 10:00:39  yachin
// Fix Unizx warnings
// Revision 1.27  1997/03/13 13:41:36  yachin
// Fix memory leaks
// Revision 1.26  1997/02/21 07:22:03  yachin
// Fix event inheritance bug 2529
// Revision 1.25  1997/02/12 11:15:38  yachin
// Rewrite of TOMProxyItem(...)
// Revision 1.24  1997/02/11 12:54:33  yachin
// Adding Name spaces
// Revision 1.23  1997/01/22 11:54:08  yachin
// Inverse composite relation bug fix
// Revision 1.22  1997/01/21 11:08:45  yachin
// changed _int32 to int
// Revision 1.21  1997/01/19 11:19:49  yachin
// Revision 1.20  1996/12/22 09:03:22  yachin
// Has composite notify componentes abou tits new name
// Revision 1.19  1996/11/24 12:40:36  yachin
// Revision 1.18  1996/11/05 13:45:34  yachin
// Change getType to non virtual add myType attribute
// Revision 1.17  1996/10/24 12:56:38  yachin
// Rewrite of observer registration mechanism + new instance iterators
// Revision 1.16  1996/10/23 12:06:30  yachin
// added getCount(omwithdescnedents)
// Revision 1.15  1996/10/22 12:04:58  yachin
// Revision 1.14  1996/10/14 13:26:18  yachin
// Handle sub classes and set/cancel timeout
// Revision 1.13  1996/10/09 07:37:05  yachin
// Revision 1.12  1996/09/30 10:05:28  yachin
// Revision 1.11  1996/09/16 09:43:36  yachin
// Revision 1.10  1996/09/16 09:28:29  yachin
// Revision 1.9  1996/08/29 11:27:36  ofer
// Revision 1.8  1996/08/12 12:28:48  yachin
// Unified Interface for "file" and "stdin". seperated show from trace
// Revision 1.7  1996/08/08 08:23:27  yachin
// Revision 1.6  1996/08/06 12:52:05  yachin
// Version for Prototype 4
// Revision 1.5  1996/07/22 11:30:28  yachin
// Revision 1.4  1996/07/10 05:50:08  yachin
// Reprecussion of reorganizatio nof AOM
// Revision 1.3  1996/07/04 12:38:48  yachin
// Bug fixes and handleing static methods
// Revision 1.2  1996/06/19 10:21:25  yachin
// Revision 1.1  1996/06/17 05:40:40  yachin
// Initial revision
//

#endif
