#ifndef tomabso_H
#define tomabso_H "$Id: tomabso.h 1.42 2007/06/10 07:49:37 ilelpa Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/tom/rcs/tomabso.h $
//	file version:	$Revision: 1.42 $
//
//	purpose:	The Abstruct observer classes
//		Responsibilities:
//		Define the "notify methods" each "proxyTool" observer may have
//
//	author(s):	  Yachin Pnueli
//	date started:	31.7.96
//	date changed:	$Date: 2007/06/10 07:49:37 $
//	last change by:	$Author: ilelpa $
//
//	(c) Copyright Telelogic 1995, 2007
//
//
//	TOMAbstructObserver classes 
//
#include "toxf.h"

class OMSData;
class TOMProxyItem;
class TOMClass;
class TOMInstance;
class TOMList;
class TOMAttributeItem;
class TOMState;
class TOMBreakPointManager;
class TOMThread;
class TOMPackage;
//
//	This file summerizes all possible TOM notifications
//	Real observers should inheret for TOMUniversalObserver
//	and over Ride those notifications wihch they need.
//
//	Notifications are categorized into:
//	"mult1" - those which are "pushed" just once
//	"mult2" - those which are "pushed" possibly twice (say methodCalled
//				which is notified both in the caller and in the called items
//	"show" - those which are delivered on request (response to a show command)
//
//

class RP_ANIM_DLL TOMUniversalObserver {
public:
	// Mult = 1
	virtual void notifyGotControl(const TOMProxyItem * /* theItem */) { }
	// Mult = 1
	virtual void notifyLostControl(const TOMProxyItem * /* theItem */) { }

	// Mult = 2
	virtual void notifyInstanceCreated(const TOMInstance * /* theCreated */,
									   const TOMInstance * /* itsCreator */) { }
	// Mult = 2
	virtual void notifyInstanceDeleted(const TOMInstance * /* theDeleted */,
									   const TOMInstance * /* itsDestructor */) { }
	// Mult = 1
	virtual void notifyItemDeleted(const TOMProxyItem * /* theDeleted */) { }
	// Mult = 1
	virtual void notifyInstanceFound(const TOMInstance* /* item */) { }
 	// Show
	virtual void notifyClassValues(TOMClass *) { }


	// Mult = 1
	virtual void notifyTerminationReached(const TOMInstance *) { }
	// Mult = 1
	virtual void notifyEnteredState(const TOMInstance *, char *) { }
	// Mult = 1
	virtual void notifyExitedState(const TOMInstance *, char *) { }
	// Show - this might change depending on Statechart proxy
	virtual void notifyStateConfiguration(const TOMInstance *,
								  OMList<OMHandle *>*,
								  OMBoolean) { }
	// Mult = 1
	virtual void notifyBehaviorStep(
		OMList<OMHandle *>* /* currentStates */,
		OMList<OMHandle *>* /* previousStates */,
		OMList<OMHandle *>* /* currentTransitions */,
		OMBoolean /* isTerminated */) { }

	// Mult = 1
	virtual void notifyRelationConnected(const TOMInstance* ,
								 OMHandle* ,
								 const TOMInstance* ,
								 OMBoolean ,
								 OMBoolean ) { }
	// Mult = 1
	virtual void notifyRelationDisconnected(const TOMInstance* ,
									OMHandle* ,
									const TOMInstance* ) { }
	// Mult = 1
	virtual void notifyRelationCleared(const TOMInstance* /* owner */, 
							   OMHandle* /* relationName */) { }
	// Show
	virtual void notifyRelationValues(TOMList*, const TOMInstance*) { }
	// Show 
	virtual void notifyRelationsValues(TOMInstance* /* item */) { }
	// Mult = 1
	virtual void notifyNewName(TOMInstance* /* item */, OMString* /* oldName */){ }
	// Mult = 1
	virtual void notifyInverseCompositeRelationConnected(
		const TOMInstance* /* item */, const TOMProxyItem* /* relationOwner */) { }


	// Mult = 1/ Show
	virtual void notifyAttributeValues(OMList<TOMAttributeItem *> *, 
							   const TOMProxyItem *, 
							   OMBoolean) { }

	// Mult = 2
	virtual void notifyMethodCalled(TOMInstance* /* caller */,
									TOMInstance* /* called */,
									OMString /* method */,
									OMMethodType) { }
	// Mult = 2
	virtual void notifyMethodReturned(TOMInstance* /* caller */,
									  TOMInstance* /* called */,
									  OMString /* method */,
									  OMMethodType) { }
	// Show
	virtual void notifyCallStackValues(OMSData *) { }

	// Mult = 2
	virtual void notifyEventSent(	TOMInstance * /* sender */,
									TOMInstance * /* receiver */,
									OMString /* event */,
									void* /* eventId */) { }
	// Mult = 2
	virtual void notifyEventReceived(TOMInstance * /* sender */,
									 TOMInstance * /* receiver */,
									 OMString /* event */,
									 void* /* eventId */) { }
	// Show
	virtual void notifyEventQueueValues(OMSData * /* msg */) { }
	virtual void notifyEventQueueNull() { }

	// Mult = 1
	virtual void notifyTimeoutSet(	TOMInstance * /* item */,
									OMString /* event */,
									void* /* eventId */) { }
	// Mult = 1
	virtual void notifyEventCancelled(TOMInstance * /* item */,
									OMString /* event */,
									void* /* eventId */) { }
	// Mult = 1 Currently unUsed
	virtual void notifyTimeoutReceived(TOMInstance * /* item */,
									OMString /* event */,
									void* /* eventId */) { }

	virtual void notifyBreakPointActive(OMNotify /* theType */, 
									    TOMProxyItem * /* theItem */, 
									   const char * /* theData */) { }
	// Show
	virtual void notifyBreakPointValues(TOMBreakPointManager*) { }

	// Mult = 1
	virtual void notifyLostFocus(const TOMProxyItem * /* theItem */) { }
 	// Show
	virtual void notifyThreadValues(OMList<TOMThread *>*) { }
	// Show
	virtual void notifyEventValues(TOMPackage*) { }

	// Mult = 1
	// This method is called whenever the AnimationBar becomes active 
	// (i.e. the system is waiting for an external stimuli)
	// Currently this is only relevant for animation, the notification won't
	// be sent in tracing.
	virtual void notifyReadyForInput() { }

	// notifies when an operation call request is sent.
	// this is used by test conductor to issue the go command
	// to process the operation
	virtual void notifyOpCallRequestSent() { }

	// used for notification of foreign messages
	virtual void notifyForeignMessage(OMString& /* payload */) { }

	// to notify AnimOpReturn
	virtual void notifyOpReturn(OMString& /*retValStr*/, OMList<OMString>& /*nameValList*/) { }

	// to notify that the application is idle
	virtual void notifyApplicationIdle() { }

	// to notify that time has changes (assuming timestamp was turned on)
	virtual void notifyTimeChange(timeUnit /* time */) { }

	// notification of timer messafes with all details
	void notifyTimer(timeUnit /*delay*/, timeUnit /*actualDelay*/, timeUnit /*elapsedTime*/) { }

	// notify a CALL request returned, cmdStr - the request, retValStr - a string of the return value
	// exception - true if an exception was raised
	virtual void notifyOpCallReply(OMString /* cmdStr */, OMString /* retValStr */, OMBoolean /* exception */ ) { }
};


//
// $Log: tomabso.h $
// Revision 1.42  2007/06/10 07:49:37  ilelpa
// Fixed timer service for OSC
// Revision 1.41  2007/03/21 14:22:51  ilelpa
// Added a notification for operation call reply
// Revision 1.40  2007/03/11 13:14:40  ilgiga
// Change copyright comment
// Revision 1.39  2007/03/04 15:07:29  ilgiga
// Telelogic instead of i-Logix
// Revision 1.38  2007/02/08 10:38:37  ilelpa
// Added the ability to get time notifications to observer. This is used for test conductor
// to get the time from Rhapsody instead of relying on the OS clock.
// Revision 1.37  2004/06/07 12:02:31  eldad
// To main branch (notifyApplicationIdle())
// Revision 1.36.1.2  2004/06/07 07:44:51  eldad
// Revision 1.36  2003/05/15 07:01:59  Eldad
// Serailization of output params and return value
// Revision 1.35.1.1  2003/05/08 10:07:43  Eldad
// Duplicate revision
// Revision 1.34.1.1  2002/11/25 11:49:50  Eldad
// Duplicate revision
// Revision 1.33  2001/05/21 11:49:02  Eldad
// 1.32.1.2 to main branch.
// Revision 1.32.1.2  2001/05/17 09:48:13  Eldad
// Notification when user has control.
// Revision 1.32.1.1  2000/12/25 10:16:16  Eldad
// Duplicate revision
// Revision 1.31  1999/11/08 15:09:33  zvika
// Add DLLs.
// Revision 1.30  1999/10/12 13:32:59  yachin
// Fix bugs
// Revision 1.29  1999/02/16 05:56:51  yachin
// Speed up of constructors
// Revision 1.28  1998/08/02 15:07:37  beery
// Revision 1.27  1998/05/21 11:24:03  yachin
// Fix bug 5603 (have getPackage return a TOMPackage and not a TOMProxyItem)
// Revision 1.26  1997/07/20 11:36:35  yachin
// Adding globals to animation
// Revision 1.25  1997/02/21 08:56:41  yachin
// Added show #all events
// Revision 1.24  1997/02/16 09:19:55  yachin
// removed "theClass" from InstanceCreated and InstanceDeleted
// Revision 1.23  1997/01/27 09:41:53  yachin
// Enter foreign threads
// Revision 1.22  1997/01/13 11:38:54  yachin
// Make constructor/destructor mult=2 notifications
// Revision 1.21  1996/12/25 13:38:30  yachin
// Multi-Threading first shot
// Revision 1.20  1996/12/23 11:51:05  yachin
// Add ids to events
// Revision 1.19  1996/12/22 13:13:05  yachin
// Revision 1.17  1996/12/22 09:03:22  yachin
// Has composite notify componentes abou tits new name
// Revision 1.16  1996/11/24 12:40:34  yachin
// Revision 1.15  1996/10/21 11:39:24  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.14  1996/10/09 07:37:04  yachin
// Revision 1.13  1996/10/03 08:38:07  yachin
// Another fix for the "early relations"  bug
// Revision 1.12  1996/10/02 08:40:52  yachin
// Hopefully fixed "early" relation registration bug
// Revision 1.11  1996/10/01 11:42:52  yachin
// Fix registraction bug in relations
// Revision 1.10  1996/09/25 10:01:24  yachin
// notifyEventQueueValues added + assorted bug fixes
// Revision 1.9  1996/09/19 08:04:06  yachin
// Proper deletion when animation is terminated
// Revision 1.8  1996/09/17 13:42:59  yachin
// Revision 1.7  1996/09/16 09:28:27  yachin
// Revision 1.6  1996/09/08 13:28:54  yachin
// Registeration of items which do not yet exist
// Revision 1.5  1996/09/04 13:16:08  yachin
// Connect with Israel
// Revision 1.4  1996/09/03 12:01:15  yachin
// Alow show #callStack
// Revision 1.3  1996/08/28 05:38:08  ofer
// Revision 1.2  1996/08/06 12:55:55  yachin
// Revision 1.1  1996/08/06 12:53:21  yachin
// Initial revision
//

#endif
