//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: BasicTypes
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/rawtypes.h $
//!	File version	: $Revision: 1.55 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:22 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef rawtypes_H 

#define rawtypes_H 

#ifdef OM_RHP50_API
#include "OXFCodeGen50.h"
#endif // OM_RHP50_API
#include "omiotypes.h"
#ifdef OM_STL
#include "OMValueCompare.h"
#endif
#include "OXFSelectiveInclude.h"
#include "OXFTypes.h"

//----------------------------------------------------------------------------
// rawtypes.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Types::BasicTypes 


// Basic framework implementation types definition.

// OMAPPLICATION indicates that the framework is used by a client application.
// OMOMATE indicates that the framework is used by Rhapsody.
//#[ type OMAPPLICATION 
#ifndef OMOMATE
// application
#ifndef OMAPPLICATION
#define OMAPPLICATION
#endif
#else
// check that there is no multiple definition
#ifdef OMAPPLICATION
// Protect against both flags 'on'
#error "'OMOMATE' and 'OMAPPLICATION' cannot be defined together"
#endif // OMAPPLICATION
#endif // OMOMATE
//#]

// Backward compatibility for spelling fix
//#[ type UseNullBlockContainter 
#ifdef UseNullBlockContainter
#ifndef OMUseNullBlockContainer
#define OMUseNullBlockContainer
#endif // OMUseNullBlockContainer
#endif // UseNullBlockContainter
//#]

// Selective include to OMString
//#[ type IncludeOMString 
#ifdef OMAPPLICATION
#include "omstring.h"
#endif // OMAPPLICATION
//#]

// Language independent boolean type supported by Rhapsody.
//## type RhpBoolean 
typedef bool RhpBoolean;

// Language independent character type supported by Rhapsody.
//## type RhpCharacter 
typedef char RhpCharacter;

// Language independent address type supported by Rhapsody.
//## type RhpAddress 
typedef void * RhpAddress;

// Language independent integer type supported by Rhapsody.
//## type RhpInteger 
typedef int RhpInteger;

// Language independent positive integer type supported by Rhapsody.
//## type RhpPositive 
typedef unsigned int RhpPositive;

// Language independent real number type supported by Rhapsody.
//## type RhpReal 
typedef double RhpReal;

// Language independent string type supported by Rhapsody.
//## type RhpString 
typedef OMString RhpString;

// Language independent natural number type supported by Rhapsody.
//## type RhpUnlimitedNatural 
typedef long RhpUnlimitedNatural;

// Language independent VOID type supported by Rhapsody.
//## type RhpVoid 
typedef void RhpVoid;

// Boolean type
//## type OMBoolean 
typedef RhpBoolean OMBoolean;

// OMBoolean false value
//#[ type FALSE 
#ifndef FALSE
#define FALSE false
#endif // FALSE
//#]

// OMBoolean true value
//#[ type TRUE 
#ifndef TRUE
#define TRUE true
#endif // TRUE
//#]

// OMitoa declaration
//#[ type OMitoa 
#ifndef OMitoa
extern void OMitoa(int val, char* str, int base = 10);
#endif // OMitoa 
//#]

// Compilation dependent addition of the inline keyword in the definition of template classes operations
//#[ type TMPL_INL 
#ifdef NEED_INLINE_IN_TEMPLATE
#define TMPL_INL inline
#else
#define TMPL_INL
#endif // NEED_INLINE_IN_TEMPLATE
//#]

// OMHandles - the "names" of various model objects.
//## type OMHandle 
typedef char OMHandle;

// default memory alignment
//#[ type OMRAW_MEMORY_ALIGNMENT 
#ifndef OMRAW_MEMORY_ALIGNMENT
#define OMRAW_MEMORY_ALIGNMENT 8
#endif // OMRAW_MEMORY_ALIGNMENT
//#]

// dynamic memory allocation exists (new/delete)
//#[ type USE_DYNAMIC_MEMORY_ALLOCATION 
#ifndef OM_NO_DYNAMIC_MEMORY_ALLOCATION
#define USE_DYNAMIC_MEMORY_ALLOCATION
#endif // OM_NO_DYNAMIC_MEMORY_ALLOCATION
//#]

// A TimeUnit compatibility name
//## type timeUnit 
typedef OxfTimeUnit timeUnit;

// A reactive object default active context
//#[ type OMDefaultThread 
#define OMDefaultThread NULL
//#]

// set the _OMINSTRUMENT flag
//#[ type _OMINSTRUMENT 
#if (defined OMTRACER || defined OMANIMATOR)
#ifndef _OMINSTRUMENT
#define _OMINSTRUMENT
#endif // _OMINSTRUMENT
#endif // (defined OMTRACER || defined OMANIMATOR)
//#]

// AOM Argument declaration
//#[ type aomArg 
#ifdef _OMINSTRUMENT
#define aomArg(arg) arg
#else
#define aomArg(arg)
#endif // _OMINSTRUMENT
//#]

// Define omtypename to allow environment dependent usage of the typename keyword
//#[ type omtypename 
#ifndef OM_NO_TYPENAME_SUPPORT
#define omtypename typename
#else
// avoid the typename keyword
#define omtypename
#endif // OM_NO_TYPENAME_SUPPORT
//#]

// This macro definition is needed for backward compatibility
//#[ type OM_NEED_THROW_IN_NEW_OPERATOR 
#ifdef OM_NEED_THORW_IN_NEW_OPERATOR
#define OM_NEED_THROW_IN_NEW_OPERATOR
#endif // OM_NEED_THORW_IN_NEW_OPERATOR

//#]

// Definition of OM_NO_THROW that is translated to throw() when OM_NEED_THROW_IN_NEW_OPERATOR is defined and to 
// nothing otherwise.
//#[ type OM_NO_THROW 
#ifdef OM_NEED_THROW_IN_NEW_OPERATOR
#define OM_NO_THROW throw()
#else
#define OM_NO_THROW
#endif // OM_NEED_THROW_IN_NEW_OPERATOR
//#]

//#[ type OM_DECLARE_COMPOSITE_OFFSET 
#define OM_DECLARE_COMPOSITE_OFFSET char aomOffsetDataMember;

//#]




#endif  
//
//! Log: $Log: rawtypes.h $
//! Log: Revision 1.55  2007/04/06 07:08:22  ilgiga
//! Log: bug fix 98191
//


