//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMQueue
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omqueue.h $
//!	File version	: $Revision: 1.32 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:12 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omqueue_H 

#define omqueue_H 

#include "OMAbstractContainer.h"
#include "OMIterator.h"
#include "omlist.h"
#include "omcollec.h"

//----------------------------------------------------------------------------
// omqueue.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Containers::TypeSafe 


// A FIFO queue
// Implemented using a cyclic dynamic-array
//## class OMQueue 
template <class Concept> class OMQueue : public OMAbstractContainer<Concept> {
public :
    
        
        // The dynamic array type
        //## class OMQueue::Collection 
        typedef OMCollection<Concept> Collection;
        
    
//## class OMQueue 


////    Constructors and destructors    ////
public :
    
    // Initialize the queue with a given size and growth method (dynamic or static size)
    // Argument bool shouldGrow : 
    // dynamic size flag
    // Argument int initSize : 
    // the initial queue size
    //## operation OMQueue(bool,int) 
    OMQueue(bool shouldGrow = true, int initSize = 100) : m_grow(shouldGrow), m_head(0), m_myQueue(initSize), m_tail(0)
     {
        //#[ operation OMQueue(bool,int) 
        //#]
    }
    
    
    // copy constructor
    // Argument const OMQueue<Concept>& q : 
    // The queue to copy
    //## operation OMQueue(const OMQueue<Concept>&) 
    OMQueue(const OMQueue<Concept>& q) {
        //#[ operation OMQueue(const OMQueue<Concept>&) 
        copy(q);
        //#]
    }
    
    
    //## auto_generated 
    virtual ~OMQueue();


////    Operations    ////
public :
    
    // Get an element from the queue
    //## operation get() 
    inline virtual Concept get() {
        //#[ operation get() 
        Concept c = OMNullValue<Concept>::get();
        if (!isEmpty()) {
        	c = m_myQueue.getAt(m_head);
        	increaseHead_();
        } 
        return c;
        //#]
    }
    
    
    // Get the number of elements in the queue
    //## operation getCount() const 
    inline int getCount() const {
        //#[ operation getCount() const 
        if (m_tail >= m_head) {
        	return m_tail - m_head;
        }
        else {
        	return (getSize() - m_head) + m_tail;
        }
        //#]
    }
    
    
    // getQueue() returns the element which is the next to be returned by get() in the tail of the list
    // Argument OMList<Concept> & l : 
    // A list of the elements in the queue (out)
    //## operation getInverseQueue(OMList<Concept> & ) const 
    inline virtual void getInverseQueue(OMList<Concept> & l) const {
        //#[ operation getInverseQueue(OMList<Concept> & ) const 
        l.removeAll();
        if (isEmpty()) return;
        
        int first = (m_tail > m_head) ? m_head : 0;
        
        //copy first part
        int j;
        for (j = (m_tail - 1); j >= first; j--) {
        	l.add(m_myQueue.getAt(j));
        }
        
        // check if need to continue
        if (first == m_head) return;
        
        // copy second part
        for (j = (m_myQueue.getSize() - 1); j >= m_head; j--) {
        	l.add(m_myQueue.getAt(j));
        }
        //#]
    }
    
    
    // getQueue() returns the element which is the next to be returned by get() in the head of the list
    // Argument OMList<Concept> & l : 
    // The list of queue elements (out)
    //## operation getQueue(OMList<Concept> & ) const 
    inline virtual void getQueue(OMList<Concept> & l) const {
        //#[ operation getQueue(OMList<Concept> & ) const 
        l.removeAll();
        if (isEmpty()) return;
        
        int last = (m_tail > m_head) ? m_tail : m_myQueue.getSize();
        
        //copy first part
        int j;
        for (j = m_head; j < last; j++) {
        	l.add(m_myQueue.getAt(j));
        }
        
        // check if need to continue
        if (last == m_tail) return;
        
        // copy second part
        for (j = 0; j < m_tail; j++) {
        	l.add(m_myQueue.getAt(j));
        }
        //#]
    }
    
    
    // Get the size allocated for the queue
    //## operation getSize() const 
    inline int getSize() const {
        //#[ operation getSize() const 
        return m_myQueue.getSize();
        //#]
    }
    
    
    // Check if the queue is empty
    //## operation isEmpty() const 
    inline bool isEmpty() const {
        //#[ operation isEmpty() const 
        return (m_head == m_tail);
        //#]
    }
    
    
    // Check if the queue is full.
    //## operation isFull() const 
    inline bool isFull() const {
        //#[ operation isFull() const 
        if (m_grow) return false;
        if ((m_tail + 1 == getSize()) && (m_head == 0)) return true;
        return (m_tail + 1 == m_head);
        //#]
    }
    
    
    // Assignment operator
    // Argument const OMQueue<Concept>& q : 
    // The queue to copy
    //## operation operator=(const OMQueue<Concept>&) 
    inline OMQueue<Concept>&  operator=(const OMQueue<Concept>& q) {
        //#[ operation operator=(const OMQueue<Concept>&) 
        copy(q);
        return *this;
        //#]
    }
    
    
    // Add an element to the queue
    // Argument Concept c : 
    // The element to add
    //## operation put(Concept ) 
    inline virtual bool put(Concept c) {
        //#[ operation put(Concept ) 
        if (isFull()) return false;
        
        m_myQueue.addAt(m_tail, c);
        increaseTail_();
        return true;
        //#]
    }
    

protected :
    
    // Copy a queue
    // Argument const OMQueue<Concept>& q : 
    // the queue to copy
    //## operation copy(const OMQueue<Concept>&) 
    inline void copy(const OMQueue<Concept>& q) {
        //#[ operation copy(const OMQueue<Concept>&) 
        m_head = q.m_head;
        m_tail = q.m_tail;
        m_grow = q.m_grow;
        m_myQueue = q.m_myQueue;
        //#]
    }
    
    
    // Update the queue head position
    //## operation increaseHead_() 
    inline void increaseHead_() {
        //#[ operation increaseHead_() 
        if (isEmpty()) return;
        if (++m_head == m_myQueue.getSize()) m_head = 0;
        //#]
    }
    
    
    // Advance the queue tail position and grow (if needed).
    //## operation increaseTail_() 
    inline void increaseTail_() {
        //#[ operation increaseTail_() 
        ++m_tail;
        if (m_tail > m_head) {
        	if (m_tail == m_myQueue.getSize()) {
        		if (m_head > 0) m_tail = 0;
        		else if (m_grow) m_myQueue.reorganize();	// queu if full - grow
        		else {	// queue is full - don't grow
        			--m_tail;	
        			return;
        		}
        	}
        }
        else if (m_tail == m_head) {
        	if (!m_grow) {	// queue is full - don't grow
        		--m_tail;	
        		return;
        	}
        	// queu if full - grow
        	m_tail = m_myQueue.getSize();
        	m_myQueue.reorganize();
        	for (int j = 0; j < m_head; j++) {
        		Concept c = m_myQueue.getAt(j);
        		m_myQueue.addAt(m_tail, c);
        		increaseTail_();
        	}
        }
        //#]
    }
    

private :
    
    // Get the element at the given position (called by the iterator)
    // Argument void * pos : 
    // The iterator current position
    //## operation getCurrent(void *) const 
    inline Concept&  getCurrent(void * pos) const {
        //#[ operation getCurrent(void *) const 
        if (isEmpty())
        	return OMNullValue<Concept>::get();
        
        int i = (int)(unsigned long)pos;
        
        if ((m_head < m_tail) &&
        	((i < m_head) || (i >= m_tail)))
        {
        	// out of range (before head or after tail)
        	return OMNullValue<Concept>::get();
        }
        else if ((i < m_head) && (i >= m_tail)) {
        	// out of range (between head and tail)
        	return OMNullValue<Concept>::get();
        }
        
        return m_myQueue.getAt(i);
        //#]
    }
    
    
    // Set the initial position for the iterator
    // Argument void*& pos : 
    // The queue head position (out)
    //## operation getFirst(void*& ) const 
    inline void getFirst(void*& pos) const {
        //#[ operation getFirst(void*& ) const 
        pos = reinterpret_cast<void*>(m_head);
        //#]
    }
    
    
    // Update the provided position to the next position in the container
    // Argument void*& pos : 
    // The iterator position to advance
    //## operation getNext(void*& ) const 
    inline void getNext(void*& pos) const {
        //#[ operation getNext(void*& ) const 
        int i = reinterpret_cast<int>(pos);
        
        ++i;
        if (i == m_myQueue.getSize()) {
        	i = 0;
        }
        if (i == m_head) {
        	i = m_myQueue.getSize();
        }
        
        pos = reinterpret_cast<void*>(i);
        //#]
    }
    


////    Attributes    ////
private :
    
    // This flag indicates if the queue size should be dynamic (grow on demand) or static.
    bool m_grow;		//## attribute m_grow 
    
    // The queue head (elements are extracted from the head)
    int m_head;		//## attribute m_head 
    
    // The dynamic array used to implement the queue
    Collection m_myQueue;		//## attribute m_myQueue 
    
    // The queue tail (elements are added to the tail)
    int m_tail;		//## attribute m_tail 
    

};

//## class OMQueue 



template <class Concept> OMQueue<Concept> ::~OMQueue() {
}


//## class OMQueue::Collection 





#endif  
//
//! Log: $Log: omqueue.h $
//! Log: Revision 1.32  2007/04/06 07:08:12  ilgiga
//! Log: bug fix 98191
//


