//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMemoryManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/ommemorymanager.h $
//!	File version	: $Revision: 1.39 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:10 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef ommemorymanager_H 

#define ommemorymanager_H 

#include "IOxfMemoryAllocator.h"
#include "OXFMemoryManagerMacros.h"

//#[ ignore 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]
#include "OMMemoryManagerSwitchHelper.h"

//#[ ignore 
#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]

//----------------------------------------------------------------------------
// ommemorymanager.h                                                                  
//----------------------------------------------------------------------------

class OXF;

//## package Design::oxf::Services::MemoryManagement::Manager 


// The framework default memory manager, uses the global new/delete operators to get and return memory.
//## class OMMemoryManager 

//#[ ignore 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]
class RP_FRAMEWORK_DLL OMMemoryManager : public IOxfMemoryAllocator {


////    Constructors and destructors    ////
public :
    
    // constructor
    // Argument bool theFrameworkSingleton : 
    // Indicate that the _singletonDestroyed attribute should be reset.
    //## operation OMMemoryManager(bool) 
    OMMemoryManager(bool theFrameworkSingleton = false);
    
    // destructor
    //## operation ~OMMemoryManager() 
    virtual ~OMMemoryManager();


////    Operations    ////
public :
    
    // get the default (internal) memory manager
    //## operation getDefaultMemoryManager() 
    static IOxfMemoryAllocator* getDefaultMemoryManager();
    
    // get memory for an instance
    // Argument size_t size : 
    // The memory size (in bytes)
    //## operation getMemory(size_t) 
    virtual void * getMemory(size_t size);
    
    // get the actual memory manager
    //## operation getMemoryManager() 
    static IOxfMemoryAllocator* getMemoryManager();
    
    // Return the memory of the object
    // Argument void * object : 
    // The memory to return
    // Argument size_t /* size */ : 
    // The size of the returned object
    //## operation returnMemory(void *,size_t) 
    virtual void returnMemory(void * object, size_t /* size */);


////    Attributes    ////
private :
    
    // Singleton state flag, used to identify that the memory manager singleton was destroyed (while exit())
    static bool _singletonDestroyed;		//## attribute _singletonDestroyed 
    

};

//#[ ignore 

#endif // (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]



#endif  
//
//! Log: $Log: ommemorymanager.h $
//! Log: Revision 1.39  2007/04/06 07:08:10  ilgiga
//! Log: bug fix 98191
//


