// $Id: QNXOS.h 1.9 2003/05/01 13:09:54 gio Exp $
//
//	file name   :	$Source:      D:\Rhapsody\Share\LangCpp\oxf
//	file version:	$Revision: 1.9 $
//
//	purpose:	 	QNXOS implementations
//
//
//	author(s):
//	date started:
//	date changed:	$Date: 2003/05/01 13:09:54 $
//	last change by:	$Author:
//
//	(c) Copyright i-Logix Inc., 1995
//
// ---------------------------------------------------------------
//|                                QNXOS.h                        |
// ---------------------------------------------------------------

#ifndef _qnxos_H
#define _qnxos_H

#include <iostream.h>
#include <errno.h>
#include <signal.h>

#include <time.h>
#include <mqueue.h>
#include <semaphore.h>
#include <sys/sched.h>

#include "../qnx425_sources/oxf/omtypes.h"
#include "../qnx425_sources/oxf/os.h"
#include "../qnx425_sources/oxf/omlist.h"
#include "../qnx425_sources/oxf/omqueue.h"
#include "../qnx425_sources/oxf/omoutput.h"
#include "../qnx425_sources/oxf/qnx_425/pthread.h"
#include "../qnx425_sources/oxf/qnx_425/timers.h"

const int LowestPriority   = 0;
const int HeighestPriority = 63;
const int PRIO_NORMAL   = 30;
const int DEFAULT_STACK= 20000 ;

// forward declaration of classes
class QNXTimer;
class QNXThread;
class QNXMutex;
class QNXMessageQueue;
class QNXEventFlag;
class QNXSemaphore;
class QNXSocket;
class QNXConnectionPort;

/////////////////////////////////////////////////////////////////////////////////
///							QNXTimer Class							///
/////////////////////////////////////////////////////////////////////////////////

class QNXTimer : public OMOSTimer {
public:
	QNXTimer(timeUnit ptime, void pcbkfunc(void *), void *pparam); // TickTimer

	QNXTimer(void pcbkfunc(void *), void *pparam); 	   // IdleTimer (Simulated Time)

	virtual ~QNXTimer();

	virtual void* getOsHandle() const
	{
		return (void*) hThread;
	}

	static OMBoolean active ;
	static void terminate();

private:
	void (*cbkfunc)(void *);
	void waitThread();
	static void* bridge(void* me);
	int hThread;			// The timeTick thread
	timeUnit m_Time ;
	void *param;
	int ticks ; // how many OS ticks the timer wakes up
};


/////////////////////////////////////////////////////////////////////////////////
///							QNXThread Class							///
/////////////////////////////////////////////////////////////////////////////////

class QNXThread : public OMOSThread {
public:
	QNXThread(void tfunc(void *), void *param, const char* const name = NULL, const long stackSize = OMOSThread::DefaultStackSize);

	QNXThread(void *osThreadId); // for creation of wrapper thread

	virtual ~QNXThread();

	void setPriority(int pr);

	void suspend();

	void resume();

	void start();

	void setEndOSThreadInDtor(OMBoolean val)
	{
		endOSThreadInDtor = val;
	}

	virtual void* getOsHandle() const
	{
		return (void*) hThread;
	}

	virtual void* getOsHandle(void*& osHandle) const
	{
		osHandle = (void*) hThread ; return getOsHandle() ;
	}

	virtual void getThreadEndClbk(OMOSThreadEndCallBack * clb_p, // a pointer to the callback function
									void ** arg1_p,					// the argument for this function
									OMBoolean onExecuteThread);

	static void endMyThread(void *);

	static void endOtherThread(void *);

private:
	pthread_t hThread ;
	int isWrapperThread;

	OMBoolean endOSThreadInDtor; // TRUE means that the os thread is ended as part of this object's destruction

	// preExecFunc takes control upon contruction to suspend the task untill
	// it is activated by start
	static void preExecFunc(void* me);
	void (*m_ExecFunc)(void *);
	void* m_ExecParam;
	QNXEventFlag* m_SuspEventFlag;
};


/////////////////////////////////////////////////////////////////////////////////
///							QNXSemaphore Class						///
/////////////////////////////////////////////////////////////////////////////////

class QNXSemaphore : public OMOSSemaphore {
public:
	QNXSemaphore(unsigned long semFlags, unsigned long initialCount);
	~QNXSemaphore();

	// override of pure virtual
	virtual void signal();

	virtual OMBoolean wait(long timeout = -1);
	virtual void* getOsHandle() const { return (void*) &m_sem; }

private:
	sem_t m_sem;
	OMBoolean m_ok;
};


/////////////////////////////////////////////////////////////////////////////////
///							QNXMutex Class							///
/////////////////////////////////////////////////////////////////////////////////

//  :
//                          
//                       

class QNXMutex : public OMOSMutex {
public:

	QNXMutex();

	~QNXMutex();

	void lock();
	void unlock();

	//void* getHandle() { return (void *)&hMutex; }
	void* getHandle() { return (void *)&hMutex; }

	//virtual void* getOsHandle() const { return (void*) &hMutex; }
	virtual void* getOsHandle() const { return (void*) &hMutex; }

private:
	pthread_mutex_t hMutex;
	sem_t sem;

	long int		RecursiveCounter;		//  
	pthread_t		ThreadOwner;			// ThreadID  -  

};

/////////////////////////////////////////////////////////////////////////////////
///							QNXEventFlag Class						///
/////////////////////////////////////////////////////////////////////////////////

class QNXEventFlag : public OMOSEventFlag {
public:
	void signal();
	void reset();
	void wait(int tminms = -1);  // tminms = -1 is wait forever

	QNXEventFlag();

	~QNXEventFlag()
	{
		(void) sem_destroy(&hEventFlag);
	}

	void* getHandle()
	{
		return (void*) &hEventFlag;
	}

	virtual void* getOsHandle() const
	{
		return (void*) &hEventFlag;
	}

private:
	sem_t 	hEventFlag;
};





/////////////////////////////////////////////////////////////////////////////////
///						QNXMessageQueue Class							///
/////////////////////////////////////////////////////////////////////////////////

#ifdef OM_POSIX_QUEUES

class QNXMessageQueue : public OMOSMessageQueue {
public:
	static int mq_no;
	QNXMessageQueue(const long messageQueueSize = OMOSThread::DefaultMessageQueueSize);
	~QNXMessageQueue();
	OMBoolean put(void *, OMBoolean fromISR = FALSE);
	void *get();
	int isEmpty();
	void pend();
	static void cleanUpMessageQueues();

	void getMessageList(OMList<void*>& l);
	OMBoolean isFull();
	virtual void* getOsHandle() const
	{
		return (void*) hQNXMQ;
	}
	void Mq_name();
private:
	mqd_t hQNXMQ;
	void *pmessage ; // Buffer of a single lookahead message
	enum { dataReady, noData } m_State ;
	char name[20] ;
};
#else

class QNXMessageQueue : public OMOSMessageQueue {
public:
	QNXMessageQueue(OMBoolean shouldGrow = TRUE, int initSize = OMOSThread::DefaultMessageQueueSize):
		m_theQueue(shouldGrow, initSize)
	{
	}
	
	OMBoolean put(void *, OMBoolean fromISR = FALSE);
	void * get();
	void pend();
	void getMessageList(OMList<void*>& c);
	static void cleanUpMessageQueues();
	
	int isEmpty()
	{
		return m_theQueue.isEmpty();
	}
	
	OMBoolean isFull()
	{
		return m_theQueue.isFull();
	}
	
	virtual void* getOsHandle() const { return (void*) NULL; }

private:
	OMQueue<void*> m_theQueue;
	QNXMutex m_QueueMutex;
	QNXEventFlag m_QueueEventFlag; 
};
#endif
/////////////////////////////////////////////////////////////////////////////////
///								QNXOSFactory Class					///
/////////////////////////////////////////////////////////////////////////////////

class QNXOSFactory : public OMOSFactory {
// OSFactory hides the RTOS mechnisms for tasking and synchronization
public:
	virtual OMOSMessageQueue *createOMOSMessageQueue(
		OMBoolean /*shouldGrow*/ = TRUE,
		const long messageQueueSize = OMOSThread::DefaultMessageQueueSize);

  	virtual OMOSConnectionPort *createOMOSConnectionPort();

  	virtual OMOSEventFlag* createOMOSEventFlag();

  	virtual OMOSThread *createOMOSThread(void tfunc(void *), void *param,
									   const char* const threadName = NULL,
									   const long stackSize = OMOSThread::DefaultStackSize);

  	virtual OMOSThread* createOMOSWrapperThread(void* osHandle);
  	
  	virtual OMOSMutex  *createOMOSMutex();

  	virtual OMOSTimer *createOMOSTickTimer(timeUnit tim, void cbkfunc(void*), void *param);
  	
	virtual OMOSTimer *createOMOSIdleTimer(void cbkfunc(void*), void *param);

	virtual OMOSSemaphore* createOMOSSemaphore(
		unsigned long semFlags = 0,
		unsigned long initialCount = 1, 
		unsigned long /* maxCount */ = 1, 
		const char * const /* name */ = NULL);

	virtual void* getCurrentThreadHandle();

	virtual void delayCurrentThread(timeUnit ms);

	virtual OMBoolean waitOnThread( void* osHandle, timeUnit ms);
};


#ifdef _OMINSTRUMENT
/////////////////////////////////////////////////////////////////////////////////
///								QNXSocket Class						///
/////////////////////////////////////////////////////////////////////////////////

class QNXSocket: public OMOSSocket {
public:
	QNXSocket();
	virtual ~QNXSocket();

	virtual int Create(const char* SocketAddress = NULL,
						unsigned int nSocketPort = 0);

	virtual int Send(const char* lpBuf, int nBufLen);

	virtual int Receive(char* lpBuf, int nBufLen);

private:
	int theSock;

};


/////////////////////////////////////////////////////////////////////////////////
///						QNXConnectionPort Class						///
/////////////////////////////////////////////////////////////////////////////////

class QNXConnectionPort: public OMOSConnectionPort {
public:

	QNXConnectionPort();

	virtual ~QNXConnectionPort();

	virtual int Connect(const char* SocketAddress = NULL,
						unsigned int nSocketPort = 0);

	virtual int Send(OMSData *m);

	virtual void SetDispatcher(void dispatchfunc(OMSData*))
	{
	  m_dispatchfunc = dispatchfunc;
	}

private:
	void (*m_dispatchfunc)(OMSData *);
	QNXThread* m_ConnectionThread;
	QNXSocket m_Socket;

	static void readFromSockLoop(QNXConnectionPort *me);
	static char* m_Buf;
	static int m_BufSize;
	QNXMutex m_SendMutex ;
	OMBoolean m_Connected;
	int m_ShouldWaitForAck;
	QNXEventFlag m_AckEventFlag;
	int m_NumberOfMessagesBetweenAck;

};
#endif // _OMINSTRUMENT

#endif // _qnxos

/** PhEDIT attribute block
0:8607:default:-3:-3:0
**  PhEDIT attribute block ends (-0000096)**/
