//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: MemoryPoolsMacros
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFMemoryPoolsMacros.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:01 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFMemoryPoolsMacros_H 

#define OXFMemoryPoolsMacros_H 
//----------------------------------------------------------------------------
// OXFMemoryPoolsMacros.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Macros::MemoryPoolsMacros 


// Memory pools declaration/implementation macros

// The framework memory pool new/delete operators declaration.
//#[ type DECLARE_ALLOCATION_OPERATORS 
#define DECLARE_ALLOCATION_OPERATORS														\
	static void operator delete(void *deadObject, size_t size);		\
	static void * operator new(size_t size NEW_DUMMY_PARAM) OM_NO_THROW; 
//#]

// The framework memory pool operations that are added to the controlled classes.
//#[ type DECLARE_MEMORY_ALLOCATOR 
#define DECLARE_MEMORY_ALLOCATOR(CLASSNAME,INITNUM)									\
	public:																	\
		CLASSNAME* OMMemoryPoolNextChunk;									\
		DECLARE_ALLOCATION_OPERATORS										\
		static void OMMemoryPoolIsEmpty();									\
		static void OMMemoryPoolSetIncrement(int value);					\
		static void OMCallMemoryPoolIsEmpty(bool flagValue);				\
		static void OMSetMemoryAllocator(CLASSNAME*(*newAllocator)(int));	\
		static OMSelfLinkedMemoryAllocator<CLASSNAME,INITNUM>& myOMMemoryAllocator(); 
//#]

// The framework memory pool new/delete operators implementation.
//#[ type IMPLEMENT_ALLOCATION_OPERATORS 
#define IMPLEMENT_ALLOCATION_OPERATORS(CLASSNAME)															\
	void CLASSNAME::operator delete(void *deadObject, size_t size)				\
	{																			\
		myOMMemoryAllocator().returnMemory(deadObject,size);					\
	}																			\
	void * CLASSNAME::operator new(size_t size NEW_DUMMY_PARAM_IMP) OM_NO_THROW	\
	{																			\
		void * mem = myOMMemoryAllocator().getMemory(size);						\
		if (mem == NULL) {														\
			MEMORY_ALLOCATION_FAIL_MSG(CLASSNAME,mem)							\
		}																		\
		return mem;																\
	}
//#]

// The framework memory pool operations that are added to the controlled classes.
//#[ type IMPLEMENT_MEMORY_ALLOCATOR 
#define IMPLEMENT_MEMORY_ALLOCATOR(CLASSNAME,INITNUM,INCREMENTNUM,ISPROTECTED)						\
	OMSelfLinkedMemoryAllocator<CLASSNAME,INITNUM>& CLASSNAME::myOMMemoryAllocator() 				\
	{																								\
		static OMSelfLinkedMemoryAllocator<CLASSNAME,INITNUM> allocator(INCREMENTNUM,ISPROTECTED);	\
		return allocator;																			\
	}																								\
	IMPLEMENT_ALLOCATION_OPERATORS(CLASSNAME)														\
	void CLASSNAME::OMMemoryPoolSetIncrement(int value)												\
	{																								\
		myOMMemoryAllocator().setIncrementNum(value);												\
	}																								\
	void CLASSNAME::OMMemoryPoolIsEmpty()															\
	{																								\
		POOL_REALLOCATION_MSG(CLASSNAME,INCREMENTNUM)												\
	}																								\
	void CLASSNAME::OMCallMemoryPoolIsEmpty(bool flagValue)											\
	{																								\
		myOMMemoryAllocator().callMemoryPoolIsEmpty(flagValue);										\
	}																								\
	void CLASSNAME::OMSetMemoryAllocator(CLASSNAME*(*newAllocator)(int))							\
	{																								\
		myOMMemoryAllocator().setAllocator(newAllocator);											\
	}
//#]

// The framework memory pool fail message
//#[ type MEMORY_ALLOCATION_FAIL_MSG 
#ifdef _OMINSTRUMENT
	#define	MEMORY_ALLOCATION_FAIL_MSG(CLASSNAME,MEM)				\
			OMString s = #CLASSNAME ;								\
			s += ": Memory allocation for new instances failed.\n";	\
			OM_NOTIFY_TO_ERROR(s);										
#else
	#define	MEMORY_ALLOCATION_FAIL_MSG(CLASSNAME,MEM)
#endif // _OMINSTRUMENT
//#]

// The framework memory pool dummy new parameter (required by some compilers)
//#[ type NEW_DUMMY_PARAM_IMP 
#ifdef OM_NEW_OPERATOR_NEEDS_DUMMY_PARAM
#define NEW_DUMMY_PARAM_IMP ,size_t
#else // !OM_NEW_OPERATOR_NEEDS_DUMMY_PARAM
#define NEW_DUMMY_PARAM_IMP
#endif // OM_NEW_OPERATOR_NEEDS_DUMMY_PARAM
//#]

// The initial pool size for dynamic initialization
//#[ type OM_DYNAMIC_POOL_INITIALIZATION_SIZE 
#define OM_DYNAMIC_POOL_INITIALIZATION_SIZE 0
//#]

// The framework memory pool additional allocation message
//#[ type POOL_REALLOCATION_MSG 
#ifdef _OMINSTRUMENT
	#define POOL_REALLOCATION_MSG(CLASSNAME,INCREMENTSIZE)						\
		OMString s = #CLASSNAME ;												\
		s += ": Memory pool is empty, allocating memory pool for additional ";	\
		s += #INCREMENTSIZE ;													\
		s += " instances.\n";													\
		OM_NOTIFY_TO_OUTPUT(s);
#else
	#define POOL_REALLOCATION_MSG(CLASSNAME,INCREMENTSIZE)
#endif // _OMINSTRUMENT
//#]

// Reset the memory pool
//#[ type RESET_MEMORY_ALLOCATOR 
#define RESET_MEMORY_ALLOCATOR(CLASSNAME) \
	OMMemoryPoolNextChunk = reinterpret_cast<CLASSNAME*>(0); 
//#]




#endif  
//
//! Log: $Log: OXFMemoryPoolsMacros.h $
//! Log: Revision 1.15  2007/04/06 07:08:01  ilgiga
//! Log: bug fix 98191
//


