//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: Events
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFEvents.h $
//!	File version	: $Revision: 1.21 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:58 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFEvents_H 

#define OXFEvents_H 

#include "IOxfEvent.h"
#include "OMEvent.h"


//#[ ignore 
#define OMStartBehaviorEvent_Events_Services_oxf_Design_id OMStartBehaviorEventId


#define OMEndThreadEvent_Events_Services_oxf_Design_id OMEndThreadEventId


#define OMNullEvent_Events_Services_oxf_Design_id OMNullEventId


#define OMCloseHandleEvent_Events_Services_oxf_Design_id OMCloseHandleEventId


#define OMReactiveTerminationEvent_Events_Services_oxf_Design_id OMReactiveTerminationEventId
//#]

//----------------------------------------------------------------------------
// OXFEvents.h                                                                  
//----------------------------------------------------------------------------

class OMCloseHandleEvent;
class OMEndThreadEvent;
class OMNullEvent;
class OMReactiveTerminationEvent;
class OMStartBehaviorEvent;

//## package Design::oxf::Services::Events 


// Predefined events used by the framework implementation

// Null event pre-2004 id
//#[ type OMEventNullId 
#define OMEventNullId OMNullEventId
//#]

// Timeout event pre-2004 id
//#[ type OMEventTimeoutId 
#define OMEventTimeoutId OMTimeoutEventId
//#]


// Animation wakeup event id
// Used by the thread manager to implement the wakeup API
//## attribute OMAnimWakeupEventId 
const IOxfEvent::ID OMAnimWakeupEventId( -10 );

// Any event id is used by the timer manager in extensive timeout management mode to locate timeouts that needs to be 
// canceled.
//## attribute OMAnyEventId 
const IOxfEvent::ID OMAnyEventId( -4 );

// Canceled event special id
// Required for event canceling
//## attribute OMCancelledEventId 
const IOxfEvent::ID OMCancelledEventId( -3 );

// OMCloseHandleEvent event id
//## attribute OMCloseHandleEventId 
const IOxfEvent::ID OMCloseHandleEventId( -7 );

// OMEndThreadEvent event id
//## attribute OMEndThreadEventId 
const IOxfEvent::ID OMEndThreadEventId( -6 );

// OMNullEvent event id
//## attribute OMNullEventId 
const IOxfEvent::ID OMNullEventId( -1 );

// The id of the reactive termination event
//## attribute OMReactiveTerminationEventId 
const IOxfEvent::ID OMReactiveTerminationEventId( -9 );

// OMStartBehaviorEvent event id
//## attribute OMStartBehaviorEventId 
const IOxfEvent::ID OMStartBehaviorEventId( -5 );

// OMDelay timeout id
//## attribute OMTimeoutDelayId 
const IOxfEvent::ID OMTimeoutDelayId( -8 );

// Timeout event id
//## attribute OMTimeoutEventId 
const IOxfEvent::ID OMTimeoutEventId( -2 );

// Support consumption of NULL transitions that follows the default transition on the appropriate active context
//## event OMStartBehaviorEvent() 
class RP_FRAMEWORK_DLL OMStartBehaviorEvent : public OMEvent {


////    Constructors and destructors    ////
public :
    
    OMStartBehaviorEvent();


////    Framework operations    ////
public :
    
    bool isTypeOf(short id) const;


};

// Active classes event loop termination
//## event OMEndThreadEvent() 
class RP_FRAMEWORK_DLL OMEndThreadEvent : public OMEvent {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    OMEndThreadEvent();


////    Framework operations    ////
public :
    
    bool isTypeOf(short id) const;


};

// Null event is used for consumption of null transitions
//## event OMNullEvent() 
class OMNullEvent : public OMEvent {


////    Constructors and destructors    ////
public :
    
    OMNullEvent();


////    Framework operations    ////
public :
    
    bool isTypeOf(short id) const;


};

// An event used for RTOS threads cleanup in adapters that uses the OMHandleCloser
//## event OMCloseHandleEvent(void *) 
class OMCloseHandleEvent : public OMEvent {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    OMCloseHandleEvent(void * p_handle);


////    Framework operations    ////
public :
    
    bool isTypeOf(short id) const;


////    Attributes    ////
public :
    
    // The RTOS thread handle to clean
    void * handle;

};

// OMReactive graceful termination event
//## event OMReactiveTerminationEvent() 
class RP_FRAMEWORK_DLL OMReactiveTerminationEvent : public OMEvent {


////    Constructors and destructors    ////
public :
    
    OMReactiveTerminationEvent();


////    Framework operations    ////
public :
    
    bool isTypeOf(short id) const;


};



#endif  
//
//! Log: $Log: OXFEvents.h $
//! Log: Revision 1.21  2007/04/06 07:07:58  ilgiga
//! Log: bug fix 98191
//


