//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMUnicodeHelper
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMUnicodeHelper.h $
//!	File version	: $Revision: 1.13 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:55 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMUnicodeHelper_H 

#define OMUnicodeHelper_H 

#include "rp_framework_dll_definition.h"

//----------------------------------------------------------------------------
// OMUnicodeHelper.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Unicode 


// A utility class for unicode resolution
//## class OMUnicodeHelper 

//#[ ignore 
#ifdef _OM_UNICODE_ONLY
//#]
class RP_FRAMEWORK_DLL OMUnicodeHelper  {


////    Operations    ////
public :
    
    // converts the char* string to the wide character string
    // returns size of the wide character string
    // Argument wchar_t* wcstr : 
    // the output wide character string
    // Argument const char* cstr : 
    // the input string
    // Argument size_t count : 
    // length of cstr
    //## operation ctow(wchar_t,char*,size_t) 
    static size_t ctow(wchar_t* wcstr, const char* cstr, size_t count);
    
    // Returns the c character, converted to upper case
    // If the c is already uppercased, it returns the same value
    // Argument int c : 
    // A character
    //## operation toupper(int) 
    static int toupper(int c);
    
    // converts the wcstr wide character string to char* string
    // returns size of cstr
    // Argument char* cstr : 
    // the output string
    // Argument const wchar_t* wcstr : 
    // wide character string
    // Argument size_t count : 
    // length of wcstr
    //## operation wtoc(char*,wchar_t,size_t) 
    static size_t wtoc(char* cstr, const wchar_t* wcstr, size_t count);


};

//#[ ignore 

#endif // _OM_UNICODE_ONLY
//#]



#endif  
//
//! Log: $Log: OMUnicodeHelper.h $
//! Log: Revision 1.13  2007/04/06 07:07:55  ilgiga
//! Log: bug fix 98191
//


