//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMTimeout
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMTimeout.h $
//!	File version	: $Revision: 1.23 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:51 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMTimeout_H 

#define OMTimeout_H 

#include "rawtypes.h"
#include "OMEvent.h"
#include "OXFPools.h"
#include "OXFTypes.h"

//----------------------------------------------------------------------------
// OMTimeout.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfReactive;
class OMThread;
class OMTimerManager;
class OXF;

//## package Design::oxf::Core::CoreImplementation 

// IOxfTimeout implementation
//## class OMTimeout 
class RP_FRAMEWORK_DLL OMTimeout : public OMEvent {

    DECLARE_MEMORY_ALLOCATOR(OMTimeout, OM_DYNAMIC_POOL_INITIALIZATION_SIZE)
    
////    Constructors and destructors    ////
public :

    // empty argument declaration, for arguments used in instrumented mode only.
    // Argument IOxfReactive* pdest : 
    // The timeout client
    // Argument OxfTimeUnit delay : 
    // The timeout delay
    // Argument const OMHandle* aomArg(theState) : 
    // The destination state name (for design level debugging)
    //## operation OMTimeout(IOxfReactive,OxfTimeUnit,OMHandle) 
    OMTimeout(IOxfReactive* pdest, OxfTimeUnit delay, const OMHandle* aomArg(theState));
    
    // Initialize a timeout
    //## operation OMTimeout() 
    OMTimeout();
    
    // copy constructor
    // Argument const OMTimeout& tm : 
    // the timeout to copy
    //## operation OMTimeout(OMTimeout) 
    OMTimeout(const OMTimeout& tm);
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMTimeout() 
    virtual ~OMTimeout();


////    Operations    ////
public :
    
    // cancel the timeout
    //## operation cancel() 
    void cancel();
    
    // Backward compatibility: get the delay time
    //## operation getDelay() const 
    OxfTimeUnit getDelay() const;
    
    // assignment operator
    // Argument const OMTimeout& tm : 
    // the event to copy
    //## operation operator =(OMTimeout) 
    OMTimeout& operator =(const OMTimeout& tm);
    
    // Compare timeouts by due time
    // Argument const OMTimeout& tn : 
    // The other timeout
    //## operation operator<(OMTimeout) const 
    bool operator<(const OMTimeout& tn) const;
    
    // Compare timeouts by due time
    // Argument const OMTimeout& tn : 
    // The other timeout
    //## operation operator>(OMTimeout) const 
    bool operator>(const OMTimeout& tn) const;
    
    // set the timeout to be a delay timeout
    //## operation setDelayTimeout() 
    void setDelayTimeout();
    
    // Set the timeout due time based on the current time and the delay time
    // Argument OxfTimeUnit now : 
    // The current time (from the OMTimerManager singleton)
    //## operation setRelativeDueTime(OxfTimeUnit) 
    void setRelativeDueTime(OxfTimeUnit now);


////    Additional operations    ////
public :
    
    //## auto_generated 
    bool isCanceled() const;
    
    //## auto_generated 
    OxfTimeUnit getDelayTime() const;
    
    //## auto_generated 
    void setDelayTime(OxfTimeUnit p_delayTime);
    
    //## auto_generated 
    OxfTimeUnit getDueTime() const;
    
    //## auto_generated 
    void setDueTime(OxfTimeUnit p_dueTime);
    
    //## auto_generated 
    const OMHandle * getState() const;
    
    //## auto_generated 
    void setState(const OMHandle * p_state);
    
    //## auto_generated 
    short getTimeoutId() const;
    
    //## auto_generated 
    void setTimeoutId(short p_timeoutId);


////    Attributes    ////
private :
    
    // When the event is canceled, it should be ignored by the event dispatcher.
    bool canceled;		//## attribute canceled 
    
    // The relative delay until the timeout should be expired.
    OxfTimeUnit delayTime;		//## attribute delayTime 
    
    // The absolute time (i.e. system time) until the timeout will expire.
    // This time is calculated by:
    // dueTime = <timeout scheduling time> + delayTime.
    OxfTimeUnit dueTime;		//## attribute dueTime 
    
    // The state that is the client of the timeout (for design level debugging)
    const OMHandle * state;		//## attribute state 
    
    // the timeout id, exists to support extensive timeout management
    short timeoutId;		//## attribute timeoutId 
    

};


#endif  
//
//! Log: $Log: OMTimeout.h $
//! Log: Revision 1.23  2007/04/06 07:07:51  ilgiga
//! Log: bug fix 98191
//


