//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMThreadManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMThreadManager.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:50 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMThreadManager_H 

#define OMThreadManager_H 

#include "omlist.h"
#include "IOxfAnimThreadManager.h"
#include "omprotected.h"

//----------------------------------------------------------------------------
// OMThreadManager.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfActive;
class OMEvent;
class OMThread;

//## package Design::oxf::Services::ResourceManagement 


// This class is responsible for managing the living threads list and for cleanup of these threads on close of the 
// application.
// It is used by RTOS that do not have automatic process cleanup such as VxWorks.
// The cleanup is also used to cleanup the framework threads on unload of the framework DLL.
// Compile the oxf with the OM_NO_APPLICATION_TERMINATION_SUPPORT compilation flag to disable the management of the 
// list.
//## class OMThreadManager 
class OMThreadManager : public IOxfAnimThreadManager {
public :
    //#[ ignore 
    // The manager guard declaration
    OMDECLARE_GUARDED // Guard 
    //#]
    
    


////    Constructors and destructors    ////
public :
    
    //## auto_generated 
    virtual ~OMThreadManager();

protected :
    
    // Initialization
    //## operation OMThreadManager() 
    OMThreadManager();


////    Operations    ////
public :
    
    // Cleanup all the live threads on close of the application.
    // Cleanup all the registered threads except for:
    // - OMMainThread::instance()
    // - threads that return false in allowDeleteInThreadsCleanup() call
    // - the thread context that this call is invoked on
    // 
    // Should be called only in OSAL cleanup when the RTOS exit() doesn't perform the cleanup
    // return the thread context
    //## operation cleanupAllThreads() 
    OMThread* cleanupAllThreads();
    
    // Deregister an about to die thread
    // Argument OMThread* t : 
    // The thread
    //## operation deregisterThread(OMThread) 
    void deregisterThread(OMThread* t);
    
    // Get the singleton instance
    //## operation instance() 
    static OMThreadManager& instance();
    
    // register a new thread
    // Argument OMThread* t : 
    // The thread
    //## operation registerThread(OMThread) 
    void registerThread(OMThread* t);
    
    // Stop all the live threads before unload of the framework as a DLL.
    // stop all the registered threads
    // except the skipme thread and the context thread
    // return the context thread
    // Argument const OMThread* skipme : 
    // The thread to skip
    //## operation stopAllThreads(OMThread) const 
    OMThread* stopAllThreads(const OMThread* skipme) const;
    
    // Wakeup the specified thread (the thread is supposed to be waiting for events)
    // Argument IOxfActive* thread : 
    // The thread to wakeup
    //## operation wakeup(IOxfActive) const 
    virtual void wakeup(IOxfActive* thread) const;


////    Additional operations    ////
public :
    
    // The list of live threads in the system
    //## auto_generated 
    OMIterator<OMThread*> getThreads() const;
    
    //## auto_generated 
    void addThreads(OMThread* p_OMThread);
    
    //## auto_generated 
    void removeThreads(OMThread* p_OMThread);
    
    //## auto_generated 
    void clearThreads();
    
    //## auto_generated 
    int findThreads(OMThread* p_OMThread) const;


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Relations and components    ////
private :
    
    // The list of live threads in the system
    OMList<OMThread*> threads;		//## link threads 
    


};


#endif  
//
//! Log: $Log: OMThreadManager.h $
//! Log: Revision 1.15  2007/04/06 07:07:50  ilgiga
//! Log: bug fix 98191
//


