//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMStaticArray
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMStaticArray.h $
//!	File version	: $Revision: 1.14 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:49 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMStaticArray_H 

#define OMStaticArray_H 

#include "OXFManager.h"
#include "OMAbstractContainer.h"
#include "OMIterator.h"

//----------------------------------------------------------------------------
// OMStaticArray.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Containers::TypeSafe 


// A fixed-size safe array
//## class OMStaticArray 
template <class Concept> class OMStaticArray : public OMAbstractContainer<Concept> {


////    Constructors and destructors    ////
public :
    
    // copy constructor
    // Argument const OMStaticArray<Concept> & a : 
    // The array to copy
    //## operation OMStaticArray(const OMStaticArray<Concept> & ) 
    OMStaticArray(const OMStaticArray<Concept> & a) : count(0) ,size(0) ,theLink(NULL) {
        //#[ operation OMStaticArray(const OMStaticArray<Concept> & ) 
        copy(a);
        //#]
    }
    
    
    // Initialize an array of a given size
    // Argument int theSize : 
    // The array size
    //## operation OMStaticArray(int) 
    OMStaticArray(int theSize) : count(0), size(theSize), theLink(NULL) {
        //#[ operation OMStaticArray(int) 
        if (size > 0) {
        	theLink = OMNEW(Concept, theSize);
        }
        //#]
    }
    
    
    // Destructor	
    //## operation ~OMStaticArray() 
    ~OMStaticArray() {
        //#[ operation ~OMStaticArray() 
        OMDELETE(theLink, sizeof(Concept) * size);
        theLink = NULL;
        count = 0;
        size = 0;
        //#]
    }
    


////    Operations    ////
public :
    
    // Add an element to the array
    // Argument Concept p : 
    // The element
    //## operation add(Concept) 
    inline void add(Concept p) {
        //#[ operation add(Concept) 
        theLink[count++] = p;
        //#]
    }
    
    
    // Find if p in the collection
    // Argument Concept p : 
    // The element to find
    //## operation find(Concept) const 
    inline bool find(Concept p) const {
        //#[ operation find(Concept) const 
        for (int i = 0; i < count; i++) {
        	if (theLink[i] == p) {
        		return true;
        	}
        }
        return false;
        //#]
    }
    
    
    // Get the element in the specified index
    // Argument int i : 
    // The index
    //## operation getAt(int) const 
    inline Concept &  getAt(int i) const {
        //#[ operation getAt(int) const 
        if (i >= 0 && i < count) {
        	return theLink[i];
        }
        else {
        	return OMNullValue<Concept>::get();
        }
        //#]
    }
    
    
    // Check if the array is empty
    //## operation isEmpty() const 
    inline bool isEmpty() const {
        //#[ operation isEmpty() const 
        return count == 0;
        //#]
    }
    
    
    // Assignment operator
    // Argument const OMStaticArray<Concept> & a : 
    // The array to copy
    //## operation operator=(const OMStaticArray<Concept> & ) 
    inline OMStaticArray<Concept> &  operator=(const OMStaticArray<Concept> & a) {
        //#[ operation operator=(const OMStaticArray<Concept> & ) 
        copy(a);
        return *this;
        //#]
    }
    
    
    // Get the element in the specified index
    // Argument int i : 
    // The index
    //## operation operator[](int) 
    inline Concept &  operator[](int i) {
        //#[ operation operator[](int) 
        return getAt(i);
        //#]
    }
    
    
    // Clear the array
    //## operation removeAll() 
    inline void removeAll() {
        //#[ operation removeAll() 
        count = 0;
        //#]
    }
    
    
    // Set the element at the given index.
    // The index should be smaller then the number of elements currently located in the array
    // Argument int i : 
    // The index
    // Argument Concept c : 
    // The element
    //## operation setAt(int,Concept) 
    inline void setAt(int i, Concept c) {
        //#[ operation setAt(int,Concept) 
        if (i >= 0 && i < count) {
        	theLink[i] = c;
        }
        //#]
    }
    

protected :
    
    // Copy an array
    // Argument const OMStaticArray<Concept> & a : 
    // The array to copy
    //## operation copy(const OMStaticArray<Concept> & ) 
    inline void copy(const OMStaticArray<Concept> & a) {
        //#[ operation copy(const OMStaticArray<Concept> & ) 
        if (theLink != a.theLink) {
        	// avoid self copy
        	if (theLink != NULL) {
        		// cleanup before copy
        		OMDELETE(theLink, sizeof(Concept) * size);
        	}
        
        	count = a.count;
        	size = a.size;
        	theLink = OMNEW(Concept, size);
        
        	for (int i = 0; i < count; ++i) {
        		theLink[i] = a.theLink[i];
        	}
        }
        //#]
    }
    

private :
    
    // Get the element at the given position (called by the iterator)
    // Argument void * pos : 
    // The iterator position
    //## operation getCurrent(void *) const 
    inline virtual Concept& getCurrent(void * pos) const {
        //#[ operation getCurrent(void *) const 
        return getAt((int)((unsigned long)pos));
        //#]
    }
    
    
    // Set the initial position for the iterator
    // Argument void *& pos : 
    // The array[0] address (out)
    //## operation getFirst(void *) const 
    inline virtual void getFirst(void *& pos) const {
        //#[ operation getFirst(void *) const 
        pos = reinterpret_cast<void*>(0);
        //#]
    }
    
    
    // Update the provided position to the next position in the container
    // Argument void *& pos : 
    // The iterator position to advance
    //## operation getNext(void *) const 
    inline virtual void getNext(void *& pos) const {
        //#[ operation getNext(void *) const 
        pos = reinterpret_cast<void*>(
        	reinterpret_cast<unsigned long>(pos) + 1);
        //#]
    }
    


////    Additional operations    ////
public :
    
    //## auto_generated 
    inline int getCount() const {
        return count;
    }
    
    
    //## auto_generated 
    inline int getSize() const {
        return size;
    }
    


////    Attributes    ////
protected :
    
    // The number of elements currently placed in the array
    int count;		//## attribute count 
    
    // The array total size
    int size;		//## attribute size 
    
    // The underlying C array
    Concept* theLink;		//## attribute theLink 
    

};
//## class OMStaticArray 





#endif  
//
//! Log: $Log: OMStaticArray.h $
//! Log: Revision 1.14  2007/04/06 07:07:49  ilgiga
//! Log: bug fix 98191
//


