//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMResourceGuard
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMResourceGuard.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:49 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMResourceGuard_H 

#define OMResourceGuard_H 

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include "aom\AnimServices.h"

//#[ ignore 
#endif //_OMINSTRUMENT
//#]

#include "rawtypes.h"

//----------------------------------------------------------------------------
// OMResourceGuard.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Guards 


// Enter-Exit object for definition of a critical section lock/unlock (the lock is done on the constructor and the 
// unlock on the destructor)
//## class OMResourceGuard 
template <class GUARD_TYPE> class OMResourceGuard  {


////    Constructors and destructors    ////
public :
    
    // create a resource guard with the specified guard
    // Argument const GUARD_TYPE& theGuard : 
    // the guard object
    // Argument bool aomArg(instrument) : 
    // Instrumentation support - when true notify about status changes
    //## operation OMResourceGuard(const GUARD_TYPE&,bool (instrument)) 
    OMResourceGuard(const GUARD_TYPE& theGuard, bool aomArg(instrument) = true) : guard(theGuard) {
        //#[ operation OMResourceGuard(const GUARD_TYPE&,bool (instrument)) 
        #ifdef _OMINSTRUMENT
        if (instrument == true)
        {
        	AnimServices::notifyMutexLock(false);
        }
        #endif
        
        // lock
        guard.lock();
        
        #ifdef _OMINSTRUMENT
        if (instrument == true)
        {
        	AnimServices::notifyMutexLock(true);
        }
        #endif
        //#]
    }
    
    
    // Cleanup
    //## operation ~OMResourceGuard() 
    virtual ~OMResourceGuard() {
        //#[ operation ~OMResourceGuard() 
        guard.unlock();
        //#]
    }
    

private :
    
    // explicitly disable copy CTOR
    // Argument const OMResourceGuard<GUARD_TYPE>& other : 
    // The resource guard to copy
    //## operation OMResourceGuard(const OMResourceGuard<GUARD_TYPE>&) 
    OMResourceGuard(const OMResourceGuard<GUARD_TYPE>& other) : guard(other.guard)  {
        //#[ operation OMResourceGuard(const OMResourceGuard<GUARD_TYPE>&) 
        //#]
    }
    


////    Operations    ////
private :
    
    // disable assignment operator
    // Argument const OMResourceGuard<GUARD_TYPE>& /**/ : 
    // The resource guard to copy
    //## operation operator=(const OMResourceGuard<GUARD_TYPE>&) 
    inline OMResourceGuard<GUARD_TYPE>& operator=(const OMResourceGuard<GUARD_TYPE>& /**/) {
        //#[ operation operator=(const OMResourceGuard<GUARD_TYPE>&) 
        return *this;
        //#]
    }
    


////    Attributes    ////
private :
    
    // The guard object
    // Note that the guard lock() & unlock() must be const
    const GUARD_TYPE& guard;		//## attribute guard 
    

};
//## class OMResourceGuard 





#endif  
//
//! Log: $Log: OMResourceGuard.h $
//! Log: Revision 1.15  2007/04/06 07:07:49  ilgiga
//! Log: bug fix 98191
//


