//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMNullValue
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMNullValue.h $
//!	File version	: $Revision: 1.15 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:47 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMNullValue_H 

#define OMNullValue_H 

#include "OXFTypeSafeContainers.h"

//----------------------------------------------------------------------------
// OMNullValue.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Containers::TypeSafe 


// Empty value class - used by containers to return non-existing element
//## class OMNullValue 
template <class Concept> class OMNullValue  {


////    Operations    ////
public :
    
    // Get the empty value
    //## operation get() 
    inline static Concept &  get() {
        //#[ operation get() 
        #ifdef OMUseNullBlockContainer
        	// ensure that the OMContainersNullBlock is initialized
        	initNullBlock();
        	// get the NULL value
        	Concept& con = (Concept&)(*OMContainersNullBlock);
        	return con;
        #else
        	static int nullSet = 0;
        	static omMemoryAlignedType nillValue[OM_ALIGNED_SIZEOF(Concept)];
        	if (nullSet == 0) {	// need to zero the array 
        		nullSet = 1; 
        		for (unsigned int i = 0; i < (OM_ALIGNED_SIZEOF(Concept)); ++i) {
        			nillValue[i] = 0;
        		}
        	}
        	return ((Concept&)(*nillValue));
        #endif
        //#]
    }
    
    
    // Ensure that the OMContainersNullBlock is initialized
    //## operation initNullBlock() 
    
    //#[ ignore 
    #ifdef OMUseNullBlockContainer
    //#]
    inline static void initNullBlock() {
        //#[ operation initNullBlock() 
        if (OMContainersNullBlock[0] != 0)
        {
        	OMContainersNullBlock[0] = 0;
        	OMContainersNullBlock[1] = 0;
        	OMContainersNullBlock[2] = 0;
        	OMContainersNullBlock[3] = 0;
        }
        //#]
    }
    
    //#[ ignore 
    #endif // OMUseNullBlockContainer
    //#]
    


};
//## class OMNullValue 




#endif  
//
//! Log: $Log: OMNullValue.h $
//! Log: Revision 1.15  2007/04/06 07:07:47  ilgiga
//! Log: bug fix 98191
//


