//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMainThread
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMMainThread.h $
//!	File version	: $Revision: 1.20 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:44 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMMainThread_H 

#define OMMainThread_H 

#include "omthread.h"

//----------------------------------------------------------------------------
// OMMainThread.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfTimeout;
class OMEvent;
class OMEventQueue;
template <class  Concept> class OMIterator;
class OMOS;
class OMOSEventGenerationParams;
class OMOSThread;
class OMReactive;
class OMThreadManager;
class OMTimeout;
class OMTimerManager;
class OXF;

//## package Design::oxf::Services::Initialization 


// The default active class for running the application main event loop.
//## class OMMainThread 
class RP_FRAMEWORK_DLL OMMainThread : public OMThread {


////    Constructors and destructors    ////
public :
    
    // Cleanup
    //## operation ~OMMainThread() 
    ~OMMainThread();

protected :
    
    // force singleton
    //## operation OMMainThread() 
    OMMainThread();

private :
    
    // disable copy constructor
    // Argument const OMMainThread& other : 
    // The main thread to copy
    //## operation OMMainThread(OMMainThread) 
    OMMainThread(const OMMainThread& other);


////    Operations    ////
public :
    
    // override destroyThread(), to disable deletion of statically allocated instance
    // call the cleanupThread() to perform cleanup
    //## operation destroyThread() 
    inline virtual void destroyThread() {
        //#[ operation destroyThread() 
        this->cleanupThread();
        //#]
    }
    
    
    // Get the 'default active class' singleton instance.
    // Argument bool create : 
    // When true, attempt to initialize the singleton if it was not created.
    //## operation instance(bool) 
    static OMThread* instance(bool create = true);
    
    // Get the 'default active class' singleton instance.
    // This operation is deprecated, instance(bool) should be used instead.
    // Argument int create : 
    // When not zero, attempt to initialize the singleton if it was not created.
    //## operation instance(int) 
    static OMThread* instance(int create);
    
    // Start the thread & the event loop.
    // Argument bool doFork : 
    // The fork flag
    // When false the framework is expected to use the thread that the framework was initialized on.
    // Otherwise a new RTOS thread is created.
    //## operation startDispatching(bool) 
    virtual void startDispatching(bool doFork = false);

private :
    
    // actually get the main thread instance
    //## operation getInstance() 
    static OMMainThread* getInstance();
    
    // disable assignment operator
    // Argument const OMMainThread& other : 
    // The main thread to copy
    //## operation operator=(OMMainThread) 
    OMMainThread& operator=(const OMMainThread& other);


};


#endif  
//
//! Log: $Log: OMMainThread.h $
//! Log: Revision 1.20  2007/04/06 07:07:44  ilgiga
//! Log: bug fix 98191
//


