//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMIterator
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMIterator.h $
//!	File version	: $Revision: 1.16 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:43 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMIterator_H 

#define OMIterator_H 

#include "OMAbstractContainer.h"

//----------------------------------------------------------------------------
// OMIterator.h                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Containers::TypeSafe 


// Iterator on containers derived from OMAbstractContainer
//## class OMIterator 
template <class Concept> class OMIterator  {
public :
    
        
        // Abstract container instantiation used by the iterator
        //## class OMIterator::Container 
        typedef OMAbstractContainer<Concept> Container;
        
    
//## class OMIterator 


////    Constructors and destructors    ////
public :
    
    // Initialize an empty iterator
    //## operation OMIterator() 
    OMIterator() : theLink(0) {
        //#[ operation OMIterator() 
        //#]
    }
    
    
    // Initialize an iterator associated with the provided container
    // Argument const Container& l : 
    // The iterator context
    //## operation OMIterator(const Container&) 
    OMIterator(const Container& l) : theLink(&l)  {
        //#[ operation OMIterator(const Container&) 
        reset();
        //#]
    }
    
    
    // Initialize an iterator associated with the provided container
    // Argument const Container* l : 
    // The iterator context
    //## operation OMIterator(const Container*) 
    OMIterator(const Container* l) : theLink(l)  {
        //#[ operation OMIterator(const Container*) 
        reset();
        //#]
    }
    
    
    // Copy constructor
    // Argument const OMIterator<Concept> & iter : 
    // The iterator to copy
    //## operation OMIterator(const OMIterator<Concept> & ) 
    OMIterator(const OMIterator<Concept> & iter) : thePos(iter.thePos), theLink(iter.theLink) {
        //#[ operation OMIterator(const OMIterator<Concept> & ) 
        //#]
    }
    
    
    // Cleanup
    //## operation ~OMIterator() 
    ~OMIterator() {
        //#[ operation ~OMIterator() 
        theLink = 0;
        //#]
    }
    


////    Operations    ////
public :
    
    // Move to the next item in the collection
    //## operation increment() 
    inline OMIterator<Concept> &  increment() {
        //#[ operation increment() 
        _advance();
        return *this ;
        //#]
    }
    
    
    // Get the current item
    //## operation operator*() 
    inline Concept &  operator*() {
        //#[ operation operator*() 
        return value();
        //#]
    }
    
    
    // Advance to the next item in the collection
    //## operation operator++() 
    inline OMIterator<Concept> &  operator++() {
        //#[ operation operator++() 
        return increment(); 
        //#]
    }
    
    
    // Advance to the next item in the collection (postfix operator)
    // Argument int /**/ : 
    // C++ postfix ++ operator dummy argument
    //## operation operator++(int) 
    inline OMIterator<Concept> operator++(int /**/) {
        //#[ operation operator++(int) 
        OMIterator<Concept> T = *this ;	// save status prior to increment
        increment();
        return T; 
        //#]
    }
    
    
    // Assignment operator
    // Argument const OMIterator<Concept> & iter : 
    // The iterator to copy
    //## operation operator=(const OMIterator<Concept> & ) 
    inline OMIterator<Concept> &  operator=(const OMIterator<Concept> & iter) {
        //#[ operation operator=(const OMIterator<Concept> & ) 
        theLink = iter.theLink;
        thePos = iter.thePos;
        return *this;
        //#]
    }
    
    
    // Reset the iterator (to the first element in the container)
    //## operation reset() 
    inline void reset() {
        //#[ operation reset() 
        if (theLink != 0)
        	theLink->getFirst(thePos); 
        //#]
    }
    
    
    // Reset the iterator to the specified container
    // Argument const Container& newLink : 
    // The new context of the iterator
    //## operation reset(const Container&) 
    inline void reset(const Container& newLink) {
        //#[ operation reset(const Container&) 
        theLink = &newLink; 
        reset();
        //#]
    }
    
    
    // Get the current item
    //## operation value() 
    inline Concept &  value() {
        //#[ operation value() 
        if (theLink != 0)
        {
        	return theLink->getCurrent(thePos);
        }
        else
        {
        	return OMNullValue<Concept>::get();
        }
        //#]
    }
    

private :
    
    // advance to the next item in the context collection
    //## operation _advance() 
    inline void _advance() {
        //#[ operation _advance() 
        if (theLink != 0)
        	theLink->getNext(thePos);
        //#]
    }
    


////    Attributes    ////
private :
    
    // The current position of the iterator (in the collection)
    void * thePos;		//## attribute thePos 
    

////    Relations and components    ////
private :
    
     const Container* theLink;		//## link theLink 
    


};

//## class OMIterator 




//## class OMIterator::Container 





#endif  
//
//! Log: $Log: OMIterator.h $
//! Log: Revision 1.16  2007/04/06 07:07:43  ilgiga
//! Log: bug fix 98191
//


