//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMEvent
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMEvent.h $
//!	File version	: $Revision: 1.24 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:41 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMEvent_H 

#define OMEvent_H 

#include "IOxfEvent.h"
#include "IOxfTimeout.h"
#include "OXFManager.h"

//----------------------------------------------------------------------------
// OMEvent.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfReactive;

//## package Design::oxf::Core::CoreImplementation 


// The event base implementation class
//## class OMEvent 
class RP_FRAMEWORK_DLL OMEvent : public IOxfTimeout {

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // initialize the event
    // Argument IOxfEvent::ID eventId : 
    // the event id
    // Argument IOxfReactive* dest : 
    // the event destination
    //## operation OMEvent(ID,IOxfReactive) 
    OMEvent(IOxfEvent::ID eventId = 0, IOxfReactive* dest = 0);
    
    // copy constructor
    // Argument const OMEvent& ev : 
    // the event to copy
    //## operation OMEvent(OMEvent) 
    OMEvent(const OMEvent& ev);
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMEvent() 
    ~OMEvent();


////    Operations    ////
public :
    
    // destroy the event if it should be destroyed
    //## operation Delete() 
    virtual void Delete();
    
    // cancel the timeout
    //## operation cancel() 
    void cancel();
    
    // destroy the event
    //## operation destroy() 
    void destroy();
    
    // Empty implementation to IOxfTimeout API
    //## operation getDelayTime() const 
    OxfTimeUnit getDelayTime() const;
    
    // Empty implementation to ITimeout API
    //## operation getDueTime() const 
    OxfTimeUnit getDueTime() const;
    
    // compatibility API for getId()
    //## operation getlId() const 
    inline IOxfEvent::ID getlId() const {
        //#[ operation getlId() const 
        return getId();
        //#]
    }
    
    
    // Empty implementation to ITimeout API
    //## operation isCanceled() const 
    bool isCanceled() const;
    
    // Check if the event should be deleted after it was consumed
    //## operation isDeleteAfterConsume() 
    inline bool isDeleteAfterConsume();
    
    // Check that the event is an application event.
    //## operation isRealEvent() const 
    bool isRealEvent() const;
    
    // Check if the event is a timeout
    //## operation isTimeout() const 
    inline bool isTimeout() const {
        //#[ operation isTimeout() const 
        return false;
        //#]
    }
    
    
    // check if the event is a sub-type of an event with the specified id
    // Argument IOxfEvent::ID eventId : 
    // The event id to check
    //## operation isTypeOf(ID) const 
    inline bool isTypeOf(IOxfEvent::ID eventId) const;
    
    // assignment operator
    // Argument const OMEvent& ev : 
    // the event to copy
    //## operation operator =(OMEvent) 
    OMEvent& operator =(const OMEvent& ev);
    
    // Empty implementation to IOxfTimeout API
    // Argument OxfTimeUnit /**/ : 
    // The delay time
    //## operation setDelayTime(OxfTimeUnit) 
    void setDelayTime(OxfTimeUnit /**/);
    
    // Empty implementation to IOxfTimeout API
    // Argument OxfTimeUnit /**/ : 
    // The absolute due time
    //## operation setDueTime(OxfTimeUnit) 
    void setDueTime(OxfTimeUnit /**/);


////    Additional operations    ////
public :
    
    //## auto_generated 
    bool shouldDeleteAfterConsume() const;
    
    //## auto_generated 
    void setDeleteAfterConsume(bool p_deleteAfterConsume);
    
    //## auto_generated 
    bool isFrameworkEvent() const;
    
    //## auto_generated 
    void setFrameworkEvent(bool p_frameworkEvent);
    
    //## auto_generated 
    inline IOxfEvent::ID getId() const {
        return lId;
    }
    
    
    //## auto_generated 
    void * getPort() const;
    
    //## auto_generated 
    void setPort(void * p_port);
    
    //## auto_generated 
    bool getSynchronous() const;
    
    //## auto_generated 
    void setSynchronous(bool p_synchronous);
    
    //## auto_generated 
    IOxfReactive* getDestination() const;
    
    //## auto_generated 
    void setDestination(IOxfReactive* p_IOxfReactive);

protected :
    
    //## auto_generated 
    inline void setId(IOxfEvent::ID p_lId) {
        lId = p_lId;
    }
    


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
protected :
    
    // The event id.
    IOxfEvent::ID lId;		//## attribute lId 
    
private :
    
    // This flag is used to indicate if the event dispatcher should delete the event after it was dispatched
    bool deleteAfterConsume;		//## attribute deleteAfterConsume 
    
    // This flag mark an event as an internal framework event (that should be invisible in design-level debugging)
    bool frameworkEvent;		//## attribute frameworkEvent 
    
    // The port that the event was sent to
    void * port;		//## attribute port 
    
    // Mark the event as a synchronous event (i.e. triggered operation).
    bool synchronous;		//## attribute synchronous 
    

////    Relations and components    ////
protected :
    
    IOxfReactive* destination;		//## link destination 
    


};
//---------------------------------------------------------------------------- 
// inline operations for OMEvent
//---------------------------------------------------------------------------- 

inline bool OMEvent::isDeleteAfterConsume() {
    //#[ operation isDeleteAfterConsume() 
    return shouldDeleteAfterConsume();
    //#]
}

inline bool OMEvent::isTypeOf(IOxfEvent::ID eventId) const {
    //#[ operation isTypeOf(ID) const 
    return (lId == eventId);
    //#]
}



#endif  
//
//! Log: $Log: OMEvent.h $
//! Log: Revision 1.24  2007/04/06 07:07:41  ilgiga
//! Log: bug fix 98191
//


