//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfReactive.h $
//!	File version	: $Revision: 1.10 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:32 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfReactive_H 

#define IOxfReactive_H 

#include "OXFTypes.h"

//----------------------------------------------------------------------------
// IOxfReactive.h                                                                  
//----------------------------------------------------------------------------

class IOxfActive;
class IOxfEvent;
class IOxfEventGenerationParams;
class IOxfTimeout;

//## package Design::oxf::Core::CoreAPI 


// UML reactive class interface.
// Responsible for event consumption.
// A reactive instance is consuming events in a context of a single active instance.
//## class IOxfReactive 
class RP_FRAMEWORK_DLL IOxfReactive  {
public :
    // Event dispatching result
    //## type TakeEventStatus 
    enum TakeEventStatus {
        eventNotConsumed = 0,
        eventConsumed = 1,
        instanceUnderDestruction = 2,
        instanceReachTerminate = 3
    };
    
    // The reason handleNotConsumed() is called.
    // ---------------------------------------------------------------------
    // StateMachineBusy - the state machine is handling another event (for example when a triggered operation is 
    // called while an event is being consumed).
    // EventNotHandledByStatechart - the event was processed by the state machine but the statechart was not in a 
    // state that consumed it.
    //## type EventNotConsumedReason 
    enum EventNotConsumedReason {
        StateMachineBusy,
        EventNotHandledByStatechart
    };
    
    


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~IOxfReactive() 
    virtual ~IOxfReactive() {
        //#[ operation ~IOxfReactive() 
        //#]
    }
    


////    Operations    ////
public :
    
    // Cleanup references to the specified timeout.
    // Return true if the reference was removed.
    // Argument const IOxfTimeout* timeout : 
    // the timeout to remove references to
    //## operation cancelTimeout(IOxfTimeout) 
    virtual bool cancelTimeout(const IOxfTimeout* timeout)=0;
    
    // destroy the reactive instance (delete should never be called directly)
    //## operation destroy() 
    virtual void destroy()=0;
    
    // signal that the reactive instance reached a terminate connector
    // Argument const char* /*theTerminator*/ : 
    // The terminate connector model name (used for instrumentation)
    //## operation endBehavior(char*) 
    virtual void endBehavior(const char* /*theTerminator*/ = 0)=0;
    
    // consume an event
    // Argument IOxfEvent* ev : 
    // The event to handle
    //## operation handleEvent(IOxfEvent) 
    virtual TakeEventStatus handleEvent(IOxfEvent* ev)=0;
    
    // signal that a null transition was taken (called by the generated code)
    //## operation popNullTransition() 
    virtual void popNullTransition()=0;
    
    // signal that there is a null transition to be taken (called by the generated code)
    //## operation pushNullTransition() 
    virtual void pushNullTransition()=0;
    
    // send the specified event to the instance active context queue
    // Argument IOxfEvent* ev : 
    // The event to send
    // Argument const IOxfEventGenerationParams& params : 
    // Event sending parameters
    //## operation send(IOxfEvent,IOxfEventGenerationParams) 
    virtual bool send(IOxfEvent* ev, const IOxfEventGenerationParams& params)=0;
    
    // send the specified event to the instance active context queue
    // Argument IOxfEvent* ev : 
    // The event to send
    //## operation send(IOxfEvent) 
    virtual bool send(IOxfEvent* ev)=0;
    
    // initialize the reactive instance state machine
    //## operation startBehavior() 
    virtual bool startBehavior()=0;

protected :
    
    // react to an event that was not consumed.
    // note that the event can be allocated on the stack.
    // Argument IOxfEvent* ev : 
    // The context event
    // Argument EventNotConsumedReason reason : 
    // The reason that the event wasn't consumed
    //## operation handleNotConsumed(IOxfEvent,EventNotConsumedReason) 
    virtual void handleNotConsumed(IOxfEvent* ev, EventNotConsumedReason reason)=0;
    
    // consume a triggered operation (synchronous event)
    // Argument IOxfEvent* ev : 
    // The call-event
    //## operation handleTrigger(IOxfEvent) 
    virtual void handleTrigger(IOxfEvent* ev)=0;
    
    // schedule a timeout to be consumed by the reactive instance.
    // Argument OxfTimeUnit delay : 
    // The delay until the timeout will expire
    // Argument const char* targetStateName : 
    // The name of the destination state (used for instrumentation)
    //## operation scheduleTimeout(OxfTimeUnit,char) 
    virtual IOxfTimeout* scheduleTimeout(OxfTimeUnit delay, const char* targetStateName = 0)=0;


////    Additional operations    ////
public :
    
    //## auto_generated 
    virtual IOxfActive* getActiveContext() const=0;
    
    //## auto_generated 
    virtual void setActiveContext(IOxfActive* p_IOxfActive)=0;
    
    //## auto_generated 
    virtual IOxfEvent* getCurrentEvent() const=0;


};


#endif  
//
//! Log: $Log: IOxfReactive.h $
//! Log: Revision 1.10  2007/04/06 07:07:32  ilgiga
//! Log: bug fix 98191
//


