//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfActive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfActive.h $
//!	File version	: $Revision: 1.11 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:25 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfActive_H 

#define IOxfActive_H 

#include "IOxfReactive.h"

//----------------------------------------------------------------------------
// IOxfActive.h                                                                  
//----------------------------------------------------------------------------

class IOxfEvent;
class IOxfEventGenerationParams;

//## package Design::oxf::Core::CoreAPI 


// Active class interface.
// An active class is an event dispatcher executing an event loop (message pump), potentially on its own thread of 
// execution.
//## class IOxfActive 
class RP_FRAMEWORK_DLL IOxfActive  {


////    Constructors and destructors    ////
public :
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~IOxfActive() 
    virtual ~IOxfActive() {
        //#[ operation ~IOxfActive() 
        //#]
    }
    


////    Operations    ////
public :
    
    // end the active instance event dispatching and destroy the instance.
    //## operation endDispatching() 
    virtual void endDispatching()=0;
    
    // Queue the specified event to be handled by the event loop asynchronously.
    // Argument IOxfEvent* ev : 
    // the event to queue
    // Argument const IOxfEventGenerationParams& params : 
    // Event sending parameters
    //## operation queue(IOxfEvent,IOxfEventGenerationParams) 
    virtual bool queue(IOxfEvent* ev, const IOxfEventGenerationParams& params)=0;
    
    // start the event loop
    // Argument bool fork : 
    // when true, a new execution thread is created as part of the call and the event loop run on the thread context.
    //## operation startDispatching(bool) 
    virtual void startDispatching(bool fork = false)=0;

protected :
    
    // dispatch the specified event to its destination
    // Argument IOxfEvent* ev : 
    // The event to dispatch
    //## operation dispatch(IOxfEvent) 
    virtual IOxfReactive::TakeEventStatus dispatch(IOxfEvent* ev)=0;


};


#endif  
//
//! Log: $Log: IOxfActive.h $
//! Log: Revision 1.11  2007/04/06 07:07:25  ilgiga
//! Log: bug fix 98191
//


