#ifndef omexp_H
#define omexp_H "$Id: omexp.h 1.25 2007/03/11 12:34:36 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/omcom/rcs/omexp.h $
//	file version:	$Revision: 1.25 $
//
//	purpose: define try and catch macros which work in both UNIX
//  and NT environments. This is necessary since the 'catch(...)'
//  in NT catches 'bus error' and 'segmentation fault' but in UNIX
//  does not.
//  NOTE: This mechanism is very naive. It will not work if:
//	1. User adds his own 'signal handlers'
//	2. try catch blocks are nested
//	3. Code-correctness depends on destructors inside try block
//	4. possibly 'signal' should be replaced with somehting else
//  in complex blocks or nested 'try - catch' blocks
//
//	author(s):	Yachin Pnueli
//	date started:	27.10.97
//	date changed:	$Date: 2007/03/11 12:34:36 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1997, 2007
//

#include <oxf/rp_framework_dll_definition.h>

#ifdef HAS_NO_EXP
// do not use exceptions
#ifdef HAS_EXP_CATCHING_SIGNALS
#undef HAS_EXP_CATCHING_SIGNALS
#endif // HAS_EXP_CATCHING_SIGNALS
#ifdef HAS_EXP_NOT_CATCHING_SIGNALS
#undef HAS_EXP_NOT_CATCHING_SIGNALS
#endif // HAS_EXP_NOT_CATCHING_SIGNALS
#endif // HAS_NO_EXP


#ifdef HAS_EXP_NOT_CATCHING_SIGNALS
///////////////////////////////////////////////
// unix exception handling - exception by signal
///////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif
	// exception handler function
	typedef void(*FormalSignalFunc)(int);
	void OMOsExpcetionHandler_signalHandler(int sig);
#ifdef __cplusplus
}
#endif 

// signal to C++ exception convertor
class OMOsExpcetionHandler {
	FormalSignalFunc oldSegHandler;
	FormalSignalFunc oldBusHandler;
	FormalSignalFunc oldFpeHandler;
	FormalSignalFunc oldIllHandler;
	FormalSignalFunc oldAbrtHandler;
public:
	OMOsExpcetionHandler();
	~OMOsExpcetionHandler();
};

#define OMTRY									\
	OMOsExpcetionHandler omOsExpcetionHandler;	\
	try

#define OMCATCH_ALL catch(...)
#define INIT_OS_SIGNAL_HANDLERS

#else
#ifdef HAS_EXP_CATCHING_SIGNALS
///////////////////////////////////////////////
// C++ exception handling
///////////////////////////////////////////////
#define OMTRY try
#define OMCATCH_ALL catch(...)
#define INIT_OS_SIGNAL_HANDLERS 

#else
///////////////////////////////////////////////
// No exception handling
///////////////////////////////////////////////
// VXWorks
// WinCE
#define OMTRY if (1)
#define OMCATCH_ALL else
#define INIT_OS_SIGNAL_HANDLERS

#ifdef OM_OS_NO_EXCEPTIONS
// dummy fuction to avoid link warning
void fummyF(int& i);
#endif // OM_OS_NO_EXCEPTIONS

#endif // HAS_EXP_CATCHING_SIGNALS
#endif // HAS_EXP_NOT_CATCHING_SIGNALS


//
// $Log: omexp.h $
// Revision 1.25  2007/03/11 12:34:36  ilgiga
// Change copyright comment
// Revision 1.24  2007/03/01 16:43:32  ilgiga
// Telelogic instead of i-Logix
// Revision 1.23  2003/01/20 15:18:03  avrahams
// bug fix 61035- add more signals catching for omtry
// Revision 1.22  2003/01/09 12:29:33  Eldad
// Fix b#61053
// Revision 1.21  2002/07/11 13:08:50  amos
// do not include omosconfig.h directly
// Revision 1.20  2002/07/09 16:20:19  amos
// framework cleanup from RTOS specific code - back to r41 main branch
// Revision 1.19.1.2  2002/07/09 16:20:19  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.19.1.1  2001/11/27 12:40:07  amos
// Duplicate revision
// Revision 1.18  2001/05/02 12:46:36  amos
// comment statements aftert #endif
// Revision 1.17  2001/03/08 08:38:40  ofer
// safe macro definition
// we do not redefine HAS_EXP_NOT_CATCHING_SIGNALS
// Revision 1.16  2000/10/29 14:29:24  ofer
// diab data compiler 4.2.b support execptions
// Revision 1.15  2000/10/11 11:51:17  ofer
// remove definition of ARRAY_IS_NOT_POINTER for psos
// (remove it completely)
// Revision 1.14  2000/09/20 14:48:43  ofer
// RTX ( Real Time Operating system for NT ) does not use exceptions
// So if either the macro RTX defined or HAS_NO_EXP is defined
// we do not use exceptions
// ( define the OMTRY to "if (1) .. )
// Revision 1.13  2000/07/12 05:43:21  amos
// the main change related to modify char* to const char*.
// there are some other changes related to assignment of static member function as extern "C" functions.
// Revision 1.12  2000/03/07 12:49:01  amos
// back to main branch
// Revision 1.11.1.2  2000/03/02 13:56:10  amos
// remove definition of ARRAY_IS_NOT_POINTER for VxWorks
// Revision 1.11.1.1  1999/10/25 11:54:43  amos
// Duplicate revision
// Revision 1.10  1999/05/11 09:54:34  ofer
// Windows CE changes
// no iostream support and unicode ONLY ( no exceptions)
// Revision 1.9  1999/02/18 15:14:00  amos
// back to main branch
// Revision 1.8.1.2  1999/02/18 09:12:57  amos
// add macro for support in serialization of arrays in VxWorks and Psosx86
// Revision 1.8  1998/10/28 09:14:39  yaniv
// "disbale" execption in _DEBUG mode (for rhapsody link)
// ATTENTION: disbale only when generating the omcomomate.lib
// Revision 1.7  1998/06/23 12:31:40  yachin
// fix VX virtual table problem bug
// Revision 1.6  1998/04/13 07:59:30  ofer
// keep "using namespace std;"
// only after include to <XXXstream>
// Revision 1.5  1998/04/13 07:41:25  ofer
// added "using namespace std;" after each include to stl files
// Revision 1.4  1998/04/12 12:17:10  ofer
// Change includes to Stl format ifdefed by OM_USE_STL
// Revision 1.3  1997/12/29 13:28:52  ofer
// implement exception handling on unix the right way !!!!
// modif the macros of OMTRY and OM_CATCH_ALL
// omexp.cpp/h
// Revision 1.2  1997/10/29 13:29:39  yachin
// rewritten so signal is called on try
// Revision 1.1  1997/10/28 08:43:05  yachin
// Initial revision
//

#endif // omexp_H
