#ifndef om2str_H
#define om2str_H "$Id: om2str.h 1.71 2007/05/21 13:30:53 ilyuzh Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/omcom/rcs/om2str.h $
//	file version:	$Revision: 1.71 $
//
//	Purpose:
//		1.  Template "x2String" to convert EVERYTHING to char *
//			 and back from char * to the THING
//		Note: This works correctly for pointers since at worse the Hex 
//			  value is output.
//		LIMITATIONS:	
//			a. The "thing" to be converted must have a "<<" (to omostream) operator.
//			b. The char * produced is UNSAFE - it should be copied 
//			   immidiately after the function call
//		2.  Template "x2item" to convert an item from class "T" to
//			an AOMAnimationItem *.
//		LIMITATIONS: "T" must be of the form "SomeClass *" where SomeClass 
//					 is derived from AOMAnimationItem.
//		Reason: this template is needed due to a specific "bug" of MSDEV:
//		Let A and B be two classes (with virtual methods) such that A is the
//		base class of B.
//		Let b be of type "B *" and a be of type "A *". { B *b; A *a; }
//		Theoretically the assignment a = b; should always work.
//		In fact if b is garbage a = b raises an exception (possibly due to 
//		the unsuccessful attempt to copy/translate the virtual function table.
//
//	author(s):	Yachin Pnueli
//	date started:	3.6.96
//	date changed:	$Date: 2007/05/21 13:30:53 $
//	last change by:	$Author: ilyuzh $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include <oxf/rp_framework_dll_definition.h>
#include <oxf/omiotypes.h>
#ifdef USING_DLL
#include <Dll/RP_ANIM_DLL/rp_anim_dll_definition.h>
#else
#define RP_ANIM_DLL
#endif // USING_DLL

#ifdef _OM_NO_IOSTREAM
#define NO_IOSTREAM_FOR_X2STRING_IMPLEMENTATION
#endif // _OM_NO_IOSTREAM

#include <stdio.h> /* just for x2String(unsigned char) to avoid model corruption due to ^z */

#ifndef _OM_NO_IOSTREAM
#ifdef OM_STL
#include <iostream>
#ifdef OM_OS_SSTREAM_FILE_NAME
#include <sstream>
#else
#include <strstream>
#endif // OM_OS_SSTREAM_FILE_NAME
#else //!OM_STL
#include <iostream.h>
#ifdef OM_OS_SHORT_STRSTREAM_FILE_NAME
#include <strstrea.h>
#else // !OM_OS_SHORT_STRSTREAM_FILE_NAME
#ifdef OM_OS_SSTREAM_FILE_NAME
#include <sstream>
#else
#include <strstream.h>
#endif // OM_OS_SSTREAM_FILE_NAME
#endif // OM_OS_SHORT_STRSTREAM_FILE_NAME
#endif // OM_STL
#endif // _OM_NO_IOSTREAM


#include "omexp.h"

#ifndef NO_IOSTREAM_FOR_X2STRING_IMPLEMENTATION

#ifdef COPY_STRSTREAM_BUFFER
class my_ostrstream : public omostrstream {
public:
	my_ostrstream() {}
	
    char *str() {
		int count = pcount();
		char* copyBuff = new char[count+1];
		char* buf = omostrstream::str();
		if (count)
			strncpy(copyBuff,buf,count);
		copyBuff[count]='\0';
#ifdef OM_OS_OSTRSTREAM_WITHOUT_FREEZE_INTEFACE
		// implelemntation did not supply freeze() interface (Diab)
		rdbuf()->freeze(0);
#else // !OM_OS_OSTRSTREAM_WITHOUT_FREEZE_INTEFACE
		omostrstream::freeze(0);
#endif // OM_OS_OSTRSTREAM_WITHOUT_FREEZE_INTEFACE
		return copyBuff;
	}
};

#ifdef OM_USE_STL_STRING_STREAM
#define my_istrstream std::istringstream
#else // OM_USE_STL_STRING_STREAM
#define my_istrstream omistrstream
#endif // OM_USE_STL_STRING_STREAM


#else // !COPY_STRSTREAM_BUFFER

#ifdef OM_USE_STL_STRING_STREAM
#define my_istrstream std::istringstream
#define my_ostrstream std::ostringstream

#else // OM_USE_STL_STRING_STREAM

#define my_istrstream omistrstream
#define my_ostrstream omostrstream
#endif // OM_USE_STL_STRING_STREAM

#endif // COPY_STRSTREAM_BUFFER

// Convert a "T" to a string with "<<" 
// This routine may leak memory - 
// It is the responsibility of the applications to "delete" the
// returned "char *"
template<class T> TMPL_INL char * x2String(T f) {
	char* res = NULL;
	my_ostrstream os;
	OMTRY { // Need this as "<<" itself might crahs on bad objects
		os << f << omends ; // The '\0' is for added safety
	} OMCATCH_ALL {
		os<<"???InValidValue???" << omends ;
	}
#ifdef OM_USE_STL_STRING_STREAM
	std::string s = os.str();
	res = (char*)(s.c_str());
#else
	res = os.str();
#endif
	return res;
}

#ifndef _OM_NO_IOSTREAM
#ifdef OM_OS_NEEDS_CONST_VOID_DUMP_OPERATOR
inline omostream& operator<<(omostream& s, const void* t ) {
	void* i = (void*)t;
	s<<i;
	return s;
}
#endif // OM_OS_NEEDS_CONST_VOID_DUMP_OPERATOR
#endif // _OM_NO_IOSTREAM

inline char* x2String(unsigned char f)
{
  char* cS = new char[30];
#ifdef _OM_UNICODE_ONLY
  wchar_t wS[30];
  swprintf(wS, L"%C", f);
  OMwtoc(cS, wS, 30);
#else
  sprintf(cS, "%c", f);
#endif 
  return(cS);
}


template<class T> TMPL_INL void x2String(T f, OMString& s) {
	char * c = x2String(f);
	s += c;
	delete[] c;
}

template<class T> TMPL_INL char *x2String(T f, char *s) {
	char* res = NULL;

	my_ostrstream os;

	os << f << " (" << s << ")" << omends ;

#ifdef OM_USE_STL_STRING_STREAM
	std::string s1 = os.str();
	res = (char*)(s1.c_str());
#else
	res = os.str();
#endif
	return res;
}

//////////////////////////////
// x2String for arrays

// Redunant parameters
#define array2String(arraySize, array, size_of, cnvrtf) Array2String(arraySize, array) 

template<class T> TMPL_INL char * Array2String(int arraySize, T array)
{
	my_ostrstream os;

	char* res = NULL;

	char *tmp = x2String(arraySize);
	os << tmp << ";";
	delete tmp;

	for(int i = 0; i < arraySize; i++) {
		OMTRY { // Need this as "<<" itself might crahs on bad objects
			tmp = x2String(array[i]);
			os << tmp; // The '\0' is for added safety
			delete tmp;
		} 
		OMCATCH_ALL {
			os<<"???InValidValue???";
		}
		os << ";";
	} 
	os << omends ;

#ifdef OM_USE_STL_STRING_STREAM
	std::string s = os.str();
	res = (char*)(s.c_str());
#else
	res = os.str();
#endif
	return res;
}



//////////////////////////////
// x2Item for arrays

// Redunant parameters
#define array2Item(arraySize, array) Array2Item(arraySize, array) 

template<class T> TMPL_INL char * Array2Item(int arraySize, T array)
{
	char* res = NULL;
	my_ostrstream os;
	os << x2String(arraySize) << " {..}";
	os << omends ;
#ifdef OM_USE_STL_STRING_STREAM
	std::string s = os.str();
	res = (char*)(s.c_str());
#else
	res = os.str();
#endif
	return res;
}

#ifdef OM_NEED_X2STRING_FOR_DOUBLE
// add override on x2String for double
inline char * x2String(double d) {
	char* c = new char[30];
	sprintf(c, "%f", d);
	return c;
}
#endif // OM_NEED_X2STRING_FOR_DOUBLE

#ifndef OM_NO_INPUT_TEMPLATES
 // Template to correctly ">>" simple pointer items (T *)
template<class T> TMPL_INL omistream& operator>>(omistream& s, T *& p) {
	long int dummy;
	s>>dummy;
	p = (T *)dummy;
	return s;
}
#endif // OM_NO_INPUT_TEMPLATES


#ifdef OM_OS_NEED_EXPLICIT_ADDRESS_DUMP_OPERATOR
inline omostream& operator<<(omostream& s, const void* t ) {
	void* i = (void*)t;
	s<<i;
	return s;
}
#endif // OM_OS_NEED_EXPLICIT_ADDRESS_DUMP_OPERATOR

// Convert a string to a "T" with ">>"
template<class T> T string2X(char * c, T& t) {
	my_istrstream s(c);
	T t1;
	s>>t1;
	return t1;
}

// Convert a string to a "T" with ">>"
template<class T> TMPL_INL T OMDestructiveString2X(char * c, T& t) {
	my_istrstream s(c);
	T t1;
	s>>t1;
	delete c;
	return t1;
}

inline bool OMDestructiveString2X(char* str,bool& b)
{
	char c = str[0];
	b = ((c == 't') || (c == 'T') || (c == '1'));
	delete str;
	return b;
}

inline unsigned char OMDestructiveString2X(char* str, unsigned char& ch)
{
	ch = 0;
	if (strlen(str) > 1)
	{
		ch = (unsigned char)strtoul(str, 0, 10);
		if (ch == 0) 
		{
			ch = (unsigned char)strtoul(str, 0, 16);
		}
	}
	else  
	{
		ch = str[0];
	}
	delete str;
	return ch;
}


// dummy to avoid linker warning
void om2str_dummyOp();

#else //NO_IOSTREAM_FOR_X2STRING_IMPLEMENTATION section
#include <oxf/omstring.h>

template<class T> TMPL_INL void x2String(T f, OMString& s) {
	char * c = x2String(f);
	s += c;
	delete[] c;
}

char* x2String(const char f);
char* x2String(const bool f);
char* x2String(const int f);
char* x2String(const unsigned int f);
char* x2String(const short f);
char* x2String(const unsigned short f);
char* x2String(const long f);
char* x2String(const unsigned long f);
char* x2String(const double f);
char* x2String(const float f);
char* x2String(const void* f);
char* x2String(const void* f,const char*unk);
char* x2String(const char* f);
char* x2String(const OMString& s);
char* x2String(const unsigned char f);
#ifndef OM_NO_SPECIAL_SERIALIZE_LONG_DOUBLE
char* x2String(const long double f);
#endif

char string2X(char* c, char& t);
char OMDestructiveString2X(char* c, char& t);

char OMDestructiveString2X(char* c, unsigned char& t);

bool string2X(char* c, bool& t);
bool OMDestructiveString2X(char* c, bool& t);


short string2X(char* c, short& t);
short OMDestructiveString2X(char* c, short & t);

unsigned short string2X(char* c, unsigned short& t);
unsigned short OMDestructiveString2X(char* c, unsigned short& t);

int string2X(char* c, int& t);
int OMDestructiveString2X(char* c, int& t);

unsigned int string2X(char* c, unsigned int& t);
unsigned int OMDestructiveString2X(char* c, unsigned int& t);

long string2X(char* c, long& t);
long OMDestructiveString2X(char* c, long& t);

unsigned long string2X(char* c, unsigned long& t);
unsigned long OMDestructiveString2X(char* c, unsigned long& t);

double string2X(char* c, double& t);
double OMDestructiveString2X(char* c, double& t);

float string2X(char* c, float& t);
float OMDestructiveString2X(char* c, float& t);

#ifndef OM_NO_SPECIAL_SERIALIZE_LONG_DOUBLE
long double string2X(char* c, long double& t);
long double OMDestructiveString2X(char* c, long double& t);
#endif

void* OMDestructiveString2X(char* c, void*& t);

//////////////////////////////
// x2String for arrays

// Redunant parameters
#define array2String(arraySize, array, size_of, cnvrtf) Array2String(arraySize, array) 

template<class T> TMPL_INL char * Array2String(int arraySize, T array)
{
	OMString retVal;
	x2String(arraySize,retVal) ;
	x2String(';',retVal) ;
	for(int i = 0; i < arraySize; i++) {
		OMTRY { // Need this as "<<" itself might crahs on bad objects
			x2String(array[i],retVal); // The '\0' is for added safety
		} OMCATCH_ALL {
			retVal = "???InValidValue???";
		}
		x2String(';',retVal) ;
	}	
	return x2String(retVal);
}


//////////////////////////////
// x2Item for arrays

// Redunant parameters
#define array2Item(arraySize, array) Array2Item(arraySize, array) 

template<class T> TMPL_INL char * Array2Item(int arraySize, T array)
{
	OMString retVal;
	x2String(arraySize,retVal) ;
	x2String(" {..}",retVal) ;
	return x2String(retVal);
}


#endif // NO_IOSTREAM_FOR_X2STRING_IMPLEMENTATION



// Special case for "char*"
inline char * string2X(char * c, char *& ) { return c; }

inline unsigned char * string2X(char * c, unsigned char *&) {
	return (unsigned char*)c;
}

inline signed char * string2X(char * c, signed char *&) {
	return (signed char*)c;
}



// Special case for "char*"
inline char * OMDestructiveString2X(char * c, char *&) { return c; }

inline unsigned char * OMDestructiveString2X(char * c, unsigned char *&) {
	return (unsigned char*)c;
}

inline signed char * OMDestructiveString2X(char * c, signed char *&) {
	return (signed char*)c;
}


#ifdef OMCAST_CLASS
template<class T> TMPL_INL OMCAST_CLASS * x2Item(T item) {
#ifndef OM_OS_NO_EXCEPTIONS
	OMCAST_CLASS * tmp;
	OMTRY {
		if (isCodeItem(item))
			tmp = (OMCAST_CLASS*)((int)item);
		else
			tmp = (OMCAST_CLASS*)item;
	}
	OMCATCH_ALL {
		tmp = OMGarbage;
	}
	return tmp;
#else
	return OMNotInteresting;
#endif // OM_OS_NO_EXCEPTIONS
}
#endif // OMCAST_CLASS

// new chriwa

char* out2String(bool b);
char* out2String(bool* b);
char* out2String(int f);
char* out2String(int* f);
char* out2String(unsigned int f);
char* out2String(unsigned int* f);
char* out2String(long f);
char* out2String(long* f);
char* out2String(unsigned long f);
char* out2String(unsigned long* f);
char* out2String(double f);
char* out2String(double* f);
char* out2String(float f);
char* out2String(float* f);
#ifndef OM_NO_SPECIAL_SERIALIZE_LONG_DOUBLE
char* out2String(long double f);
char* out2String(long double* f);
#endif
char* out2String(short f);
char* out2String(short* f);
char* out2String(unsigned short f);
char* out2String(unsigned short* f);
char* out2String(char f);
char* out2String(char* f);
char* out2String(unsigned char f);
char* out2String(unsigned char* f);
char* out2String(OMString f);
char* out2String(OMString* f);
/*
template<class T> TMPL_INL char * out2String(T f) {
	return x2String(*f);
}
*/

// end new chriwa


#endif // om2str_H

//
// $Log: om2str.h $
// Revision 1.71  2007/05/21 13:30:53  ilyuzh
// Fix bug 72758
// when you generate an event: unsigned paramater  
// will display correct value.
// Revision 1.70  2007/03/28 17:26:40  ilvler
// 102112: float type support in instrumentation
// Revision 1.69  2007/03/11 12:34:36  ilgiga
// Change copyright comment
// Revision 1.68  2007/03/04 08:15:37  ilelpa
// Added out2String for bool
// Revision 1.66.1.1  2007/03/01 16:43:31  ilgiga
// Telelogic instead of i-Logix
// Revision 1.66  2006/07/16 15:03:28  eldad
// Fixed linux compilation errors
// Revision 1.65  2006/07/09 07:45:00  eldad
// Revision 1.64  2006/07/06 07:09:25  eldad
// Allow use of streams for serialization methods in omCom in Linux and Cygwin
// Revision 1.63.1.1  2005/11/02 15:56:07  eldad
// Duplicate revision
// Revision 1.62  2005/10/19 07:59:42  eldad
// #define OM_NO_SPECIAL_SERIALIZE_LONG_DOUBLE
// Revision 1.61  2005/10/02 12:41:35  eldad
// long double (for Linux)
// Revision 1.60  2004/05/12 08:44:59  vova
// Redundant include deleted
// Revision 1.59  2004/05/11 14:23:18  vova
// Linux sstream file name usage
// Revision 1.58  2004/05/11 07:49:29  vova
// strstream.h has been replaced by sstream: Linux warnings.
// Revision 1.57  2003/10/27 14:57:34  vova
// 61884, 63658 - missing serialize/unserialize functions added for unsigned int,short and char types
// Revision 1.57  2003/10/27 14:50:57  vova
// Solaris 61884 bug
// Revision 1.56  2003/06/10 14:24:59  eldad
// Merge 1.55 + 1.53.1.3 
// Revision 1.55  2003/04/14 15:12:30  amos
// OMDestructiveString2X() - create override on the template for bool, and remove the overide on basic_istream& operator>>(bool&)
// Revision 1.54  2003/04/07 16:03:31  vova
// x2string and string2x added for bool type
// Revision 1.53.1.3  2003/06/08 15:08:36  vova
// Removed out2String functions with "long double" argument.
// Revision 1.53.1.2  2003/06/08 12:12:27  eldad
// out2String
// Revision 1.53  2003/01/09 12:21:04  vova
// 61074: OMDestructiveString2X(void*) added for Solaris implementation
// Revision 1.52  2002/12/02 18:07:33  gio
// borland bcc55:
// added OM_OS_NEEDS_CONST_VOID_DUMP_OPERATOR 
// operator.
// Revision 1.51  2002/11/29 08:41:29  Eldad
// 1.50.1.2  to main branch.
// Revision 1.50.1.2  2002/11/26 09:52:10  Eldad
// Avoid ^z in model by having x2String(unsigned char) that prints the hex number.
// Revision 1.50  2002/11/07 07:57:29  vova
// 59127:Smart animation on Linux platform: build errors
// Revision 1.49  2002/07/25 14:44:21  vova
// New x2string  template added
// Revision 1.48  2002/07/23 11:50:17  amos
// use omistrstream instead of istrstream.
// Revision 1.47  2002/07/23 07:14:03  amos
// add dummy method om2str_dummyOp() to avoid linker warnings in .NET
// Revision 1.46  2002/07/15 12:30:38  avrahams
// Back to main
// Revision 1.45  2002/07/11 13:08:50  amos
// do not include omosconfig.h directly
// Revision 1.44  2002/07/09 14:20:35  amos
// framework cleanup from RTOS specific code - back to r41 main branch
// Revision 1.43.2.2  2002/07/09 14:20:35  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.43.2.1  2001/05/16 12:32:34  amos
// Revision 1.43.1.2  2002/07/04 11:29:01  avrahams
// Cleanup std namespace usage
// Revision 1.43.1.1  2001/05/16 12:32:34  avrahams
// Duplicate revision
// Revision 1.43  2001/05/16 12:32:34  amos
// merge OSE 4.3.1 support into r40
// Revision 1.42  2001/04/24 14:42:15  ofer
// changes ifdefs for OSE since it works for both win32 ( sfk)
// and for target board
// Revision 1.41  2001/04/11 10:42:19  vova
// The NO_IOSTREAM_X2STRING implementation should be done for  framework only.
// Revision 1.40  2001/04/11 09:16:55  vova
// Bug #43156: no IOStream x2String implementation for unix
// Revision 1.39  2001/01/30 09:07:25  avrahams
// Add OM prefix to destructiveString2X
// Revision 1.38  2000/10/11 11:53:15  ofer
// since cadul compiler ( with psos 2.50 for x86 ) has bugs with iostream
// we had to implement x2String much alike we did in Windows CE
// Revision 1.37  2000/09/20 09:00:00  ofer
// remove unused RP_ANIM_DLL prefixes
// implement Array2String and Item2String for WinfdowsCE
// ( when _OM_NO_IOSTREAM is defined)
// Revision 1.36  2000/09/06 15:21:01  ofer
// psos 2.50 makefile uses GNU format
// x2string uses ostrstream.str which allocate ARRAY of chars
// diab data compiler os.str does not FREEZE the buffer to we have to allocate
// the buffer ourselves
// Revision 1.35  2000/03/28 12:19:26  amos
// back to main branch
// Revision 1.34.1.2  2000/03/27 09:37:36  amos
// add an override of x2String(double) for psos x86 - the default didn't work properly.
// Revision 1.34.1.1  2000/02/22 13:35:19  amos
// Duplicate revision
// Revision 1.33.1.2  2000/02/17 09:45:08  amos
// add template function Array2Item and a macro array2Item.
// Revision 1.33.1.1  2000/01/18 14:52:39  amos
// Duplicate revision
// Revision 1.32  1999/12/21 07:45:05  zvika
// Fix Windows-CE compilation error.
// Revision 1.31  1999/11/08 14:01:50  zvika
// Add DLLs.
// Revision 1.30  1999/07/01 12:55:35  sasha
// Added function array2String for instrumentation such types
// Revision 1.29.1.1  1999/11/08 11:00:25  ofer
// changes for OSE
// Revision 1.29  1999/05/27 14:32:13  ofer
// bugfix 30822 and 30839
// since the x2String is allocating memory we have to implement
// x2String for const char* as well 
// x2Item can work under WindowsCE
// Revision 1.28  1999/05/11 09:54:34  ofer
// Windows CE changes
// no iostream support and unicode ONLY ( no exceptions)
// Revision 1.27  1999/02/18 15:15:34  amos
// back to main branch
// Revision 1.26.1.2  1999/02/18 09:09:26  amos
// serialization of int, char and void* arrays for Psos and VxWorks
// Revision 1.26  1998/08/18 12:02:00  ofer
// added TMPL_INL defition for x2string and x2item  ( om2str.h)
// Revision 1.25  1998/08/04 07:48:24  beery
// patch for boolean in Borland is not relevant as we are using OMBoolean
// Revision 1.24  1998/08/02 15:08:57  beery
// changing boolean->OMBoolean
// Revision 1.23  1998/06/23 12:31:39  yachin
// fix VX virtual table problem bug
// Revision 1.22  1998/05/28 11:19:25  yachin
// Fix Bug 5921 (booleans get serialized properly)
// Revision 1.21  1998/04/13 07:41:25  ofer
// added "using namespace std;" after each include to stl files
// Revision 1.20  1998/04/12 12:17:09  ofer
// Change includes to Stl format ifdefed by OM_USE_STL
// Revision 1.19  1998/03/26 07:01:44  yachin
// Added '&'s to string2X and destructiveString2X functions (for MSDev5.0)
// Revision 1.18  1997/11/19 08:44:43  yachin
// Fixed 'inline' problems for Borland compiler
// Revision 1.17  1997/10/28 08:10:29  yachin
// try/catch(...) replaced by OMTRY and OMCATCH 
// so we catch bus-error segmentation-fault on UNIX 
// Revision 1.16  1997/08/03 15:42:12  yachin
// changed x2item to properly cast NULLs in VXWorks
// Revision 1.15  1997/07/24 05:22:37  yachin
// Revision 1.14  1997/05/13 08:25:44  yachin
// added string2X for unsigned char* (bug#3190)
// Revision 1.13  1997/04/07 23:31:00  ofer
// Revision 1.12  1997/03/13 08:50:23  yachin
// bug fix for string2X
// Revision 1.11  1997/03/11 12:57:01  yachin
// Added special string2X for "char*"
// Revision 1.10  1997/02/26 07:59:12  yachin
// added x2String which takes 2 parameters
// Revision 1.9  1997/02/17 11:38:57  yachin
// made operator>>(void *&) to template operator>>(T*&)
// Revision 1.8  1997/02/12 11:12:59  yachin
// Removed "include" for Bristol
// Revision 1.7  1997/02/11 09:59:04  yachin
// Add explicite cast to x2item
// Revision 1.6  1997/02/09 07:12:47  yachin
// Add include for Bristol
// Revision 1.5  1996/12/24 09:17:06  yachin
// Fix crash in delete[] in om2str
// Revision 1.4  1996/12/11 13:24:34  yachin
// Revision 1.3  1996/12/11 12:30:42  yachin
// fixed bug of "bad objects crash" in x2stream
// Revision 1.2  1996/12/01 08:32:06  yachin
// Revision 1.1  1996/11/24 12:37:17  yachin
// Initial revision
//

