#ifndef om_H
#define om_H "$Id: om.h 1.13 2007/03/11 12:34:36 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/omcom/rcs/om.h $
//	file version:	$Revision: 1.13 $
//
//	purpose: define top level items to tracer/animation executable
//
//	author(s):	Yachin Pnueli
//	date started:	21.5.96
//	date changed:	$Date: 2007/03/11 12:34:36 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include <oxf/rawtypes.h>

#ifdef OMTRACER
#ifndef _OMINSTRUMENT
#define _OMINSTRUMENT
#endif // _OMINSTRUMENT
#endif 

#ifdef OMANIMATOR
#ifndef _OMINSTRUMENT
#define _OMINSTRUMENT
#endif // _OMINSTRUMENT
#endif 
//
//	Definitions and macros for OMHandle
//
inline OMHandle* char2Handle(char * c) { return c; }
inline OMHandle* omstring2Handle(OMString* c) { return c->GetBuffer(0); }

//
//	Definitions and macros for OMProxyType
//
enum OMProxyType {
	omProxyItem,
	omProxyInstance,
	omProxyClass,
	omProxyEventClass,
	omProxyCallStack,
	omProxyEventQueue,
	omProxyPackage,
//	omProxyPendingTimeouts,
	omProxyStepper,
	omProxyBreakPointManager,
	omThread,
	omProxyOther
};

//
// Types of method notifications
//
enum OMMethodType {  
	// The Null value
	omUnidentifiedMethod			=	0x000,
	// Actual notification methods
	omMethodMethod					=	0x001,
	omConstructorMethod				=	0x002,
	omDestructorMethod				=	0x004,
	omBehaviourMethod				=	0x008,
	omTriggerMethod					=	0x010,
	omNullTransition				=	0x020,
	// Internal codes for aomother.h
	omInterestFactor				=	0x100,
	omInterestingMethodMethod		=	0x101,
	omInterestingConstructorMethod	=	0x102,
	omInterestingDestructorMethod	=	0x104,
	omInterestingBehaviourMethod	=	0x108,
	omInterestingTriggerMethod		=	0x110,
	omInterestingNullTransition		=	0x120
};
// uninteresting method + AOMMethodInterestFactor = equivalent interesting method
// interesting method - AOMMethodInterestFactor = equivalent uninteresting method


//
//	Various Constant Parameters used in more than one class
//

// A Constant to indicate method/event should display without parameters
// (as opposed to a "with parameters" case having 0 parameters)
const int OMSnoParameters = 32767;
// WARNING - Assumes no method or event has 32767 parameters

// Some animation item constants
// (OMCastClass is either AOMAnimationItem or TOMProxyItem)
#ifndef OMCAST_CLASS
#error "Do not include omCom/om.h directly. Use aom/aoxf.h or tom/toxf.h"
#endif 

class OMCAST_CLASS;
// Indicates the name space (context) of an item is "system" or "world"
#define OMSystemContext	((OMCAST_CLASS *)NULL)	

// The ints used as codes
#define _OMInConstruction	1
#define _OMInDestruction	3
#define _OMNotInteresting	5
#define _OMGui				7
#define _OMGarbage			9
#define _OMTrace			11
#define _OMMaxCode			99

// The "id" of an item in construction
#define OMInConstruction ((OMCAST_CLASS *)_OMInConstruction)	

// The "id" of an item in destruction
#define OMInDestruction	((OMCAST_CLASS *)_OMInDestruction)	

// The "id" of non interesting item
#define OMNotInteresting ((OMCAST_CLASS *)_OMNotInteresting)	

// The "id" of a GUI item
#define OMGui			((OMCAST_CLASS *)_OMGui)	

// The "id" of a garbage (uninitialized/deleted) item
#define OMGarbage		((OMCAST_CLASS *)_OMGarbage)	

// The "id" of a Tracer item
#define OMTrace			((OMCAST_CLASS *)_OMTrace)	


// The maximal "id" used as a animation item code
#define OMMaxCode		((OMCAST_CLASS *)_OMMaxCode)	


// Methods to check if an animation Item * is a code or a real item
inline OMBoolean isCodeItem(const void * const i) { 
	return (unsigned int)i <= (unsigned int)OMMaxCode;
}

inline OMBoolean isRealItem(const void * const i) { 
	return !isCodeItem(i);
}	
//
// $Log: om.h $
// Revision 1.13  2007/03/11 12:34:36  ilgiga
// Change copyright comment
// Revision 1.12  2007/03/01 16:43:31  ilgiga
// Telelogic instead of i-Logix
// Revision 1.11  2001/05/02 12:46:36  amos
// comment statements aftert #endif
// Revision 1.10  2000/12/27 12:08:44  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.9  2000/04/12 10:42:17  yachin
// Fix bug for PowerPC compiler
// Revision 1.8  2000/01/19 12:32:46  amos
// back to main branch
// Revision 1.7.1.2  2000/01/12 14:07:03  amos
// fix masks for null transition step
// Revision 1.7.1.1  2000/01/06 14:01:58  amos
// Revision 1.7  1999/03/08 11:09:28  ofer
// change isCodeItem to cast to unsigned int ( instead of int)
// and change IsRealItem to be nagate of isCodeItem
// Revision 1.6  1998/08/02 15:08:56  beery
// changing boolean->OMBoolean
// Revision 1.5  1997/07/31 17:26:52  yachin
// Shortened omNoParameters to short
// Revision 1.4  1997/02/11 12:53:14  yachin
// added omProxyPackage
// Revision 1.3  1997/02/06 13:32:45  yachin
// Removed the "safe" macros degraded isXXX to void *
// Revision 1.2  1996/12/23 11:51:49  yachin
// Revision 1.1  1996/11/24 12:37:15  yachin
// Initial revision
//

#endif 
