/*********************************************************************
	Rhapsody	: 7.1 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimTimeRequest
	File Path	: ..\AnimTimeRequest.h
*********************************************************************/


#ifndef AnimTimeRequest_H 

#define AnimTimeRequest_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimTimeRequest.h                                                                  
//----------------------------------------------------------------------------

class AnimField;
class AnimIntField;
class AnimMessage;
class AnimPointerField;
class AnimTimestampField;


// Requests to be notified after time interval has elapsed.
// The notification should be AnimTimeNotification
//## class AnimTimeRequest 
class AnimTimeRequest : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimTimeRequest() 
    AnimTimeRequest();
    
    //## auto_generated 
    virtual ~AnimTimeRequest();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    //## operation setTimeInterval(int) 
    void setTimeInterval(int value);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimIntField* getTimeInterval() const;
    
    //## auto_generated 
    AnimIntField* createNewTimeInterval();
    
    //## auto_generated 
    void deleteTimeInterval();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimTimeRequest _timeRequest;		//## attribute _timeRequest 
    

////    Relations and components    ////
protected :
    
    AnimIntField* timeInterval;		//## classInstance timeInterval 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimTimeRequest.h
*********************************************************************/

