/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimOpReturn
	File Path	: ..\AnimOpReturn.h
*********************************************************************/


#ifndef AnimOpReturn_H 

#define AnimOpReturn_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimOpReturn.h                                                                  
//----------------------------------------------------------------------------
class AnimField;
class AnimListField;
class AnimMessage;
class AnimMessageField;
class AnimNameValueData;
class AnimPointerField;
class AnimStringOrPointerField;
class AnimTimestampField;


// Reports the return values and output parameters
//## class AnimOpReturn 
class AnimOpReturn : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimOpReturn() 
    AnimOpReturn();
    
    //## auto_generated 
    virtual ~AnimOpReturn();


////    Operations    ////
public :
    
    // A helper routine to allow easy insertion of output string parameters.
    // Argument char* argValue : 
    // Value after being serialized.
    //## operation addArg(char*,char*) 
    void addArg(char* argName, char* argValue);
    
    // A helper routine to allow easy insertion of output string parameters.
    // Argument void * argValue : 
    // Value after being serialized.
    //## operation addArg(char*,void *) 
    void addArg(char* argName, void * argValue);
    
    // Add a class data to list.
    //## operation addArgData(AnimNameValueData*) 
    void addArgData(AnimNameValueData* argData);
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    //## operation setReturnValue(const AnimStringOrPointerField&) 
    void setReturnValue(const AnimStringOrPointerField& value);
    
    //## operation setReturnValue(void *) 
    void setReturnValue(void * pValue);
    
    //## operation setReturnValue(char*) 
    void setReturnValue(char* cValue);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimListField* getArgDataList() const;
    
    //## auto_generated 
    AnimListField* newArgDataList();
    
    //## auto_generated 
    void deleteArgDataList();
    
    //## auto_generated 
    AnimStringOrPointerField* getRetValue() const;
    
    //## auto_generated 
    AnimStringOrPointerField* newRetValue();
    
    //## auto_generated 
    void deleteRetValue();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimOpReturn opReturnPrototype;		//## attribute opReturnPrototype 
    

////    Relations and components    ////
protected :
    
    // A list of AnimNameValueData to store name value pairs of the output parameters.
    AnimListField* argDataList;		//## classInstance argDataList 
    
    
    // The return value.
    AnimStringOrPointerField* retValue;		//## classInstance retValue 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimOpReturn.h
*********************************************************************/

