/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimOpCallRequest
	File Path	: ..\AnimOpCallRequest.h
*********************************************************************/


#ifndef AnimOpCallRequest_H 

#define AnimOpCallRequest_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "AnimStringOrPointerField.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimOpCallRequest.h                                                                  
//----------------------------------------------------------------------------
class AnimField;
class AnimIntField;
class AnimListField;
class AnimMessage;
class AnimPointerField;
class AnimTimestampField;


// A request to call an operation.
//## class AnimOpCallRequest 
class AnimOpCallRequest : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimOpCallRequest() 
    AnimOpCallRequest();
    
    //## auto_generated 
    virtual ~AnimOpCallRequest();


////    Operations    ////
public :
    
    // Adds a value to argument values list.
    //## operation addArgValue(void *) 
    void addArgValue(void * value);
    
    // Adds a value to argument values list.
    //## operation addArgValue(OMString) 
    void addArgValue(OMString value);
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    // Fully clones all fields including the AnimListField.
    //## operation fullClone() 
    virtual AnimOpCallRequest* fullClone();
    
    //## operation setInstance(void *) 
    void setInstance(void * value);
    
    // Set the class name.
    //## operation setOp(void *) 
    void setOp(void * value);
    
    //## operation setRequestID(int) 
    void setRequestID(int id);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimListField* getArgValues() const;
    
    //## auto_generated 
    AnimListField* newArgValues();
    
    //## auto_generated 
    void deleteArgValues();
    
    //## auto_generated 
    AnimPointerField* getInstance() const;
    
    //## auto_generated 
    AnimPointerField* newInstance();
    
    //## auto_generated 
    void deleteInstance();
    
    //## auto_generated 
    AnimPointerField* getOp() const;
    
    //## auto_generated 
    AnimPointerField* newOp();
    
    //## auto_generated 
    void deleteOp();
    
    //## auto_generated 
    AnimIntField* getRequestID() const;
    
    //## auto_generated 
    AnimIntField* newRequestID();
    
    //## auto_generated 
    void deleteRequestID();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimOpCallRequest callRequestPrototype;		//## attribute callRequestPrototype 
    

////    Relations and components    ////
protected :
    
    // A list of AnimStringOrPointerField that hold the values of the arguments.
    AnimListField* argValues;		//## classInstance argValues 
    
    
    // The intsance on which the operation is to be invoked.
    AnimPointerField* instance;		//## classInstance instance 
    
    
    // A pointer to the operation to invoke.
    AnimPointerField* op;		//## classInstance op 
    
    
    AnimIntField* requestID;		//## classInstance requestID 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimOpCallRequest.h
*********************************************************************/

