/*********************************************************************
	Rhapsody	: 6.0 
	Component	: AnimMessages 
	Configuration 	: DefaultConfig
	Model Element	: AnimOpCallReply
	File Path	: ..\AnimOpCallReply.h
*********************************************************************/


#ifndef AnimOpCallReply_H 

#define AnimOpCallReply_H 

#include "RiCppAnimMessages.h"
#include "AnimAbstractMessage.h"
#include "AnimStringOrPointerField.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessages 

//----------------------------------------------------------------------------
// AnimOpCallReply.h                                                                  
//----------------------------------------------------------------------------
class AnimBooleanField;
class AnimField;
class AnimIntField;
class AnimMessage;
class AnimPointerField;
class AnimStringField;
class AnimTimestampField;


// A reply to an operation call request (AnimOpCallRequest).
//## class AnimOpCallReply 
class AnimOpCallReply : public AnimAbstractMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimOpCallReply() 
    AnimOpCallReply();
    
    //## auto_generated 
    virtual ~AnimOpCallReply();


////    Operations    ////
public :
    
    // Clones the message object.
    //## operation clone() 
    virtual AnimMessage* clone();
    
    // Set the class name.
    //## operation setCallStr(OMString) 
    void setCallStr(OMString value);
    
    //## operation setExceptionRaised(OMBoolean) 
    void setExceptionRaised(OMBoolean value);
    
    //## operation setRequestID(int) 
    void setRequestID(int id);
    
    //## operation setReturnValue(const AnimStringOrPointerField&) 
    void setReturnValue(const AnimStringOrPointerField& value);

protected :
    
    //## operation registerInTranslator() 
    void registerInTranslator();


////    Additional operations    ////
public :
    
    //## auto_generated 
    AnimStringField* getCallStr() const;
    
    //## auto_generated 
    AnimStringField* newCallStr();
    
    //## auto_generated 
    void deleteCallStr();
    
    //## auto_generated 
    AnimBooleanField* getExceptionRaised() const;
    
    //## auto_generated 
    AnimBooleanField* newExceptionRaised();
    
    //## auto_generated 
    void deleteExceptionRaised();
    
    //## auto_generated 
    AnimIntField* getRequestID() const;
    
    //## auto_generated 
    AnimIntField* newRequestID();
    
    //## auto_generated 
    void deleteRequestID();
    
    //## auto_generated 
    AnimStringOrPointerField* getRetValue() const;
    
    //## auto_generated 
    AnimStringOrPointerField* newRetValue();
    
    //## auto_generated 
    void deleteRetValue();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // A static instance for registration.
    static AnimOpCallReply callReplyPrototype;		//## attribute callReplyPrototype 
    

////    Relations and components    ////
protected :
    
    // A convinience string that holds the call string.
    AnimStringField* callStr;		//## classInstance callStr 
    
    
    // Indicates if an exception was raised.
    AnimBooleanField* exceptionRaised;		//## classInstance exceptionRaised 
    
    
    AnimIntField* requestID;		//## classInstance requestID 
    
    
    // The return value.
    AnimStringOrPointerField* retValue;		//## classInstance retValue 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimOpCallReply.h
*********************************************************************/

