/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimMessageTranslator
	File Path	: ..\AnimMessageTranslator.h
*********************************************************************/


#ifndef AnimMessageTranslator_H 

#define AnimMessageTranslator_H 

#include "RiCppAnimMessageTranslator.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimMessageTranslator.h                                                                  
//----------------------------------------------------------------------------
class AnimBooleanField;
class AnimCodeField;
class AnimIntField;
class AnimListField;
class AnimMessage;
class AnimMessageField;
class AnimPointerField;
class AnimStringField;
class AnimStringOrPointerField;
class AnimTimestampField;


//## class AnimMessageTranslator 
class AnimMessageTranslator  {


////    Operations    ////
public :
    
    // Decode AnimIntField.
    // Argument AnimIntField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimIntField*) 
    virtual void decodeField(AnimIntField* field)=0;
    
    // Decode AnimListField.
    // Argument AnimListField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimListField*) 
    virtual void decodeField(AnimListField* field)=0;
    
    // Decode AnimPointerField.
    // Argument AnimPointerField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimPointerField*) 
    virtual void decodeField(AnimPointerField* field)=0;
    
    // Decode AnimStringField.
    // Argument AnimStringField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimStringField*) 
    virtual void decodeField(AnimStringField* field)=0;
    
    // Decode AnimTimestampField.
    // Argument AnimTimestampField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimTimestampField*) 
    virtual void decodeField(AnimTimestampField* field)=0;
    
    // Decode AnimMessageField.
    // Argument AnimMessageField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimMessageField*) 
    virtual void decodeField(AnimMessageField* field)=0;
    
    // Decode AnimIntField.
    // Argument AnimBooleanField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimBooleanField*) 
    virtual void decodeField(AnimBooleanField* field)=0;
    
    // Decode AnimIntField.
    // Argument AnimCodeField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimCodeField*) 
    virtual void decodeField(AnimCodeField* field)=0;
    
    // Decode AnimPointerField.
    // Argument AnimStringOrPointerField* field : 
    // The field to be encoded.
    //## operation decodeField(AnimStringOrPointerField*) 
    virtual void decodeField(AnimStringOrPointerField* field)=0;
    
    // Decodes protocol data to an AnimMessage.
    // Argument void * data : 
    // Protocol data to be decoded.
    //## operation decodeMessage(void *) 
    virtual AnimMessage* decodeMessage(void * data)=0;
    
    // Encode AnimIntField.
    // Argument AnimIntField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimIntField*) 
    virtual void encodeField(AnimIntField* field)=0;
    
    // Encode AnimListField.
    // Argument AnimListField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimListField*) 
    virtual void encodeField(AnimListField* field)=0;
    
    // Encode AnimPointerField.
    // Argument AnimPointerField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimPointerField*) 
    virtual void encodeField(AnimPointerField* field)=0;
    
    // Encode AnimStringField.
    // Argument AnimStringField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimStringField*) 
    virtual void encodeField(AnimStringField* field)=0;
    
    // Encode AnimTimestampField
    // Argument AnimTimestampField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimTimestampField*) 
    virtual void encodeField(AnimTimestampField* field)=0;
    
    // Encode AnimMessageField
    // Argument AnimMessageField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimMessageField*) 
    virtual void encodeField(AnimMessageField* field)=0;
    
    // Encode AnimIntField.
    // Argument AnimBooleanField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimBooleanField*) 
    virtual void encodeField(AnimBooleanField* field)=0;
    
    // Encode AnimIntField.
    // Argument AnimCodeField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimCodeField*) 
    virtual void encodeField(AnimCodeField* field)=0;
    
    // Encode AnimPointerField.
    // Argument AnimStringOrPointerField* field : 
    // The field to be encoded.
    //## operation encodeField(AnimStringOrPointerField*) 
    virtual void encodeField(AnimStringOrPointerField* field)=0;
    
    // Encodes message to protocol.
    // Argument AnimMessage* message : 
    // Message to be encoded\translated before sending to the other side 
    // (application or browser).
    //## operation encodeMessage(AnimMessage*) 
    virtual void * encodeMessage(AnimMessage* message)=0;
    
    //## operation getLastErrorMessage() 
    virtual OMString getLastErrorMessage() const=0;
    
    // Get a clone of the message according to code.
    //## operation getMessageClone(int) 
    virtual AnimMessage* getMessageClone(int code)=0;
    
    // Register message prototypes to be 'cloned' for message decoding.
    // Argument AnimMessage* animMessage : 
    // Message to be registered.
    //## operation registerMessagePrototype(AnimMessage*) 
    virtual void registerMessagePrototype(AnimMessage* animMessage)=0;


};


#endif  
/*********************************************************************
	File Path	: ..\AnimMessageTranslator.h
*********************************************************************/

