/*********************************************************************
	Rhapsody	: 6.0 
	Component	: MessageTranslator 
	Configuration 	: DefaultConfig
	Model Element	: AnimAbstractMessage
	File Path	: ..\AnimAbstractMessage.h
*********************************************************************/


#ifndef AnimAbstractMessage_H 

#define AnimAbstractMessage_H 

#include "RiCppAnimMessageTranslator.h"
#include <oxf/omcollec.h>
#include "AnimMessage.h"
#include "oxf/rawtypes.h"

//## package RiCppAnimMessageTranslator 

//----------------------------------------------------------------------------
// AnimAbstractMessage.h                                                                  
//----------------------------------------------------------------------------
class AnimField;
class AnimMessageField;
class AnimPointerField;
class AnimTimestampField;


//## class AnimAbstractMessage 
class AnimAbstractMessage : public AnimMessage {


////    Constructors and destructors    ////
public :
    
    //## operation AnimAbstractMessage() 
    AnimAbstractMessage();
    
    //## operation ~AnimAbstractMessage() 
    virtual ~AnimAbstractMessage();


////    Operations    ////
public :
    
    // return the next field in the message.
    //## operation getNextField() 
    virtual AnimField* getNextField();
    
    //## operation getTimeStamp() 
    AnimTimestampField* getTimeStamp();
    
    //## operation resetFieldIterator() 
    void resetFieldIterator();
    
    // Argument void * _destOrSource : 
    // destOrSource value.
    //## operation setDestOrSource(void *) 
    void setDestOrSource(void * _destOrSource);
    
    // Argument const AnimPointerField& _destOrSource : 
    // destOrSource field.
    //## operation setDestOrSource(const AnimPointerField&) 
    void setDestOrSource(const AnimPointerField& _destOrSource);
    
    // Set the next field value in the message.
    //## operation setNextField(AnimMessageField*) 
    virtual void setNextField(AnimMessageField* _field);
    
    //## operation setTimeStamp(timeUnit) 
    virtual void setTimeStamp(timeUnit _timeStamp);
    
    //## operation setTimeStamp(const AnimTimestampField&) 
    virtual void setTimeStamp(const AnimTimestampField& _timeStamp);


////    Additional operations    ////
public :
    
    //## auto_generated 
    int getCode() const;
    
    //## auto_generated 
    void setCode(int p_code);
    
    //## auto_generated 
    AnimPointerField* getDestOrSource() const;
    
    //## auto_generated 
    AnimPointerField* newDestOrSource();
    
    //## auto_generated 
    void deleteDestOrSource();
    
    //## auto_generated 
    OMIterator<AnimField*> getField() const;
    
    //## auto_generated 
    void addField(AnimField* p_AnimField);
    
    //## auto_generated 
    void removeField(AnimField* p_AnimField);
    
    //## auto_generated 
    void clearField();
    
    //## auto_generated 
    AnimTimestampField* newTimeStamp();
    
    //## auto_generated 
    void deleteTimeStamp();


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void initRelations();
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
protected :
    
    // Identifies message type.
    int code;		//## attribute code 
    
    // A field iterator, used for successive getNextField() calls.
    OMIterator<AnimField*>* fieldIterator;		//## attribute fieldIterator 
    

////    Relations and components    ////
protected :
    
    AnimPointerField* destOrSource;		//## classInstance destOrSource 
    
    
    OMCollection<AnimField*> field;		//## link field 
    
    
    AnimTimestampField* timeStamp;		//## classInstance timeStamp 
    


};


#endif  
/*********************************************************************
	File Path	: ..\AnimAbstractMessage.h
*********************************************************************/

