#ifndef aomthrd_H
#define aomthrd_H "$Id: aomthrd.h 1.11 2007/03/11 11:57:54 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomthrd.h $
//	file version:	$Revision: 1.11 $
//
//	purpose:	AOM classes of Threads thread managers etc.
//
//	author(s):	  Yachin Pnueli
//	date started:	22.1.97
//	date changed:	$Date: 2007/03/11 11:57:54 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//


#include "aomitem.h"

class AOMCallStack;
class AOMStepper;
class AOMEventQueue;
class AOMInstance;
class OMOSThread;
class IOxfActive;

class RP_FRAMEWORK_DLL AOMThread: public AOMAnimationItem
{
public:
	AOMThread(IOxfActive* context, OMOSThread* thread, bool dynamicAllocated = true);
	AOMThread(IOxfActive* context, void* handle, bool dynamicAllocated = true);
	~AOMThread();

	// Destry the thread if it was allocated dynamically
	void destroy();
	
	// sync. the thread context
	void sync(IOxfActive* context);

	// defered part of construction
	void setName(AOMInstance * owner);
	void setName(const char * name);
	
	// Simple accessors
	AOMCallStack* getCallStack() const
	{
		return callStack;
	}

	AOMStepper* getStepper() const 
	{ 
		return stepper; 
	}
	
	AOMEventQueue* getEventQueue() const 
	{ 
		return eventQueue; 
	}

	IOxfActive* getActiveContext() const
	{
		return activeContext;
	}
	
	// Weakup the thread when it is waiting for events
	void wakeup();
	// return the wakeupRequested state
	bool wasWakeupRequested() const;
	// reset the wakeupRequested state
	// should be called only by the thread's queue
	void resetWakeupToken();

	// Recreator
	void resetActualThread(OMOSThread* thread);
	void resetActualThread(void* thread);

	void sendYourName();

	// Get the singleton AOMThread that represent the main system thread
	static AOMThread* getDefaultThread(IOxfActive* context);

	// Get the AOM thread associated with the specified OS thread
	// osThread == 0 is handles as osThread == <current thread>
	static AOMThread* getThread(void* osThread);

	// Get the AOM thread associated with the specified active context
	static AOMThread* getThread(IOxfActive* context);

private:
	void init(IOxfActive* context, void* handle);
	
	// indicator that the instance was allocated dynamically
	bool isDynamicAllocated;

	// indicates that the thread issued a wakeup request to the real thread
	bool wakeupRequested;

	AOMCallStack* callStack;
	AOMStepper* stepper;
	AOMEventQueue* eventQueue;
	OMString myCharName;
	AOMInstance* myOwner;
	IOxfActive* activeContext;

};


RP_FRAMEWORK_DLLV(extern) AOMThread * OMGetCurrentThread();
RP_FRAMEWORK_DLLV(extern) AOMThread * OMPassiveGetCurrentThread();
inline AOMStepper * OMGetCurrentStepper() {
	return OMGetCurrentThread()->getStepper();
}
inline AOMStepper * OMPassiveGetCurrentStepper() {
	AOMThread * thread = OMPassiveGetCurrentThread();
	if (thread!=0)
		return thread->getStepper();
	else
		return 0;
}
inline AOMCallStack * OMGetCurrentCallStack() {
	return OMGetCurrentThread()->getCallStack();
}

// API for "friendly nonOMThread application threads
extern void OMRegisterForeignThread(char * name);
extern void OMRegisterForeignThread(char * name, void* theHandle);
extern void OMDeregisterForeignThread();
extern void OMDeregisterForeignThread(void* theHandle);

//
// $Log: aomthrd.h $
// Revision 1.11  2007/03/11 11:57:54  ilgiga
// Change copyright comment
// Revision 1.10  2007/03/01 16:31:26  ilgiga
// Telelogic instead of i-Logix
// Revision 1.9  2005/10/17 12:12:40  amos
// Prevent the attempt to delete the statically allocated AOMThread:
// - AOMThread:
//   - add new public operation void destroy()
//     the operation destroy delete a thread only when its dynamically allocated
//   - a new argument bool dynamicAllocated = true added to the constructors 
//     the argument sets a new private boolean attribute bool isDynamicAllocated
//     that is used by the destroy() operation
//   - AOMThread::getDefaultThread() pass false as the third constructor 
//     argument to prevent destruction
// - AnimServices::notifyThreadDestroyed() - call AOMThread::destroy() instead of calling delete directly
// Revision 1.8  2005/04/21 10:03:29  amos
// Revision 1.7.1.7  2005/04/10 15:25:23  amos
// Revision 1.7.1.6  2005/04/07 12:50:02  amos
// Revision 1.7.1.5  2005/04/04 13:48:48  amos
// Revision 1.7.1.4  2005/03/16 14:02:38  amos
// Revision 1.7.1.3  2005/03/10 14:25:08  amos
// Implementing AnimServices
// Revision 1.7.1.2  2005/03/09 12:22:37  amos
// Initial support in decoupling of AOM from the OXF core implementation
// Revision 1.7.1.1  2000/12/27 08:45:52  amos
// Duplicate revision
// Revision 1.6  1998/09/09 13:15:25  ofer
// OMPassiveGetCurrentStepper have to use OmPassiveGetCurrentThread
// otherwise a wrapper thread will e created
// Revision 1.4  1997/02/26 11:35:58  yachin
// NOTIFY_LOCK - works on passiveGetCurrentThread
// Revision 1.3  1997/01/30 13:31:23  yachin
// Revision 1.2  1997/01/27 09:44:19  yachin
// Enter foreign threads
// Revision 1.1  1997/01/26 14:02:41  yachin
// Initial revision
//

#endif
