#ifndef aomstep_H
#define aomstep_H "$Id: aomstep.h 1.30 2007/03/11 11:57:53 ilgiga Exp $"

//
//	file name   :	$Source
//	file version:	$Revision: 1.30 $
//
//	purpose:	AOM stepper and break point manager classes
//
//	author(s):	  Yachin Pnueli
//	date started:	9.7.96
//	date changed:	$Date: 2007/03/11 11:57:53 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aomitem.h"
#include <oxf/omlist.h>

//
//	AOMStepper	-	The "executable" stepper responsible for stopping
//				at every "step" or other desirable "happening"
//						
class AOMThread;
class OMOSEventFlag;
class IOxfReactive;

class AnimMessage;
class AnimOpCallRequest;

class AOMStepper :public AOMAnimationItem {
private:
	bool shouldStop;
	bool isLocked;
	bool suspended;
	OMOSEventFlag* stopSignal;
	AOMThread * myThread;

	OMList<AnimOpCallRequest *> opCallRequests;

	void notifyGoingToStop(OMNotify reason);
	void doStep();
	virtual int getDefaultMask() const { return OMNoStop; }

	bool callInProcess;

public:
	RP_FRAMEWORK_DLL virtual ~AOMStepper();
	RP_FRAMEWORK_DLL AOMStepper(AOMThread* theThread);

	RP_FRAMEWORK_DLL void registerMyself();

	RP_FRAMEWORK_DLL void notifyStep();
	
	// notify on a null transition step (currently called only by the NOTIFY_NULL_TRANSITION_STEP() macro)
	RP_FRAMEWORK_DLL void notifyNullTransitionStep();

	RP_FRAMEWORK_DLL void continueRequest(AOMStepper*);

	RP_FRAMEWORK_DLL void stopRequest();
	RP_FRAMEWORK_DLL void stopMyself(OMNotify reason, int timeLimit=-1);

	RP_FRAMEWORK_DLL void notifyEvent();

	RP_FRAMEWORK_DLL void notifyIdle();

	RP_FRAMEWORK_DLL void notifyBreakPoint();

	RP_FRAMEWORK_DLL void notifyLock(bool locked) { isLocked = locked; doStep(); }

	RP_FRAMEWORK_DLL virtual void handleMessage(OMNotify r, OMSData* s, OMSPosition& p);
	RP_FRAMEWORK_DLL virtual void handleMessage(AnimMessage* animMessage);

	RP_FRAMEWORK_DLL void sendYourName();
	
	void handleOpCallRequests();
};




//
// $Log: aomstep.h $
// Revision 1.30  2007/03/11 11:57:53  ilgiga
// Change copyright comment
// Revision 1.29  2007/03/01 16:31:26  ilgiga
// Telelogic instead of i-Logix
// Revision 1.28  2005/04/21 10:03:28  amos
// Revision 1.27.1.2  2005/03/16 14:02:37  amos
// Revision 1.27  2004/09/08 13:02:41  amos
// 75108 to main branch
// Revision 1.26.1.2  2004/09/07 14:17:45  amos
// Rename the framework interfaces and types to ensure unique names as well as updating all references.
// - IActive changed to IOxfActive
// - IReactive changed to IOxfReactive
// - IEvent changed to IOxfEvent
// - ITimeout changed to IOxfTimeout
// - IEventGenerationParams changed to IOxfEventGenerationParams
// - TimeUnit changed to OxfTimeUnit
// Revision 1.26.1.1  2004/06/27 15:43:05  amos
// Duplicate revision
// Revision 1.25.1.2  2004/02/04 13:52:08  amos
// Revision 1.25.1.1  2002/08/05 11:21:08  amos
// Duplicate revision
// Revision 1.24.1.2  2002/08/01 10:21:12  Eldad
// call per thread.
// Revision 1.24.1.1  2002/07/29 11:41:16  Eldad
// Duplicate revision
// Revision 1.23.1.1  2002/01/03 15:19:52  Eldad
// Duplicate revision
// Revision 1.22.1.1  2001/04/17 15:21:22  Eldad
// Duplicate revision
// Revision 1.21.1.2  2001/04/09 15:03:55  Eldad
// Refactoring of AnimMessages.
// Revision 1.21.1.1  2000/12/27 08:45:36  Eldad
// Duplicate revision
// Revision 1.20  2000/01/19 12:30:35  amos
// back to main branch
// Revision 1.19.2.4  2000/01/12 14:02:09  amos
// add notifyNullTransitionStep() that handle the null transition steps.
// notifyStep() handle all other steps (i.e. regular steps).
// Revision 1.19.2.3  2000/01/05 12:01:49  amos
// animation
// Revision 1.19.2.2  2000/01/04 15:07:37  amos
// remove notifySingleStep(), instead add parameter to notifyStep()
// Revision 1.19.2.1  2000/01/03 16:04:48  amos
// add notifySinglStep()
// Revision 1.19  1999/02/16 06:08:04  yachin
// Speed up of construction during animation
// Revision 1.18  1998/08/02 15:02:05  beery
// changing boolean->bool
// Revision 1.17  1997/07/20 11:41:08  yachin
// Adding globals to animation
// Revision 1.16  1997/01/26 13:50:03  yachin
// ReWrite for Foreign Threads
// Revision 1.15  1997/01/19 07:39:05  yachin
// Rewrite of aomSchedDisp statechart
// Revision 1.14  1996/12/26 13:48:43  yachin
// Revision 1.13  1996/12/25 13:42:49  yachin
// removed #ifdef from defintion of OMThread
// Revision 1.12  1996/11/24 12:55:30  yachin
// Revision 1.11  1996/11/11 11:47:01  yachin
// Support multi-thread part I
// Revision 1.10  1996/11/07 07:49:07  yachin
// fix step not idle bug
// Revision 1.9  1996/10/09 07:34:02  yachin
// Revision 1.8  1996/08/29 10:46:14  ofer
// Revision 1.7  1996/08/15 08:40:54  yachin
// Revision 1.6  1996/08/12 12:34:42  yachin
// Seperated show from trace (possibly has bug if existence is canceled and then turned on).
// Revision 1.5  1996/08/08 08:22:19  yachin
// Prototype 4 major revision
// Revision 1.4  1996/08/06 12:49:56  yachin
// Tracer for Prototype 4
// Revision 1.3  1996/07/18 10:48:57  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.2  1996/07/10 05:48:51  yachin
// Revision 1.1  1996/07/10 05:47:55  yachin
// Initial revision
//

#endif
