#ifndef aompack_H
#define aompack_H "$Id: aompack.h 1.7 2007/03/11 11:57:53 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aompack.h $
//	file version:	$Revision: 1.7 $
//
//	purpose:	The Harness for global instances and vars
//
//	author(s):	  Yachin Pnueli
//	date started:	15.7.97
//	date changed:	$Date: 2007/03/11 11:57:53 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1997, 2007
//
#include "aomitem.h"

class AOMSAttributes;


class RP_FRAMEWORK_DLL AOMPackage: public AOMAnimationItem {
	int globalVarCount;
	const char* name;
protected:
	void setInstanceName(AOMAnimationItem* theItem,
						 char* theName,
						 int theMult = AOMNoMultiplicity) const;
public:
	AOMPackage(const char* theName);
	virtual void sendMyself(OMInterestMask theMask);
	virtual void renameGlobalInstances()const { }
	virtual void serializeGlobalVars(AOMSAttributes&)const { }
	void setGlobalVarCount(int theCount) { globalVarCount = theCount; }
	int getGlobalVarCount() const { return globalVarCount; }
	
	// do not notify got and losy control - only AOMInstances may do that
	virtual void notifyGotControl() const { }
	virtual void notifyLostControl() const { }

};

//
// $Log: aompack.h $
// Revision 1.7  2007/03/11 11:57:53  ilgiga
// Change copyright comment
// Revision 1.6  2007/03/01 16:31:26  ilgiga
// Telelogic instead of i-Logix
// Revision 1.5  2006/07/26 13:32:29  eldad
// To main branch
// Revision 1.4.1.2  2006/07/24 13:48:49  eldad
// AOMPackage should not notify got and lost control.
// For that, the notify methods are now virtual for AOMAnimationItem
// Revision 1.4.1.1  2001/12/03 12:05:37  eldad
// Duplicate revision
// Revision 1.3.1.2  2001/11/28 14:39:44  Eldad
// Removed const about AOMNoMultiplicity to AOMItem.h
// Revision 1.3.1.1  2001/01/04 14:15:06  Eldad
// Duplicate revision
// Revision 1.2  2001/01/04 11:58:22  amos
// modify AOMPackage::name definition from 'char*' to 'const char*'
// modify the type of the variable in AOMPackage CTOR from 'char*' to 'const char*'
// Revision 1.1  1997/07/20 11:40:06  yachin
// Initial revision
//

#endif
