#ifndef aomoper_H
#define aomoper_H "$Id: aomoperation.h 1.6 2007/03/11 11:57:53 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomoperation.h $
//	file version:	$Revision: 1.6 $
//
//	purpose:	Proxy class for operations that may be called.
//				( "     "    "   "  real classes)
//
//	author(s):	  Eldad Palachi
//	date started:	17.7.02
//	date changed:	$Date: 2007/03/11 11:57:53 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aomitem.h"
//
//	AOMOperation - A proxy class for operations.
//
class AOMClass;
class AOMInstance;

class AnimListField;
class AnimRegisterOperations;
class AnimOpCallRequest;
class AOMAnimationItem;
class AnimStringOrPointerField;

class RP_FRAMEWORK_DLL AOMOperation :public AOMAnimationItem {
protected:
	AOMClass *myClass;
	OMString name; 
	bool isStatic;
	OMString signature;
	int numOfArgs;


	virtual void unserializeArguments(AnimListField *argValues) = 0;
	virtual AnimStringOrPointerField invoke(AOMInstance *theInstance) = 0;

	bool prepareListForDeserialization(AnimListField *argValues);
	char *getNextStr(AnimListField *argValues);
	void *getNextPtr(AnimListField *argValues);

	static OMString requestToString(AnimOpCallRequest *req);

public:
	AOMOperation();
	AOMOperation(OMString i_name, bool i_isStatic, OMString i_signature, int numOfArgs, AOMClass *theClass);
	AOMOperation(AOMOperation&);
	virtual ~AOMOperation() { }

	inline bool getIsStatic() { return isStatic; }

	// overide by the real class
	virtual AOMClass * getClass() const { return myClass; }
	virtual void setMyClass(AOMClass* theClass) { myClass = theClass; }

	// sends a registration message to Rhapsody.
	void addRegisterData(AnimRegisterOperations* msg);

	// handle request for calls.
	static void doOpCallRequest(AnimOpCallRequest *req);

};


#endif

