#ifndef aommacro_H
#define aommacro_H "$Id: aommacro.h 1.162 2007/04/17 12:11:44 ilshgo Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aommacro.h $
//	file version:	$Revision: 1.162 $
//
//	purpose:	AOM All the instrumentation macros
//
//	author(s):	  Yachin Pnueli
//	date started:	21.1.97
//	date changed:	$Date: 2007/04/17 12:11:44 $
//	last change by:	$Author: ilshgo $
//
//	(c) Copyright Telelogic 1995, 2007
//
#ifdef _OMINSTRUMENT
#include "aommsg.h"
#include "aomevent.h"
#include "aomdisp.h"
#include "aomee.h"
#include "aomNotifyUtils.h"
#endif

// Offset data-member added to composite classes in order to avoid composite and part with the same address
// class Composite
// {
//    Part p;
// };

//
//	Macros for the definition of the package - currently assumes 
//	a file define objects from a single package.
//
#ifdef _OMINSTRUMENT
#define DECLARE_META_PACKAGE(package) \
	static const char * aompackage = #package ;
#else
#define DECLARE_META_PACKAGE(package)
#endif

#ifndef NAMESPACE_PREFIX
#define NAMESPACE_PREFIX
#endif

//
//	Macros for the implementation of a package - needed for
//	maintaining animation of global variables, instances and 
//	methods
//
#ifdef _OMINSTRUMENT
// forward declaretion of the package AOM class
#define DECLARE_PACKAGE(package)			\
	class AOM##package##Globals;			\
	extern AOM##package##Globals aom##package##Global;
#else
#define DECLARE_PACKAGE(package)
#endif
#ifdef OM_NO_CAST_NULL_TO_BASE_CLASS_PTR
#define X2ITEM(x) ((x)==0)?(AOMAnimationItem*)0:AOMSchedDispatcher::instance()->getAOMInstance(x)
#else
#define X2ITEM(x) AOMSchedDispatcher::instance()->getAOMInstance(x)
#endif // OM_NO_CAST_NULL_TO_BASE_CLASS_PTR

#ifdef _OMINSTRUMENT
// Call of  serializeGlobalVars function for instrumentation of global variables.
// Not supported for SUN compiles SC5.0 , SC5.1(compiler bug).

#ifdef OM_NO_SERIALIZE_GLOBAL_VARS
#define CALL_SERIALIZE_GLOBAL_VARS(list)
#else 
#define CALL_SERIALIZE_GLOBAL_VARS(list) ::NAMESPACE_PREFIX serializeGlobalVars(&(list))
#endif // OM_NO_SERIALIZE_GLOBAL_VARS

#define IMPLEMENT_META_PACKAGE(package, fullName)					\
	DECLARE_META_PACKAGE(fullName)						\
class AOM##package##Globals : public AOMPackage {		\
public:													\
AOM##package##Globals(const char* aomName):AOMPackage(aomName) { }	\
	/*void renameGlobalInstances()const;*/				\
	void serializeGlobalVars(AOMSAttributes& aomsAttributes)const {	\
		aomsAttributes.setCount(getGlobalVarCount());	\
		CALL_SERIALIZE_GLOBAL_VARS(aomsAttributes);		\
		AOMPackage* me = (AOMPackage*)this;				\
		me->setGlobalVarCount(aomsAttributes.end());	\
	}													\
};														\
AOM##package##Globals aom##package##Global(aompackage);
#else
#define IMPLEMENT_META_PACKAGE(package, fullName)
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_VARIABLE(var) vList.addAttribute(#var, x2String(var));
#else
#define DECLARE_VARIABLE(inst)
#endif

#ifdef _OMINSTRUMENT
#define LIST_GLOBAL_VARIABLES(package) \
void AOM##package##Globals::serializeGlobalVars(AOMSAttributes& vList) const {		\
	vList.setCount(getGlobalVarCount());
#else
#define LIST_GLOBAL_VARIABLES(package)
#endif

#ifdef _OMINSTRUMENT
#define END_GLOBAL_VARIABLE_LIST						\
	AOMPackage* me = (AOMPackage*)this;					\
	me->setGlobalVarCount(vList.end());					\
}
#else
#define END_GLOBAL_VARIABLE_LIST
#endif



//
//	 Macros for the instrumetation of the "MetaClass" definition in a Class
//
//	Includes:
//	1.	Definition of the "myClass" attribute
//	2.	A public (virtual) method to access it
//	3.	A private static method to access myClass before any instances exist.
//

// Common part of all DECLARE...META... macros
#define DECLARE_META_BODY(SampleClassType)							\
protected:											\
	static AOMClass _myAOMClass;					\
	SampleClassType *myReal;										\
public:												\
	virtual void* getMyReal() { return myReal; }				\
	static AOMClass * staticGetClass() { return &_myAOMClass; }	\
	AOMClass * getClass() const { return &_myAOMClass; } \
	inline void dummyToAvoidUnusedVarWarning(){}


#ifndef OM_REUSABLE_STATECHART_IMPLEMENTATION
#define ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)										\
	void NAMESPACE_PREFIX AnimSampleClass::serializeStates(AOMSState*  aomsState) const {	\
		rootState_serializeStates(aomsState);}	
#else
#define ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)										\
	void NAMESPACE_PREFIX AnimSampleClass::serializeStates(AOMSState*  aomsState) const {	\
		myReal->rootState_serializeStates(aomsState);}	   
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_META(SampleClassType,AnimSampleClass)														\
	DECLARE_META_BODY(SampleClassType)														\
    AnimSampleClass(SampleClassType* userClassPtr);	\
	virtual ~AnimSampleClass(){ } \
	virtual void serializeStates(AOMSState *) const {}									\
private:
#else
#define DECLARE_META(SampleClassType,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_REACTIVE_META(SampleClassType,AnimSampleClass)													\
	DECLARE_META_BODY(SampleClassType)															\
	virtual ~AnimSampleClass(){ } \
	virtual void serializeStates(AOMSState*  aomsState) const; 	\
    AnimSampleClass(SampleClassType* userClassPtr); 					\
private:
#else
#define DECLARE_REACTIVE_META(SampleClassType,AnimSampleClass)
#endif

// macros for multiple inheritance animation
#ifdef _OMINSTRUMENT
#ifdef OM_ESTL 

	#define OMINIT_AOMINSTANCE 
	#define OMINIT_REACTIVE_AOMINSTANCE 

#else
	#define OMINIT_AOMINSTANCE \
		AOMInstance((IOxfReactive*)0),
	#define OMINIT_REACTIVE_AOMINSTANCE \
		AOMInstance((IOxfReactive*)userClassPtr), 
#endif // OM_ESTL
 

#define OMREGISTER_REACTIVE_CLASS \
	OMREGISTER_CLASS
#define OMREGISTER_CLASS \
	myReal(userClassPtr)	\
	{AOMSchedDispatcher::instance()->registerAOMInstance(myReal, (AOMInstance*)this);}


#define OMINIT_SUPERCLASS(SuperClass,animSuperClass) \
	animSuperClass((SuperClass*)userClassPtr),
#endif // _OMINSTRUMENT 
#define ADD_ITEM(SampleClassType) 	addItem(AOMSchedDispatcher::instance()->getAOMInstance(SampleClassType))						

//
//	For template objects
//
#ifdef _OMINSTRUMENT
#define DECLARE_META_PREFIX(tname)					\
	extern AOMClass* getAOMClassOf##tname ();
#else
#define DECLARE_META_PREFIX(tname)
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_META_T(tname, ttype,animTname)	\
protected:											\
	ttype *myReal;						\
public:												\
    animTname(ttype* userClassPtr): AOMInstance((IOxfReactive*)0),myReal(userClassPtr) {	\
	AOMSchedDispatcher::instance()->registerAOMInstance(myReal,  (AOMInstance*)this);}	\
	virtual ~animTname(){ } \
	virtual void* getMyReal() { return myReal; }										\
	static AOMClass * staticGetClass() { return getAOMClassOf##tname (); }	\
	inline void dummyToAvoidUnusedVarWarning(){} \
	AOMClass * getClass() const { return getAOMClassOf##tname (); }	\
	virtual void serializeStates(AOMSState *) const {}									\
private:
#else
#define DECLARE_META_T(tname, ttype,animTname)
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_REACTIVE_META_T(tname, ttype,animTname)	\
protected:										\
	ttype *myReal;								\
public :										\
    animTname(ttype* userClassPtr): AOMInstance((IOxfReactive*)userClassPtr),myReal(userClassPtr)		\
	{												\
		AOMSchedDispatcher::instance()->registerAOMInstance(myReal,  (AOMInstance*)this);	\
	}												\
	virtual ~animTname(){ } \
	virtual void* getMyReal() { return myReal; }							\
	static AOMClass * staticGetClass() { return getAOMClassOf##tname (); }	\
	inline void dummyToAvoidUnusedVarWarning(){} \
	AOMClass * getClass() const { return getAOMClassOf##tname (); }		\
private:
#else
#define DECLARE_REACTIVE_META_T(tname, ttype,animTname)
#endif


#ifdef _OMINSTRUMENT
#define DECLARE_META_SUBCLASS_T(tname,ttype,animTname)		\
protected:													\
	ttype *myReal;											\
public :													\
	virtual ~animTname(){ } \
	virtual void* getMyReal() { return myReal; }							\
	static AOMClass * staticGetClass() { return getAOMClassOf##tname (); }	\
	AOMClass * getClass() const { return getAOMClassOf##tname (); }			\
	inline void dummyToAvoidUnusedVarWarning(){}							\
	virtual void serializeStates(AOMSState *) const {}						\
    animTname(ttype* userClassPtr):
#else
#define DECLARE_META_SUBCLASS_T(tname,ttype,animTname)
#endif


#ifdef _OMINSTRUMENT
#define DECLARE_REACTIVE_META_SUBCLASS_T(tname,ttype,animTname)	\
protected:															\
	ttype *myReal;													\
public :															\
	virtual ~animTname(){ } \
	virtual void* getMyReal() { return myReal; }							\
	static AOMClass * staticGetClass() { return getAOMClassOf##tname (); }	\
	inline void dummyToAvoidUnusedVarWarning(){}							\
	AOMClass * getClass() const { return getAOMClassOf##tname (); }			\
    animTname(ttype* userClassPtr):
#else
#define DECLARE_REACTIVE_META_SUBCLASS_T(tname,ttype,animTname)
#endif


//
//	Macros for the instrumentation of the meta classes
//

// The no super class case

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META(SampleClassName,Package,IsSingleton,AnimSampleClass)				\
	IMPLEMENT_META_OBJECT(SampleClassName,SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_META_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)				\
	IMPLEMENT_META_OBJECT_P(SampleClassName,SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#else
#define IMPLEMENT_META(SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_META_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META(SampleClassName,Package,IsSingleton,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_OBJECT(SampleClassName,SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_OBJECT_P(SampleClassName,SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META(SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_SIMPLE(SampleClassName,Package,IsSingleton,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT(SampleClassName,SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_SIMPLE_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT_P(SampleClassName,SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_SIMPLE(SampleClassName,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_SIMPLE_P(SampleClassName,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif

// A single super class case
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_S(SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)	\
	IMPLEMENT_META_S_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#define IMPLEMENT_META_S_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)	\
	IMPLEMENT_META_S_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#else
#define IMPLEMENT_META_S(SampleClassName,IsSingleton,SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_META_S_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_S_SIMPLE(SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)		\
	IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)		\
	IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_S_SIMPLE(SampleClassName,IsSingleton,SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_S(SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)		\
	IMPLEMENT_REACTIVE_META_S_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_S_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)		\
	IMPLEMENT_REACTIVE_META_S_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_S(SampleClassName,IsSingleton,SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_REACTIVE_META_S_P(SampleClassName,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif


// A multiple super class case
// Note the fourth (array) variable has to be instrumented separately
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_M(SampleClassName,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_META_M_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#define IMPLEMENT_META_M_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_META_M_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#else
#define IMPLEMENT_META_M(SampleClassName,IsSingleton,SuperClassCount,SuperClassArray,animSampleClass)
#define IMPLEMENT_META_M_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_M_SIMPLE(SampleClassName,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_M_SIMPLE(SampleClassName,IsSingleton,SuperClassCount,SuperClassArray,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_M(SampleClassName,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_OBJECT(SampleClassName,SampleClassName,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_OBJECT_P(SampleClassName,SampleClassName,AOMPackage,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_M(SampleClassName,IsSingleton,SuperClassCount,SuperClassArray,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_P(SampleClassName,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#endif


// Objects
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)				\
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):								\
	AOMInstance((IOxfReactive*)0), \
	OMREGISTER_CLASS	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, IsSingleton, aompackage); 
#define IMPLEMENT_META_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)			\
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):								\
	AOMInstance((IOxfReactive*)0), \
	OMREGISTER_CLASS	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, IsSingleton, #AOMPackage); 
#else
#define IMPLEMENT_META_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_META_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)				\
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):									\
	AOMInstance((IOxfReactive*)userClassPtr), \
	OMREGISTER_CLASS	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, IsSingleton, aompackage); 
#define IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)				\
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):									\
	AOMInstance((IOxfReactive*)userClassPtr), \
	OMREGISTER_CLASS	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, IsSingleton, #AOMPackage); 
#else
#define IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif


#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)				\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)				\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_OBJECT(SampleClassName,SampleClassType,Package,IsSingleton,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_OBJECT_P(SampleClassName,SampleClassType,Package,AOMPackage,IsSingleton,AnimSampleClass)
#endif

// A single super class case
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_S_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, aompackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_AOMINSTANCE
#define IMPLEMENT_META_S_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, #AOMPackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_AOMINSTANCE
#else
#define IMPLEMENT_META_S_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_META_S_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT(SampleClassName, SampleClassType,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, aompackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT_P(SampleClassName, SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, #AOMPackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#else
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT(SampleClassName,SampleClassType,IsSingleton, SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_REACTIVE_META_S_SIMPLE_OBJECT_P(SampleClassName, SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_S_OBJECT(SampleClassName, SampleClassType,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, aompackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#define IMPLEMENT_REACTIVE_META_S_OBJECT_P(SampleClassName, SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)			\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, AnimSuperClass::staticGetClass(), IsSingleton, #AOMPackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#else
#define IMPLEMENT_REACTIVE_META_S_OBJECT(SampleClassName,SampleClassType,IsSingleton, SuperClass,animSuperClass,animSampleClass)
#define IMPLEMENT_REACTIVE_META_S_OBJECT_P(SampleClassName, SampleClassType,AOMPackage,IsSingleton,SuperClass,AnimSuperClass,AnimSampleClass)
#endif


// A multiple super class case
// Note the fourth (array) variable has to be instrumented separately
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_M_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)		\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, SuperClassCount, SuperClassArray, IsSingleton, aompackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr): OMINIT_AOMINSTANCE	
#define IMPLEMENT_META_M_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)		\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, SuperClassCount, SuperClassArray, IsSingleton, #AOMPackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr): OMINIT_AOMINSTANCE	
#else
#define IMPLEMENT_META_M_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassCount, SuperClassArray,animSampleClass)
#define IMPLEMENT_META_M_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray, SuperClassCount,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)		\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, SuperClassCount, SuperClassArray, IsSingleton, aompackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)		\
	AOMClass NAMESPACE_PREFIX AnimSampleClass::_myAOMClass(#SampleClassName, SuperClassCount, SuperClassArray, IsSingleton, #AOMPackage); \
    NAMESPACE_PREFIX AnimSampleClass::AnimSampleClass(SampleClassType* userClassPtr):OMINIT_REACTIVE_AOMINSTANCE
#else
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassCount,SuperClassArray,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_REACTIVE_META_M_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)		\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)		\
	ROOTSTATE_SERIALIZE_STATES(SampleClassType,AnimSampleClass)	\
	IMPLEMENT_REACTIVE_META_M_SIMPLE_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#else
#define IMPLEMENT_REACTIVE_META_M_OBJECT(SampleClassName,SampleClassType,IsSingleton,SuperClassCount,SuperClassArray,AnimSampleClass)
#define IMPLEMENT_REACTIVE_META_M_OBJECT_P(SampleClassName,SampleClassType,AOMPackage,IsSingleton,SuperClassArray,SuperClassCount,AnimSampleClass)
#endif

// Templates
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_T(tname,Package,IsSingleton,animTname)						\
	static AOMClass ClassOf##tname (#tname, false, aompackage);		\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#define IMPLEMENT_META_T_P(tname,Package,AOMPackage,IsSingleton,animTname)				\
	static AOMClass ClassOf##tname (#tname, false, #AOMPackage);		\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#else
#define IMPLEMENT_META_T(tname,Package,IsSingleton,animTname)
#define IMPLEMENT_META_T_P(tname,Package,AOMPackage,IsSingleton,animTname)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_S_T(tname,IsSingleton,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, animSuperClass::staticGetClass(), false, aompackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#define IMPLEMENT_META_S_T_P(tname,AOMPackage,IsSingleton,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, animSuperClass::staticGetClass(), false, #AOMPackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#else
#define IMPLEMENT_META_S_T(tname,IsSingleton,SuperClass,animSuperClass,animTname)
#define IMPLEMENT_META_S_T_P(tname,AOMPackage,IsSingleton,SuperClass,animSuperClass,animTname)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_M_T(tname, IsSingleton, SuperClassArray, SuperClassCount,animTname)		\
	static AOMClass ClassOf##tname (#tname, SuperClassCount, SuperClassArray, false, aompackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }								
#define IMPLEMENT_META_M_T_P(tname, AOMPackage, IsSingleton, SuperClassArray, SuperClassCount,animTname)		\
	static AOMClass ClassOf##tname (#tname, SuperClassCount, SuperClassArray, false, #AOMPackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }								
#else
#define IMPLEMENT_META_M_T(tname, IsSingleton, SuperClassArray, SuperClassCount,animTname)
#define IMPLEMENT_META_M_T_P(tname, AOMPackage, IsSingleton, SuperClassArray, SuperClassCount,animTname)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_T_S_T(tname,IsSingleton,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, getAOMClassOf##SuperClass(), false, aompackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#define IMPLEMENT_META_T_S_T_P(tname,AOMPackage,IsSingleton,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, getAOMClassOf##SuperClass(), false, #AOMPackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#else
#define IMPLEMENT_META_T_S_T(tname,IsSingleton,SuperClass,animSuperClass,animTname)
#define IMPLEMENT_META_T_S_T_P(tname,AOMPackage,IsSingleton,SuperClass,animSuperClass,animTname)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_T_S_T_N(tname,IsSingleton,NameSpace,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, NameSpace::getAOMClassOf##SuperClass(), false, aompackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#define IMPLEMENT_META_T_S_T_N_P(tname,AOMPackage,IsSingleton,NameSpace,SuperClass,animSuperClass,animTname)											\
	static AOMClass ClassOf##tname (#tname, NameSpace::getAOMClassOf##SuperClass(), false, #AOMPackage);	\
	AOMClass* NAMESPACE_PREFIX getAOMClassOf##tname () { return &ClassOf##tname ; }
#else
#define IMPLEMENT_META_T_S_T_N(tname,IsSingleton,NameSpace,SuperClass,animSuperClass,animTname)
#define IMPLEMENT_META_T_S_T_N_P(tname,AOMPackage,IsSingleton,NameSpace,SuperClass,animSuperClass,animTname)
#endif


//
//	Instrumentation Macros for method calls operations etc.
//

//  1. Macros for method calls
//	NOTIFY_OPERATION / NOTIFY_CONSTRUCTOR / NOTIFY_DESTRUCTOR
// Note: Here and elsewhere - the Signature includes the name of the method

// 1.1 Macro for "regular" methods call
//		a. Notify Call stack a new method is on the way.
//		(Needed to correctly recognize termination of constructors inheritance)
//		b. Create a method Message - this is a name + serialization of 
//		parameters if withParameters() or otherwise just the signature.
//		c. Create an EnterExitItem which pushed (and later pops) the method
//		from the call stack.
#ifdef _OMINSTRUMENT
#define _NOTIFY_OPERATION(rawCalled, name, signature, pcount, SERIALIZED_PARAMS)	\
  const AOMAnimationItem* called = 0;								\
	if (aomIsValidItem(rawCalled)) { called = (AOMAnimationItem*)rawCalled; }		\
	OMGetCurrentCallStack()->notify(called, omMethodMethod );			\
	AOMSMethod *aomsmethod;												\
	if (withCallStackParameters(called)) {								\
		aomsmethod = new AOMSMethod(#name,pcount);						\
		SERIALIZED_PARAMS												\
	} else																\
		aomsmethod = new AOMSMethod(#signature);						\
	AOMEnterExit aomEnterExit(called, aomsmethod, omMethodMethod );
#endif

#ifdef _OMINSTRUMENT

#define NOTIFY_OPERATION(name, signature, pCount, SERIALIZED_PARAMS)		\
	AOMSMethod *aomsmethod;												\
	bool withArgs;														\
	AOMAnimationItem* calledItem =										\
	AOMNotifyUtils::NotifyOperationHelper(this, aomsmethod, #name,#signature, withArgs, pCount); \
	if (withArgs) {SERIALIZED_PARAMS}				\
	AOMEnterExit aomEnterExit(calledItem, aomsmethod, omMethodMethod );

#else
#define NOTIFY_OPERATION(name, signature, pcount, SERIALIZED_PARAMS)
#endif

// 1.1.1 Macro for triggered operation calls
//		a. Notify Call stack a new method is on the way.
//		(Needed to correctly recognize termination of constructors inheritance)
//		b. Create a method Message - this is a name + serialization of 
//		parameters if withParameters() or otherwise just the signature.
//		c. Create an EnterExitItem which pushed (and later pops) the method
//		from the call stack.
#ifdef _OMINSTRUMENT
#define NOTIFY_TRIGGERED_OPERATION(name, signature, pcount, SERIALIZED_PARAMS)	\
	OMGetCurrentCallStack()->notify(AOMSchedDispatcher::instance()->getAOMInstance(this), omTriggerMethod );	\
	AOMSMethod *aomsmethod;												\
	if (withCallStackParameters(AOMSchedDispatcher::instance()->getAOMInstance(this))) {								\
		aomsmethod = new AOMSMethod(#name,pcount);						\
		SERIALIZED_PARAMS												\
	} else																\
		aomsmethod = new AOMSMethod(#signature);						\
	AOMEnterExit aomEnterExit(AOMSchedDispatcher::instance()->getAOMInstance(this), aomsmethod, omTriggerMethod );
#else
#define NOTIFY_TRIGGERED_OPERATION(name, signature, pcount, SERIALIZED_PARAMS)
#endif

// 1.2 Macro for "constructor" methods call
//		Same as a "regular" method call accept that the item is in creation
//		so instead of "withCallStackParameters()" we use "getClass()->withCallStackParameters()
//		Note that this works correctly for inheritance as any constructor call
//		will be reported/ignored according to the correct sub-class of the item.
#define OM_NO_OP ;

#define NO_OP()

#define NOTIFY_CONSTRUCTOR_BODY(name, signature, pcount, SERIALIZED_PARAMS)				\
	(void) AOMThread::getDefaultThread(0);												\
	AOMInstance* theAOMInstPtr = AOMSchedDispatcher::instance()->getAOMInstance(this);	\
	AOMSMethod* aomsmethod = 0;														\
	if (theAOMInstPtr != NULL) {														\
		OMGetCurrentCallStack()->notify(theAOMInstPtr, omConstructorMethod );			\
		if (withCallStackParameters(theAOMInstPtr->getClass())) {						\
			aomsmethod = new AOMSMethod(#name,pcount);									\
			SERIALIZED_PARAMS															\
		}																				\
		else {																			\
			aomsmethod = new AOMSMethod(#signature);									\
		}																				\
	}	\
	AOMEnterExit aomEnterExit(theAOMInstPtr, aomsmethod, omConstructorMethod );	

#ifdef _OMINSTRUMENT
#define NOTIFY_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)	\
	NOTIFY_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, name)
#else
#define NOTIFY_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)
#endif

// Object
#ifdef _OMINSTRUMENT
#define NOTIFY_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)	\
		OMAnimated##classType* aom_tmpVar = new OMAnimated##classType(this); \
		aom_tmpVar->dummyToAvoidUnusedVarWarning(); \
		NOTIFY_CONSTRUCTOR_BODY(name, signature, pcount, SERIALIZED_PARAMS;)
#else
#define NOTIFY_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)
#endif

// Template
#ifdef _OMINSTRUMENT
#define NOTIFY_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)	\
		ttype* aom_tmpVar = new ttype(this); \
		aom_tmpVar->dummyToAvoidUnusedVarWarning(); \
		NOTIFY_CONSTRUCTOR_BODY(name, signature, pcount, SERIALIZED_PARAMS;)
#else
#define NOTIFY_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)
#endif


// 1.2.1 Macro for "active constructor" methods call
// Same as above except that we use the opportunity to introduce
// "this" to the AOMThread

#ifdef _OMINSTRUMENT
#define NOTIFY_ACTIVE_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)	\
	NOTIFY_ACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, name)
#else
#define NOTIFY_ACTIVE_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)
#endif

// Object
#ifdef _OMINSTRUMENT
#define NOTIFY_ACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)	\
	NOTIFY_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)	\
	AnimServices::setThreadContext(this, AOMSchedDispatcher::instance()->getAOMInstance(this));						
#else
#define NOTIFY_ACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)
#endif

// Template
#ifdef _OMINSTRUMENT
#define NOTIFY_ACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)	\
	NOTIFY_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)	\
	AnimServices::setThreadContext(this, AOMSchedDispatcher::instance()->getAOMInstance(this));						
#else
#define NOTIFY_ACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)
#endif

// Support for Active not Reactive
#define NOTIFY_ACTIVE_NOT_REACTIVE_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)	\
	NOTIFY_ACTIVE_NOT_REACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, name)

// Object
#define NOTIFY_ACTIVE_NOT_REACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)	\
	NOTIFY_ACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)

// Template
#define NOTIFY_ACTIVE_NOT_REACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS, ttype)	\
	NOTIFY_ACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS, ttype)

#ifdef _OMINSTRUMENT
#define NOTIFY_REACTIVE_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)	\
	NOTIFY_REACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, name)
#else
#define NOTIFY_REACTIVE_CONSTRUCTOR(name, signature, pcount, SERIALIZED_PARAMS)
#endif

// Object
#ifdef _OMINSTRUMENT
#define NOTIFY_REACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)	\
	NOTIFY_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)
#else
#define NOTIFY_REACTIVE_CONSTRUCTOR_OBJECT(name, signature, pcount, SERIALIZED_PARAMS, classType)
#endif

// Template
#ifdef _OMINSTRUMENT
#define NOTIFY_REACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS,ttype)	\
	NOTIFY_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS ,ttype)
#else
#define NOTIFY_REACTIVE_CONSTRUCTOR_T(name, signature, pcount, SERIALIZED_PARAMS, ttype)
#endif



// 1.3 Macro for "destructor" methods call
//		Same as a "regular" method call accept that destructors never have
//		parameters so we create the signature here and never serialize params.
//		NOTE: the /**/ replace the ## as a concatenation operator for
//			  compatibility with different preproceccors

#ifdef _OMINSTRUMENT
#ifndef DIAB_DTOR_BUG
#define NOTIFY_DESTRUCTOR_BODY(name,destroyAOMInstance) \
		AOMInstance* myAomInstance = AOMSchedDispatcher::instance()->getAOMInstance(this);	\
		OMGetCurrentCallStack()->notify(myAomInstance, omDestructorMethod );				\
		AOMSMethod *aomsmethod = new AOMSMethod(#name/**/"()");								\
		AOMEnterExit aomEnterExit(myAomInstance, aomsmethod, omDestructorMethod ,destroyAOMInstance,(void *)this);	\
		OMGetCurrentCallStack()->registerInstanceForDeletion(myAomInstance);				\

#else
#define NOTIFY_DESTRUCTOR_BODY(name,destroyAOMInstance) \
		AOMInstance* myAomInstance = AOMSchedDispatcher::instance()->getAOMInstance(this);	\
		AOMCallStack *cs = OMGetCurrentCallStack();											\
		AOMAnimationItem * caller = cs->top();												\
		cs->notify(myAomInstance, omDestructorMethod );										\
		AOMSMethod *aomsmethod = new AOMSMethod(#name/**/"()");								\
		AOMEnterExit aomEnterExit(myAomInstance, aomsmethod, omDestructorMethod ,destroyAOMInstance,(void *)this);	\
		if (myAomInstance != 0)																\
		{																					\
			myAomInstance->deregisterFromClass(caller);										\
			cs->registerInstanceForDeletion(myAomInstance);									\
		}

#endif // DIAB_DTOR_BUG

// This flag is defined in Linux\omosconfig.h to avoid hanging some applications
// while OMOS::endApplication execution
#ifdef NO_NOTIFY_DESTRUCTOR_IN_END_APPLICATION 
#define NOTIFY_DESTRUCTOR(name,destroyAOMInstance)		\
	if (!AnimServices::isApplicationEnding())			\
	{													\
	    NOTIFY_DESTRUCTOR_BODY(name,destroyAOMInstance) \
	} 
#else
#define NOTIFY_DESTRUCTOR(name,destroyAOMInstance)	\
		NOTIFY_DESTRUCTOR_BODY(name,destroyAOMInstance)
#endif // NO_NOTIFY_DESTRUCTOR_IN_END_APPLICATION

#else // _OMINSTRUMENT
#define NOTIFY_DESTRUCTOR(name,destroyAOMInstance)
#endif // _OMINSTRUMENT

// 1.5 Macro for "static" methods call
//		The difference here is that the "class" is the invoked instance
//		as we do not have a "this" parameter
#ifdef _OMINSTRUMENT
#define NOTIFY_STATIC_OPERATION(sampleClass,name, signature, pcount, SERIALIZED_PARAMS)	\
_NOTIFY_OPERATION(OMAnimated##sampleClass::staticGetClass(), name, signature, pcount, SERIALIZED_PARAMS)
#else
#define NOTIFY_STATIC_OPERATION(sampleClass,name, signature, pcount, SERIALIZED_PARAMS)
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_STATIC_OPERATION_T(sampleClass,name, signature, pcount, SERIALIZED_PARAMS)	\
_NOTIFY_OPERATION(sampleClass::staticGetClass(), name, signature, pcount, SERIALIZED_PARAMS)
#else
#define NOTIFY_STATIC_OPERATION_T(sampleClass,name, signature, pcount, SERIALIZED_PARAMS)
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_FUNCTION(package, name, signature, pcount, SERIALIZED_PARAMS)	\
	_NOTIFY_OPERATION(&aom##package##Global, name, signature, pcount, SERIALIZED_PARAMS)
#else
#define NOTIFY_FUNCTION(package, name, signature, pcount, SERIALIZED_PARAMS)
#endif
//
//	 Macros used in the instrumentation of events
//
#ifdef _OMINSTRUMENT
#define DECLARE_META_EVENT(E)	\
  protected:										\
	E *myEvent;	\
	static AOMEventClass _myAOMClass;				\
	static AOMEvent * unserialize(OMSData&);		\
	static AOMEventClass * staticGetClass();		\
public :	\
    OMAnimated##E (E* userEventPtr): AOMEvent((IOxfEvent*)userEventPtr),myEvent(userEventPtr) {	\
	AOMSchedDispatcher::instance()->registerAOMEvent(myEvent,  (AOMEvent*)this);}	\
	virtual ~OMAnimated##E(){} \
	inline void dummyToAvoidUnusedVarWarning(){} \
  AOMEventClass * getEventClass() const;			\
    void  serialize(AOMSEvent*  aomsEvent)const;	\
  private:	
#else
#define DECLARE_META_EVENT(E)
#endif

#ifdef _OMINSTRUMENT
#define DECLARE_META_SUBEVENT(E,SuperE,SuperNamespace)	\
  protected:										\
	E *myEvent;	\
	static AOMEventClass _myAOMClass;				\
	static AOMEvent * unserialize(OMSData&);		\
	static AOMEventClass * staticGetClass();		\
  public:											\
    OMAnimated##E (E* userEventPtr): AOMEvent((IOxfEvent*)userEventPtr), SuperNamespace OMAnimated##SuperE ((SuperNamespace SuperE*)userEventPtr),myEvent(userEventPtr) {	\
		AOMSchedDispatcher::instance()->registerAOMEvent(myEvent,  (AOMEvent*)this);}	\
	virtual ~OMAnimated##E(){} \
	AOMEventClass * getEventClass() const;			\
    void  serialize(AOMSEvent*  aomsEvent)const;	\
  private:
#else
#define DECLARE_META_SUBEVENT(E,SuperE,SuperNamespace)
#endif

//
//	Macros for the instrumentation of the meta events
//

// The case where superClass is a pointer (used only by other macros)
// #define IMPLEMENT_META_EVENT(Event,
//								Signature,
//								My_Super_Class)
#define IMPLEMENT_META_EVENT_(E, Sig, SupP)													\
	AOMEventClass NAMESPACE_PREFIX OMAnimated##E ::_myAOMClass(#E, #Sig, & NAMESPACE_PREFIX OMAnimated##E ::unserialize, aompackage, AOMSchedDispatcher::instance()->getAOMEvent(SupP));	\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::getEventClass() const { return &_myAOMClass; }	\
	void NAMESPACE_PREFIX OMAnimated##E ::serialize(AOMSEvent*  aomsEvent)const {	E##_SERIALIZE;}		\
	AOMEvent* NAMESPACE_PREFIX OMAnimated##E ::unserialize(OMSData &l) {								\
		OMSPosition omPosition = l.getFirst();												\
		E##_UNSERIALIZE;																	\
		if (l.isEmpty(omPosition)) { IOxfEvent *aom_tmpVar = new E##_CONSTRUCTOR; return AOMSchedDispatcher::instance()->getAOMEvent(aom_tmpVar);}							\
		else {sendError("Too many parameters for event"); return 0;} 					\
	}																						\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::staticGetClass() {return &_myAOMClass;}
#define IMPLEMENT_META_EVENT_P_(E, AOMPackage, Sig, SupP)													\
	AOMEventClass NAMESPACE_PREFIX OMAnimated##E ::_myAOMClass(#E, #Sig, & NAMESPACE_PREFIX OMAnimated##E ::unserialize, #AOMPackage, AOMSchedDispatcher::instance()->getAOMEvent(SupP));	\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::getEventClass() const { return &_myAOMClass; }	\
	void NAMESPACE_PREFIX OMAnimated##E ::serialize(AOMSEvent*  aomsEvent)const {	E##_SERIALIZE;}		\
	AOMEvent* NAMESPACE_PREFIX OMAnimated##E ::unserialize(OMSData &l) {								\
		OMSPosition omPosition = l.getFirst();												\
		E##_UNSERIALIZE;																	\
		if (l.isEmpty(omPosition)) { IOxfEvent *aom_tmpVar = new E##_CONSTRUCTOR; return AOMSchedDispatcher::instance()->getAOMEvent(aom_tmpVar);}							\
		else {sendError("Too many parameters for event"); return 0;} 					\
	}																						\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::staticGetClass() {return &_myAOMClass;}

#define IMPLEMENT_META_EVENT_NOUNSER_(E, Sig, SupP)													\
	AOMEventClass NAMESPACE_PREFIX OMAnimated##E ::_myAOMClass(#E, #Sig, & NAMESPACE_PREFIX OMAnimated##E ::unserialize, aompackage, AOMSchedDispatcher::instance()->getAOMEvent(SupP));	\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::getEventClass() const { return &_myAOMClass; }	\
	void NAMESPACE_PREFIX OMAnimated##E ::serialize(AOMSEvent*  aomsEvent)const {	E##_SERIALIZE;}	\
	AOMEvent* NAMESPACE_PREFIX OMAnimated##E ::unserialize(OMSData &l) {							\
	char msg[512];																					\
		strcpy(msg, "Cannot generate ");														\
		(void)strcat(msg,#E);																		\
		(void)strcat(msg," event because it has uninstrumented argument(s)");								\
		sendError(msg);																				\
		return 0;																				\
	}																								\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::staticGetClass() {return &_myAOMClass;}
#define IMPLEMENT_META_EVENT_NOUNSER_P_(E, AOMPackage, Sig, SupP)												\
	AOMEventClass NAMESPACE_PREFIX OMAnimated##E ::_myAOMClass(#E, #Sig, & NAMESPACE_PREFIX OMAnimated##E ::unserialize, #AOMPackage, AOMSchedDispatcher::instance()->getAOMEvent(SupP));	\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::getEventClass() const { return &_myAOMClass; }	\
	void NAMESPACE_PREFIX OMAnimated##E ::serialize(AOMSEvent*  aomsEvent)const {	E##_SERIALIZE;}	\
	AOMEvent* NAMESPACE_PREFIX OMAnimated##E ::unserialize(OMSData &l) {							\
	char msg[512];																					\
		strcpy(msg, "Cannot generate ");														\
		(void)strcat(msg,#E);																		\
		(void)strcat(msg," event because it has uninstrumented argument(s)");								\
		sendError(msg);																				\
		return 0;																				\
	}																								\
	AOMEventClass * NAMESPACE_PREFIX OMAnimated##E ::staticGetClass() {return &_myAOMClass;}

#define UNKNOWN2STRING(p) x2String((void*)&(p),"U")
#define UNKNOWN_ARRAY2STRING(l,p,s,f) x2String((void*)(p),"U")

// The super event class case (note we never have multiple inheritance)
// #define IMPLEMENT_META_EVENT(Event, Signature, My_Super_Class)
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_EVENT_S(E, Sig, Sup)	\
	static Sup  _tmp##E##_Sup;								\
	IMPLEMENT_META_EVENT_(E, Sig,  &_tmp##E##_Sup)	
#define IMPLEMENT_META_EVENT_S_P(E, AOMPackage, Sig, Sup)	\
	static Sup  _tmp##E##_Sup;								\
	IMPLEMENT_META_EVENT_P_(E, AOMPackage, Sig,  &_tmp##E##_Sup)	
#else
#define IMPLEMENT_META_EVENT_S(E, Sig, Sup)
#define IMPLEMENT_META_EVENT_S_P(E, AOMPackage, Sig, Sup)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_S(E, Sig, Sup)	\
	static Sup  _tmp##E##_Sup;								\
	IMPLEMENT_META_EVENT_NOUNSER_(E, Sig,  &_tmp##E##_Sup)	
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_S_P(E, AOMPackage, Sig, Sup)	\
	static Sup  _tmp##E##_Sup;								\
	IMPLEMENT_META_EVENT_NOUNSER_P_(E, AOMPackage, Sig,  &_tmp##E##_Sup)	
#else
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_S(E, Sig, Sup)
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_S_P(E, AOMPackage, Sig, Sup)
#endif

// The no super event class case
//#define IMPLEMENT_META_EVENT(Event, Signature)
#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_EVENT(E, Package, Sig)	\
	IMPLEMENT_META_EVENT_(E, Sig, 0)
#define IMPLEMENT_META_EVENT_P(E, Package, AOMPackage, Sig)	\
	IMPLEMENT_META_EVENT_P_(E, AOMPackage, Sig, 0)
#else
#define IMPLEMENT_META_EVENT(E, Package, Sig)
#define IMPLEMENT_META_EVENT_P(E, Package, AOMPackage, Sig)
#endif

#ifdef _OMINSTRUMENT
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE(E, Package, Sig)	\
	IMPLEMENT_META_EVENT_NOUNSER_(E, Sig, 0)
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_P(E, Package, AOMPackage, Sig)	\
	IMPLEMENT_META_EVENT_NOUNSER_P_(E, AOMPackage, Sig, 0)
#else
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE(E, Package, Sig)
#define IMPLEMENT_META_EVENT_NO_UNSERIALIZE_P(E, Package, AOMPackage, Sig)
#endif


//
//	0. Macros for serialize
//
#ifdef _OMINSTRUMENT
#define DECLARE_SERIALIZE											 \
    void  serializeAttributes(AOMSAttributes*  aomsAttributes)const; \
    void  serializeRelations(AOMSRelations*  aomsRelations)const;
#else
#define DECLARE_SERIALIZE
#endif


//
//	1. Macros for relations
//
#ifdef _OMINSTRUMENT
#define NOTIFY_RELATION_ITEM_ADDED(relation, item, isComposite, isSingleton)	\
	{ \
		AOMInstance *theAOMInstPtr = AOMSchedDispatcher::instance()->getAOMInstance(this); \
		if (theAOMInstPtr != 0)	{ \
			if (item==0)																\
				theAOMInstPtr->notifyClearRelation(relation);											\
			else if (aomIsValidItem(AOMSchedDispatcher::instance()->getAOMInstance(item)))												\
				theAOMInstPtr->notifyItemAddedToRelation(relation, AOMSchedDispatcher::instance()->getAOMInstance(item), isComposite, isSingleton);	\
			else														\
				theAOMInstPtr->notifyItemAddedToRelation(relation, (AOMInstance*)OMGarbage, isComposite, isSingleton);	\
		}	\
	}
#else
#define NOTIFY_RELATION_ITEM_ADDED(relation, item, isComposite, isSingleton)
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_RELATION_ITEM_REMOVED(relation, removedItem)		\
	if (AOMSchedDispatcher::instance()->getAOMInstance(this)!=0)	{						\
		if (aomIsValidItem(AOMSchedDispatcher::instance()->getAOMInstance(removedItem)))				\
			AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyItemRemovedFromRelation(relation, AOMSchedDispatcher::instance()->getAOMInstance(removedItem));	\
		else														\
			AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyItemRemovedFromRelation(relation, (AOMInstance*)OMGarbage);	\
	}
#else
#define NOTIFY_RELATION_ITEM_REMOVED(relation, removedItem) 
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_RELATION_CLEARED(relation)	\
	if (AOMSchedDispatcher::instance()->getAOMInstance(this)) \
		AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyClearRelation(relation);
#else
#define NOTIFY_RELATION_CLEARED(relation)
#endif

//
//	2. Macros for states
//

#define	AOM_CONCEPT AOMSchedDispatcher::instance()->getAOMInstance(concept)

#ifdef _OMINSTRUMENT
#define	NOTIFY_EVENT_CONSTRUCTOR(E) \
		OMAnimated##E* aom_tmpVar = new OMAnimated##E(this); \
		aom_tmpVar->dummyToAvoidUnusedVarWarning(); 
#else
#define	NOTIFY_EVENT_CONSTRUCTOR(E)
#endif

#ifdef _OMINSTRUMENT
#define	GET_CONCEPT AOMInstance * getConcept() const { return AOM_CONCEPT; }
#else
#define	GET_CONCEPT
#endif


#ifdef _OMINSTRUMENT
#define	NOTIFY_TERMINATION(theConnector)	\
if (AOMSchedDispatcher::instance()->getAOMInstance(this)) \
	AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyTermination((OMHandle*)(theConnector));
#else
#define	NOTIFY_TERMINATION(theConnector)
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_TRANSITION_STARTED(transition)	\
if (AOMSchedDispatcher::instance()->getAOMInstance(this)) \
	AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyStartedTransition(transition)
#else
#define NOTIFY_TRANSITION_STARTED(transition)
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_TRANSITION_TERMINATED(transition)	\
	if (AOMSchedDispatcher::instance()->getAOMInstance(this)) \
	AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyEndedTransition(transition)
#else
#define NOTIFY_TRANSITION_TERMINATED(transition)
#endif

// Macros for states
#ifdef _OMINSTRUMENT
#ifndef OM_REUSABLE_STATECHART_IMPLEMENTATION
#define	NOTIFY_STATE_ENTERED(stateHandle)	\
	if (stateHandle && AOMSchedDispatcher::instance()->getAOMInstance(this)) \
	AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyEnterToState(stateHandle)
#else
#define	NOTIFY_STATE_ENTERED(stateHandle)	\
	if (stateHandle && getConcept()) getConcept()->notifyEnterToState(stateHandle)
#endif
#else
#define	NOTIFY_STATE_ENTERED(stateHandle)
#endif

#ifdef _OMINSTRUMENT
#ifndef OM_REUSABLE_STATECHART_IMPLEMENTATION
#define	NOTIFY_STATE_EXITED(stateHandle)	\
	if (stateHandle && AOMSchedDispatcher::instance()->getAOMInstance(this)) \
	AOMSchedDispatcher::instance()->getAOMInstance(this)->notifyExitFromState(stateHandle)
#else
#define	NOTIFY_STATE_EXITED(stateHandle)	\
	if (stateHandle && getConcept()) getConcept()->notifyExitFromState(stateHandle)
#endif
#else
#define	NOTIFY_STATE_EXITED(stateHandle)
#endif

//
//	Macros for external lockers
//
#ifdef _OMINSTRUMENT
#define NOTIFY_LOCKING_THREAD	{				 \
	AOMStepper* s = OMPassiveGetCurrentStepper(); \
	if (s!=0) s->notifyLock(true);			 \
}
#else
#define NOTIFY_LOCKING_THREAD
#endif

#ifdef _OMINSTRUMENT
#define NOTIFY_UNLOCKING_THREAD	{				 \
	AOMStepper* s = OMPassiveGetCurrentStepper(); \
	if (s!=0) s->notifyLock(false);			 \
}
#else
#define NOTIFY_UNLOCKING_THREAD
#endif

//
//	Macros for serialize/unserialize parameters
//	Note - the whole serialize/unserialize is wraped by 
//	"ifdef _INSTRUMENT" so we don't wrap the specific macros
//
#define OMADD_SER(p, cvrtFunc) aomsEvent->addAttribute(#p, cvrtFunc);
#define OMADD_OMSER(p) aomsEvent->addAttribute(#p, X2ITEM(myEvent->p));

#define OMBAD_PARAM(p) { sendError("Bad Parameter "#p); return 0; }
#define BAD_MISSING_PARAM(p) \
	{ sendError("Missing or inValid Parameter "#p); return 0; }

#define _OMADD_OMUNSER(t,p,unserializeFunc)										\
	if (l.isPointer(omPosition)) {								\
		AOMInstance * aomP = (AOMInstance *)l.getPointer(omPosition); \
		p = (t)aomP->getMyReal();								\
	} else if (l.isString(omPosition)) {						\
		OMTRY { char *omstr = l.getChar(omPosition);				\
		int i; i = unserializeFunc(omstr,i); p = (t)i;		\
		} OMCATCH_ALL OMBAD_PARAM(p)								\
	} else BAD_MISSING_PARAM(p)


#define _OMADD_UNSER(t,p,unserializeFunc)										\
	if (l.isString(omPosition)) {								\
		OMTRY {													\
			char *omstr = l.getChar(omPosition);				\
			p = unserializeFunc(omstr,p);					\
		} OMCATCH_ALL OMBAD_PARAM(p)								\
	} else BAD_MISSING_PARAM(p)

#define OMADD_OMUNSER(t,p,unserializeFunc)	t p; _OMADD_OMUNSER(t,p,unserializeFunc)
#define OMADD_UNSER(t,p,unserializeFunc)	t p; _OMADD_UNSER(t,p,unserializeFunc)

#define OMADD_OPTIONAL_UNSER(t,p,creationFunction,unserializeFunc)	t p;	\
	if (l.isEmpty(omPosition)) return new creationFunction;	\
	else { _OMADD_UNSER(t,p,unserializeFunc); }
#define OMADD_OPTIONAL_OMUNSER(t,p,creationFunction,unserializeFunc) t p;	\
	if (l.isEmpty(omPosition)) return new creationFunction;	\
	else { _OMADD_OMUNSER(t,p,unserializeFunc); }


//
//	Macros for the definition of states
//
#ifdef _OMINSTRUMENT
#define DECLARE_GET_CONCEPT \
    AOMInstance *  getConcept()const { return AOM_CONCEPT; }
#else
#define DECLARE_GET_CONCEPT
#endif

#ifdef _OMINSTRUMENT
#define OM_SET_INSTANCE_NAME(instance, className, instanceName, index) \
	AOMInstance::setAOMInstanceName((AOMInstance*)(X2ITEM(instance)), (char*)(instanceName), index)
#else
#define OM_SET_INSTANCE_NAME(instance, className, instanceName, index) 
#endif

//
// Macros for operation calls (CALL command)
//
#ifdef _OMINSTRUMENT


// Include and forward declaration for AOMOperation

#include <aom/aomoperation.h> 
#include <omcom/AnimStringOrPointerField.h>
#include <omcom/AnimListField.h>


// Helper macros and constants

// The following two #define were commented due to a Sun (Workshop 6 update 1) compiler bug
// The substitution with ## does not worl correctly
// Once this is sorted out - please refer to version 1.116 of this file (aommacro.h) in the sandbox

//#define OP_CLASS_PREFIX OMAnim_   
//#define OP_INSTANCE_PREFIX Anim_  

#define OP_CLASS_NAME(mangledName)  OMAnim_##mangledName
#define OP_INSTANCE_NAME(mangledName) Anim_##mangledName

#define ARGS_DECLARATION_MACRO_CALL(mangledName) OMAnim_##mangledName##_ARGS_DECLARATION 

#define ARGS_DESERIALIZATION_MACRO_CALL(mangledName) OMAnim_##mangledName##_UNSERIALIZE_ARGS

#define RET_VAL_SERIALIZATION_MACRO_CALL(mangledName) OMAnim_##mangledName##_SERIALIZE_RET_VAL

// header file macros

#define DECLARE_OPERATION_CLASS(mangledName) \
class OP_CLASS_NAME(mangledName) : public AOMOperation \
{ \
	ARGS_DECLARATION_MACRO_CALL(mangledName) \
public: \
	OP_CLASS_NAME(mangledName)(OMString name, bool isStatic, OMString signature, int numOfArgs, AOMClass *theClass) : \
	AOMOperation(name, isStatic, signature, numOfArgs, theClass) {} \
	void unserializeArguments(AnimListField *argValues); \
	AnimStringOrPointerField invoke(AOMInstance *instance); \
};

#define DECLARE_META_OP(mangledName) \
static OP_CLASS_NAME(mangledName) OP_INSTANCE_NAME(mangledName);


// cpp file macros

#define OM_OP_UNSER(type, name) \
{ \
AOMInstance *theAomInstance = (AOMInstance *)getNextPtr(argValues); \
if (aomIsValidItem(theAomInstance)) \
  name=(type)(theAomInstance->getMyReal()); \
else \
  name=0; \
}


#define OP_UNSER(func,name) \
name=func(getNextStr(argValues), name);

#define OP_SET_RET_VAL(retVal) \
retAnimField.setStringValue(x2String(retVal));

#define OM_OP_SET_RET_VAL(retVal) \
retAnimField.setPointerValue(AOMSchedDispatcher::instance()->getAOMInstance(retVal));


// instantiation of static op class objects for registration
#define IMPLEMENT_META_OP(animatedClassName, mangledName, opNameStr, isStatic, signarureStr, numOfArgs) \
OP_CLASS_NAME(mangledName) animatedClassName :: OP_INSTANCE_NAME(mangledName)(opNameStr, isStatic, signarureStr, numOfArgs, &_myAOMClass);

#define IMPLEMENT_OP_CALL(mangledName, userClassName, call, retExp) \
void OP_CLASS_NAME(mangledName) :: unserializeArguments(AnimListField *argValues) { \
	if (prepareListForDeserialization(argValues)) { \
		ARGS_DESERIALIZATION_MACRO_CALL(mangledName) \
	} \
} \
AnimStringOrPointerField OP_CLASS_NAME(mangledName) :: invoke(AOMInstance *theInstance) { \
	AnimStringOrPointerField retAnimField; \
	retAnimField.setStringValue((void*)""); \
	userClassName * realInst = ( userClassName * ) (theInstance->getMyReal()); \
	if (realInst) { \
		retExp realInst->call ;	\
		RET_VAL_SERIALIZATION_MACRO_CALL(mangledName) \
	} \
	return retAnimField; \
}

#define STATIC_IMPLEMENT_OP_CALL(mangledName, userClassName, call, retExp) \
void OP_CLASS_NAME(mangledName) :: unserializeArguments(AnimListField *argValues) { \
	if (prepareListForDeserialization(argValues)) { \
		ARGS_DESERIALIZATION_MACRO_CALL(mangledName) \
	} \
} \
AnimStringOrPointerField OP_CLASS_NAME(mangledName) :: invoke(AOMInstance *theInstance) { \
	AnimStringOrPointerField retAnimField; \
	retAnimField.setStringValue((void*)""); \
	retExp userClassName :: call ; \
	RET_VAL_SERIALIZATION_MACRO_CALL(mangledName) \
	return retAnimField; \
}


#else

#define OM_OP_UNSER(type, name)

#define OP_UNSER(name)

#define DECLARE_OPERATION_CLASS(mangledName)

#define DECLARE_META_OP(mangledName)

#define IMPLEMENT_META_OP(animatedClassName, mangledName, opNameStr, isStatic, signarureStr, numOfArgs) 

#define IMPLEMENT_OP_CALL(mangledName, userClassName, call) 

#define STATIC_IMPLEMENT_OP_CALL(mangledName, userClassName, call) 


#endif

//
// Macros for reporting return and output values
//

#define OM_SER_RET
#define OM_SER_OUT
#define OM_RET_TYPE


#ifdef _OMINSTRUMENT

// Include and forward declaration for AOMOperation
#include <omcom/AnimOpReturn.h>

#define OM_RETURN(expr) \
	{\
		OM_RET_TYPE val = expr;\
		AnimOpReturn* retMsg = new AnimOpReturn();\
		retMsg->setReturnValue(OM_SER_RET(val));\
		OM_SER_OUT\
		AOMSchedDispatcher::instance()->encodeAndSendMessage(retMsg);\
		return val;\
	}

#define OM_RETURN_VOID \
	{\
		AnimOpReturn* retMsg = new AnimOpReturn();\
		retMsg->setReturnValue("void"); \
		OM_SER_OUT\
		AOMSchedDispatcher::instance()->encodeAndSendMessage(retMsg);\
		return;\
	}
#else
#define OM_RETURN(expr) return(expr);
#define OM_RETURN_VOID 	return;
#endif

//
// $Log: aommacro.h $
// Revision 1.162  2007/04/17 12:11:44  ilshgo
// bugfix 102866, 102948, 102934 : added macros with _P that receive the package name to the "no super" group as well.
// Revision 1.161.1.3  2007/04/17 09:16:20  ilshgo
// PP2
// Revision 1.157  2007/03/11 11:57:52  ilgiga
// Change copyright comment
// Revision 1.156  2007/03/01 16:31:25  ilgiga
// Telelogic instead of i-Logix
// Revision 1.155  2006/07/13 13:06:27  vova
// 94620: too safe programming fixed
// Revision 1.154  2006/07/11 09:02:06  vova
// 93666: safe programing added in NOTIFY_CONSTRUCTOR_BODY macro.
// Revision 1.153  2006/03/20 12:04:38  vova
// 87575: OM_DECLARE_COMPOSITE_OFFSETmacro was moved to the rawtypes.h
// Revision 1.152  2005/12/12 09:50:59  ovol
// activate NotifyOperationHelper function
// Revision 1.151  2005/12/07 16:24:47  ovol
// add new macroes for operation notification using utils functions - with and without arguments.
// Not used yet.
// Revision 1.150  2005/12/01 12:15:11  vova
// 87575 rolled back, because it was not a bug
// Revision 1.148  2005/08/08 08:29:49  vova
// Wrong AOMInstance initialization fixed for ESTL
// Revision 1.147  2005/07/05 10:33:26  vova
// VxWorks gnu compiler warnings fixed: the order of base classes initialization.
// Revision 1.146  2005/06/06 15:34:29  amos
// Revision 1.145.1.2  2005/05/31 16:23:17  amos
// NOTIFY_DESTRUCTOR_BODY: add call to the call stack registerInstanceForDeletion()
// Revision 1.145.1.1  2005/05/19 12:28:28  amos
// Duplicate revision
// Revision 1.144  2005/05/01 14:27:25  amos
// bugfix 82347
// Revision 1.143.1.2  2005/05/01 14:27:02  amos
// Remove the definition of AOMInstance that was designed for partial animaiton support
// Revision 1.143.1.1  2005/04/21 10:03:24  amos
// Duplicate revision
// Revision 1.142.2.6  2005/04/18 09:17:53  amos
// Remove redundant macros
// Revision 1.142.2.5  2005/04/07 12:50:01  amos
// Revision 1.142.2.4  2005/04/04 13:48:46  amos
// Revision 1.142.2.3  2005/03/16 14:02:34  amos
// Revision 1.142.2.2  2005/03/09 12:22:35  amos
// Initial support in decoupling of AOM from the OXF core implementation
// Revision 1.142.2.1  2004/10/14 11:02:41  amos
// Duplicate revision
// Revision 1.141  2004/09/20 08:23:16  amos
// merge bugfix 75102 to 2004
// Revision 1.140  2004/09/08 13:02:40  amos
// 75108 to main branch
// Revision 1.139.1.2  2004/09/07 14:17:44  amos
// Rename the framework interfaces and types to ensure unique names as well as updating all references.
// - IActive changed to IOxfActive
// - IReactive changed to IOxfReactive
// - IEvent changed to IOxfEvent
// - ITimeout changed to IOxfTimeout
// - IEventGenerationParams changed to IOxfEventGenerationParams
// - TimeUnit changed to OxfTimeUnit
// Revision 1.139.1.1  2004/09/06 10:32:30  amos
// Duplicate revision
// Revision 1.138  2004/08/31 11:20:46  amos
// back to main branch
// Revision 1.137  2004/08/18 11:41:35  vova
// Some improvement was done in NOTIFY_DESTRUCTOR macro
// Revision 1.136  2004/08/18 08:21:14  vova
// NOTIFY_DESTRUCTOR modified for LINUX
// Revision 1.135.1.2  2004/08/18 08:20:27  vova
// NOTIFY_DESTRUCTOR for LINUX modified
// Revision 1.135.1.1  2004/08/17 13:52:36  vova
// Duplicate revision
// Revision 1.134  2004/06/27 15:42:59  amos
// move to model-based oxf in RiC++
// Revision 1.133.1.2.1.1  2004/08/29 13:26:38  sasha
// Add IMPLEMENT_META_T_S_T instrumentation macro for 
// inheritance of a template from another template
// Revision 1.133.1.2  2004/08/18 08:18:05  vova
// NOTIFY_DESTRUCTOR for non-DIAB compiler changed
// Revision 1.133.1.4  2004/09/20 07:40:22  amos
// bugfix 75102 to main r51m2 branch
// Revision 1.133.1.3.1.2  2004/09/20 07:03:23  amos
// Add definition of OM_DECLARE_COMPOSITE_OFFSET.
// The definition adds an offset data-member to composite class in order to avoid composite and part with the same address
// The definition is not wrapped by _OMINSTRUMENT to ensure that the user class will maintain the same size regardless of the compilation switches.
// Revision 1.133.1.3.1.1  2004/08/31 11:42:59  amos
// Revision 1.133.1.1  2004/08/17 13:50:59  vova
// 74625,72921: endApplication hanging : no need to notify about object destruction
// Revision 1.133  2004/05/19 07:59:33  vova
// 72070: template dummy function added
// Revision 1.132  2004/05/17 09:54:32  vova
// 67762: dummy function call added To Avoid Unused Var Linux Warnings
// Revision 1.131  2003/10/19 07:25:43  eldad
// To main branch
// Revision 1.130.1.2  2003/10/14 11:00:19  eldad
// Revision 1.130  2003/09/08 10:25:11  eldad
// Stopped using _OMSTATECHART_ANIMATED
// Revision 1.129  2003/08/19 11:12:24  vova
// New macros added IMPLEMENT_REACTIVE_META_SIMPLE... for reactive classes without statechart
// Revision 1.128.1.2  2003/08/17 12:40:33  vova
// New macro added: IMPLEMENT_REACTIVE_META_SIMPLE...
// Revision 1.128  2003/06/11 06:46:28  eldad
// Merge 1.122.2.5 + 1.127
// Revision 1.127  2003/06/10 15:05:59  eldad
// Fixed OM_RETURN_VOID macro.
// Revision 1.126  2003/06/01 08:55:45  gio
// In macro NOTIFY_TEKAE_EVENT:
// Removed multiple attribute declarations,
// attribute declaration moved to the top of the macro.
// Revision 1.125  2003/05/26 14:01:15  vova
// Merge with ESTL 4.2
// Revision 1.124  2003/05/15 06:49:42  Eldad
// Serailization of output params and return value
// Revision 1.123.1.1  2003/04/10 12:23:31  Eldad
// Duplicate revision
// Revision 1.122.1.2  2003/04/09 10:41:57  sasha
// Code Generation for Implicit objects
// Revision 1.122.1.1  2003/04/07 15:52:08  sasha
// New parameter on IMPLEMENT_META macro
// Revision 1.122  2002/12/09 09:56:48  amos
// Fix macro casting  for MultiWin32 compiler
// Revision 1.121  2002/12/04 10:43:00  vova
// 59928: GreenHills MULTI problem of 0 casting to based class solved
// Revision 1.120  2002/11/25 08:26:23  Eldad
// 1.119.1.2 to main branch.
// Revision 1.119.1.2  2002/11/20 15:16:59  Eldad
// changed instance to theAomInstance to avoid compilation errors.
// Revision 1.119.1.1  2002/11/10 15:06:01  Eldad
// Duplicate revision
// Revision 1.118  2002/11/07 08:01:39  vova
// 58557:error message has been improved, when event has uninstrumented argument(s)
// Revision 1.117  2002/10/06 11:35:46  Eldad
// Changes to make operation instrumentation work in Solaris 
// (dealing with the pre processor bugs).
// Revision 1.116  2002/09/19 08:25:48  vova
// 57899: Initializer for template with superclass
// Revision 1.115  2002/09/17 09:18:09  vova
// 57854,57852 - instrumentation IMPLEMENT_REACTIVE_META_M macro should be changed: AOMInstance initializer moved to REGISTER_CLASS macro.
// Revision 1.114  2002/09/11 14:21:41  vova
// 57712:OMINIT_SUPERCLASS macro initializes in the wrong order
// Revision 1.107.3.2  2002/09/11 10:55:54  vova
// 57712: OMINIT_SUPERCLASS macro initializes in the wrong order
// Revision 1.113  2002/09/10 07:19:19  Eldad
// Safe programming for unserializing animated instances.
// Revision 1.112  2002/08/19 16:32:52  vova
// Smart types instrumentation for operation invocation: OP_UNSER macro has been changed
// Revision 1.111  2002/07/30 11:18:03  Eldad
// Anim Op Calls
// Revision 1.110  2002/07/29 11:39:45  Eldad
// Merge 1.107.2.1 + 1.109
// Revision 1.109  2002/07/28 14:19:05  vova
// SmartTypesInstrumentation
// Revision 1.108.1.3  2002/07/25 14:38:49  vova
// Smart Data types instrumentation: new macro definitions added: IMPLEMENT_META_EVENT_NO_UNSERIALIZE, etc
// Revision 1.108.1.2  2002/07/24 08:51:06  vova
// Parameter added to OMUNSER macro.
// New UNKNOWNx2String macros added
// Revision 1.108.1.1  2002/07/07 15:25:53  vova
// Duplicate revision
// Revision 1.107.1.2  2002/07/07 15:25:53  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.107.1.1  2002/06/09 13:53:51  amos
// Duplicate revision
// Revision 1.108.1.1  2002/07/07 15:25:53  vova
// Duplicate revision
// Revision 1.107.1.2  2002/07/07 15:25:53  amos
// replace adaptor specific #ifdef with generic statements
// Revision 1.107.1.1  2002/06/09 13:53:51  amos
// Duplicate revision
// Revision 1.107.2.1  2002/07/29 11:37:26  Eldad
// Revision 1.107  2002/06/09 13:53:51  vova
// 55740:Differences between expected and actual behavior in model globals
// Revision 1.106  2002/06/06 12:28:50  avrahams
// Add Nucleus adaptor frame work changes
// Revision 1.105  2002/06/04 10:22:04  vova
// Solaris C compiler bug problem fixed (see comments in file)
// Revision 1.104  2002/04/24 08:16:26  vova
// 54577: casting added to the OM_SET_INSTANCE_NAME macro parameter
// Revision 1.103  2002/04/14 11:50:26  vova
// 54577: casting has been added to OM_SET_INSTANCE_NAME parameter in order to avoid warnings on Solaris
// Revision 1.102.1.1  2002/04/15 09:18:31  avrahams
// Bugfix 54563 - fix compilation error invoked by WorkShop 6 updated compiler
// Revision 1.102  2002/03/26 12:30:12  avrahams
// Add the super event name space as argument of the  animation macro DECLARE_META_SUBEVENT macro.
// Revision 1.101  2002/01/29 13:50:54  vova
// 53072: check has been added, whether the AOMInstance is not 0.
// Revision 1.100  2002/01/23 16:46:43  vova
// 52946: New macro NOTIFY_STATIC_OPERATION_T has been added.
// Revision 1.99  2002/01/08 13:32:22  vova
// 52564: too early ~AOMEnterExit destructor execution eliminated- two additional parameters added to the AOMEnterExit constructor.
// Revision 1.98  2002/01/08 08:03:24  vova
// 52365: pSOS dependent changes in NOTIFY_DESTRUCTOR
// Revision 1.97  2002/01/07 17:29:50  vova
// AOMEnterExit destructor must execute before AOMInstance deletion
// Revision 1.96  2002/01/07 17:26:00  vova
// 52365: AOMEnterExit destructor should execute before AOMInstance deletion
// Revision 1.95  2002/01/07 15:23:02  vova
// 52365: additional parameter has been added for NOTIFY_DESTRUCTOR in RiC++.If it is equal to true, AOMInstance should be deleted.
// Revision 1.94  2002/01/01 08:49:59  vova
// 52365:Purifying shows leaks in Dishwasher running in Animation mode
// Revision 1.93  2001/12/03 12:05:54  Eldad
// Support for instance names in animation.
// Revision 1.92.1.2  2001/11/29 07:27:53  Eldad
// Revision 1.92.1.1  2001/11/28 07:53:04  Eldad
// Duplicate revision
// Revision 1.90  2001/11/07 16:28:47  vova
// 49618: Name Space has been added into IMPLEMENT_META_ for templates.
// Revision 1.89  2001/09/25 10:21:29  vova
// 49026: Reactive Template instrumentation has been changed:
// serializeStates function generation has been added.
// Revision 1.88  2001/08/09 15:04:57  vova
// 46729: partial animation with non-animated statechart
// Revision 1.87  2001/08/08 14:07:28  vova
// 46657: safe-programming changes
// Revision 1.86  2001/08/07 16:10:15  vova
// #46579:Crash if constructor "Animate" property == False
// Revision 1.85  2001/08/07 10:12:39  amos
// use OMTimerManager instead of the OMThreadTimer typedef
// Revision 1.84  2001/08/07 09:28:36  vova
// NOTIFY_DESTRUCTOR macro was wrong for pSOS configuration:
// getAOMInstance was missing before the deregisterFromClass call.
// Revision 1.83  2001/07/03 09:33:49  amos
// modify NOTIFY_CONSTRUCTOR_BODY to call OMMainThread::instance() before additional work - this guarantee the existence of a main thread at the construction.
// Revision 1.82  2001/06/25 15:04:40  vova
// 45924: Multiple inheritance problem
// Revision 1.81  2001/06/25 13:51:08  vova
// 45924: inline static operation animation in C++ problem
// Revision 1.80  2001/06/21 16:20:12  vova
// #45883:C++ animation compilation problem, when inline operations exist.
// Revision 1.79  2001/05/16 12:32:33  amos
// merge OSE 4.3.1 support into r40
// Revision 1.78  2001/05/07 07:36:03  amos
// remove redundant '##' sings for Linux adaptor support.
// Revision 1.77  2001/05/06 10:35:26  amos
// fix Linux compiler warnings, replace "##::" with "## ::"
// Revision 1.76  2001/04/02 09:59:52  sasha
// Fixing Solaris bug.42624 - Can't compile code in Rhapsody 3.0 Beta on Solaris.
// The problem happens when there are global variables or functions 
// and using SUN compiler 5.0. If you are unsung SUN compiler 4.2 
// or 6.0 then there aren't compilation errors. This is some compiler bug
// on template instantiation and global functions.
// The solution is disabling the call of the function serializeGlobalVars
// for compiler 5.0 only. Removing the call will disable instrumentation 
// of global variables.  
// The limitation is:
// Global variables will not be instrumented (animated) in 
// the Rhapsody C++ 3.1 on Solaris on using SUN Compiler SC5.0.
// Workaround:
// Using another version of the compiler - for example 6.0.
// Revision 1.75  2001/03/28 07:00:16  vova
// Bug #42889: state animation, if trigger-event is not animated
// Revision 1.74  2001/03/27 10:00:08  vova
// Bug #42685: nested classes animation
// Revision 1.74  2001/03/27 09:38:35  vova
// Bug #42685 fixed: nested classes animation
// Revision 1.73  2001/03/26 13:26:02  vova
// Bug #42681 fixed
// Revision 1.72  2001/03/25 14:21:21  vova
// #41587 bug fixed
// Revision 1.71  2001/03/22 07:38:11  vova
// Bug #42634 fixed: OMADD_OMSER macro changed - "myEvent->" added
// Revision 1.70  2001/03/21 09:02:46  vova
// #42248 fixed: casting added
// Revision 1.69  2001/03/21 08:20:47  vova
// Compilation error fixed
// Revision 1.68  2001/03/20 11:43:38  amos
// merge framework customization (1.66.2.2) in r31
// Revision 1.67  2001/03/20 11:18:58  vova
// Back to main from 1.66.1.12
// Revision 1.66.1.12  2001/03/20 10:44:57  vova
// Multiple inheritance issue covered
// Revision 1.66.1.11  2001/03/18 15:36:09  vova
// New empty constructor added
// Revision 1.66.1.10  2001/03/18 14:41:49  vova
// Empty constructors added to DECLARE_META for multiple inheritance support in Partial Animation
// Revision 1.66.1.9  2001/03/09 13:18:54  vova
// Flat/reusable implementation changes
// Revision 1.66.1.8  2001/03/07 11:23:40  vova
// serializeStates virtuality added
// Revision 1.66.1.7  2001/03/07 08:16:44  vova
// Some syntax errors fixed
// Revision 1.66.1.6  2001/03/06 10:34:59  vova
// Changes for SUBEVENT/SUBCLASS done
// Revision 1.66.1.5  2001/03/05 16:57:22  vova
// Redundant  "if" deleted (pSOS warnings)
// Revision 1.66.1.4  2001/03/05 09:06:33  vova
// AOMInstance registration added to DECLARE_...SUBCLASS_T macros
// Revision 1.66.1.3  2001/03/01 12:21:27  vova
// Final version for Partial Animation
// Revision 1.66.1.2  2001/02/28 10:32:13  vova
// Template additions/changes for Partial Animation
// Revision 1.63.1.4  2001/02/21 12:53:42  vova
// Bug 41947 fixed
// Revision 1.63.1.3  2001/02/21 10:51:38  vova
// Bug 41947 fixed
// Revision 1.63.1.2  2001/02/20 09:32:38  vova
// Friend animation scheme
// Revision 1.66  2001/02/20 09:30:39  vova
// DECLARE_META_T and DECLARE_REACTIVE_META_T changed/added for templates
// Revision 1.65  2001/02/15 09:37:25  vova
// Partial Animation friend scheme
// Revision 1.64  2001/02/07 13:59:15  vova
// Revision 1.63  2001/01/30 09:07:02  avrahams
// Add OM prefix to destructiveString2X
// Revision 1.62  2001/01/29 11:30:24  vova
// DECLARE_REACTIVE_META added
// Revision 1.61  2001/01/28 14:54:09  vova
// Function name changed
// Revision 1.60  2001/01/10 16:12:03  vova
// Merge with Partial Animation
// Revision 1.59  2001/01/04 12:02:32  amos
// in DECLARE_META_PACKAGE() - make the definition of aompackage from 'static char*' to 'static const char*'
// in IMPLEMENT_META_PACKAGE() modify the definition of the variable in the AOM##package##Globals CTOR from 'char*' to 'const char*'
// Revision 1.58  2000/11/21 15:45:48  amos
// modify AOMEventClass::getClass() to AOMEventClass::getEventClass().
// - this change is made to allow customization of the event base class, using animated classes.
// - conform with the new signature
// Revision 1.58.1.4  2001/01/09 09:25:58  vova
// getOMEventPart added
// Revision 1.58.1.3  2001/01/03 16:34:15  vova
// getReactPart()  added
// Revision 1.58.1.2  2000/12/17 14:10:04  vova
// Merge 3.1 with PartAnim
// Revision 1.57.1.3  2000/09/06 11:54:11  vova
// Bug fixes in Partial Animation
// Revision 1.57.1.2  2000/08/30 16:12:03  vova
// Partial Animation: Phases 1,2
// Revision 1.57.1.1  2000/03/15 13:15:43  vova
// Revision 1.58.1.1  2000/11/21 15:45:48  vova
// Duplicate revision
// Revision 1.57  2000/03/15 13:15:43  amos
// modify IMPLEMENT_META_EVENT_S to pass the address of the dummy super event .
// Revision 1.56  2000/03/14 08:38:46  amos
// back to main branch
// Revision 1.55.1.1  2000/03/09 08:04:05  amos
// remove inlined function from DECLARE_META_EVENT to IMPLEMENT_META_EVENT_ - for psos x86 support.
// Revision 1.55  2000/02/28 13:55:04  amos
// fix null transition step -
// * in NOTIFY_NULL_TRANSITION_STEP() call the stepper->notifyNullTransitionStep()
// * in the call stack push and pop methods, do not notify step if type == omNullTransition
// --- Added comments ---  amos [2000/02/28 13:56:22 GMT]
// Note: version 1.54 skipped !!!
// Revision 1.53  2000/02/22 13:30:32  amos
// back to main branch
// Revision 1.52.1.2  2000/02/16 11:29:32  amos
// add the IMPLEMENT_META_S_T macro
// Revision 1.52.1.1  2000/02/14 14:00:49  amos
// Duplicate revision
// Revision 1.51.2.2  2000/02/14 11:12:14  amos
// in IMPLEMENT_META_PACKAGE() modify the aom<package>Global attribute to non-static.
// Revision 1.51.2.1  2000/02/07 15:01:34  amos
// Revision 1.51.1.2  2000/02/08 12:14:50  beery
// Revision 1.51.1.1  2000/02/07 15:01:34  beery
// Duplicate revision
// Revision 1.50.1.1  2000/02/01 12:19:51  amos
// comment the call to AOMStepper::notifyNullTransitionStep() in NOTIFY_NULL_TRANSITION_STEP() macro - to speed the 'go step' (2 'go step' per transition instead of 3)
// Revision 1.50  2000/01/31 09:42:38  amos
// back to main branch
// Revision 1.49.1.2  2000/01/30 13:30:53  amos
// change aomGlobal declaration in IMPLEMENT_META_PACKAGE to aom<package name>Global.
// add the DECLARE_PACKAGE macro that support instrumentation of global inlined functions.
// add parameter with the package name to NOTIFY_FUNCTION to support the cange of aomGlobal name (see above).
// Revision 1.49  2000/01/19 12:31:21  amos
// back to main branch
// Revision 1.48.1.1  2000/01/12 14:00:33  amos
// add macro that notify the 0 transition step
// Revision 1.48  2000/01/12 08:04:05  sasha
// Added new macros for template classes
// Revision 1.47  1999/11/07 06:32:33  amos
// add support in instrumentation of Active but not reactive classes.
// Revision 1.46  1999/10/25 07:08:45  amos
// rename the macro BAD_PARAM to OMBAD_PARAM to resolve name conflict with orbix
// Revision 1.45  1999/09/01 10:32:08  sasha
// Not instrumented vesion of NOTIFY_REACTIVE_CONSTRUCTOR
// Revision 1.44  1999/06/28 13:10:14  sasha
// Changed package macro for serializeGlobVar function
// Revision 1.43  1999/06/24 16:36:31  sasha
// Fixed serializeGlobalVars function
// Revision 1.42  1999/06/24 14:45:13  sasha
// Removed redundant ","
// Revision 1.41  1999/06/23 13:22:07  sasha
// Adjust macros for r25 code generation
// Revision 1.40.2.1  1999/02/22 10:18:39  sasha
// Duplicate revision
// Revision 1.39  1999/01/26 08:26:36  amos
// back to root
// Revision 1.38.1.2  1999/01/24 14:50:32  amos
// Revision 1.38  1999/01/21 12:06:02  beery
// identical to 1.36.1.3
// adjust to classes which were generated by Rhapsody but are part of the oxf itself and are not instrumented
// Revision 1.36.1.3  1999/01/19 16:21:03  beery
// support framework instance
// Revision 1.36.1.2  1999/01/07 09:36:27  beery
// Revision 1.36.1.1  1999/01/06 15:29:36  beery
// Revision 1.37  1999/01/06 15:29:24  beery
// Revision 1.37  1999/01/12 11:41:28  amos
// 1.36.2.1 to the main branch
// Revision 1.36.2.1  1999/01/07 14:54:27  amos
// modify IMPLEMENT_META_PACKAGE to support animation of nested
// Revision 1.36  1998/11/22 12:41:21  amos
// suport of nested name space in event macros
// Revision 1.35  1998/10/14 07:55:17  ofer
// DIAB_DTOR_BUG defined ( under psosppc and psos68k)
// so the "terminate connector" bug fix that was made on rev 1.34
// is relevant only under ppc and 68k
// Revision 1.34  1998/10/13 13:52:02  ofer
// solve psos "terminate connector" bug the problem is that
// the AOMEnterExit dtor is called after the OMREACTIVE dtor 
// and therefor the NOTIFY_DESTRUCTOR under psos calls
// implicitly deregisterFromClass ( aommacro.h)
// Revision 1.33  1998/07/08 10:47:57  yachin
// Fix crash when removing invalid item
// Revision 1.32  1998/06/24 06:04:36  yachin
// Fix stupid mistake
// Revision 1.31  1998/06/23 12:33:44  yachin
// Fix borland bugs
// Revision 1.30  1998/03/09 08:04:15  yachin
// Fxied spelling mistake (bug 5019)
// Revision 1.29  1998/01/11 13:04:02  yachin
// fixed notify_relationItem_Added with null to act as notify_clear_relation
// Revision 1.28  1997/10/28 08:17:09  yachin
// try/catch(...) replaced by OMTRY and OMCATCH 
// so we catch bus-error segmentation-fault on UNIX 
// Revision 1.27  1997/09/23 13:15:38  yachin
// fix some warning in UNIX compiler
// Revision 1.26  1997/07/29 08:24:40  yachin
// Fixed bug 3235 (triggered ops in MSC)
// Revision 1.25  1997/07/24 05:23:37  yachin
// Revision 1.24  1997/07/22 10:37:01  yachin
// Without instrumentation for global instance names
// Revision 1.23  1997/07/21 08:15:36  yachin
// bug fix
// Revision 1.22  1997/07/20 11:50:27  yachin
// Revision 1.21  1997/07/20 11:41:06  yachin
// Adding globals to animation
// Revision 1.20  1997/04/14 06:25:36  ofer
// Update comment of NOTIFY_DEST macro
// Revision 1.19  1997/04/08 10:15:10  ofer
// Change macro of NOTIFY_DESTRUCTOR
// Revision 1.18  1997/04/07 10:10:03  yachin
// Revision 1.17  1997/04/06 11:36:53  yachin
// Assorted bug fixes
// Revision 1.16  1997/03/20 06:23:09  yachin
// renamed some "items"
// Revision 1.15  1997/03/13 08:51:24  yachin
// Bug fix from string2X
// Revision 1.14  1997/03/12 10:16:10  yachin
// fix on fix
// Revision 1.13  1997/03/11 13:04:24  yachin
// Revision 1.12  1997/03/11 12:54:17  yachin
// Fixed memory lick in _ADD_UNSER
// Revision 1.11  1997/02/26 11:48:49  yachin
// Revision 1.10  1997/02/26 11:35:57  yachin
// NOTIFY_LOCK - works on passiveGetCurrentThread
// Revision 1.9  1997/02/25 07:22:57  yachin
// added DECLAR_GET_CONCPT macro
// Revision 1.8  1997/02/23 12:54:02  yachin
// Added workaround for MSDEV bug in namespace wit hstatic attributes
// Revision 1.7  1997/02/11 10:00:03  yachin
// Changes for name-spaces
// 
// Revision 1.6  1997/02/04 12:18:30  yachin
// Revision 1.5  1997/02/04 08:27:24  yachin
// Revision 1.4  1997/02/03 09:26:24  yachin
// Events with parameters
// Revision 1.3  1997/01/26 13:54:50  yachin
// Revision 1.2  1997/01/26 13:49:55  yachin
// ReWrite for Foreign Threads
// Revision 1.1  1997/01/21 11:46:36  yachin
// Initial revision
//

#endif
