#ifndef aomitem_H
#define aomitem_H "$Id: aomitem.h 1.40 2007/03/11 11:57:52 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomitem.h $
//	file version:	$Revision: 1.40 $
//
//	purpose:	Super class of all Animated "executable" items
//
//	author(s):	  Yachin Pnueli
//	date started:	30.5.96
//	date changed:	$Date: 2007/03/11 11:57:52 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aoxf.h"
#include <omcom/ommask.h>
#include <omcom/omnote.h>
#include <omcom/omsdata.h>
#include <omcom/omexp.h>
//
//	AOMAnimationItem	-	The Base class of executable animation item
//
// Paradigms:
// myProxy - The "TOM" counter part of the item
//	When created myProxy = 0; 
//	When message with "real proxy" arrives, myProxy is set accordingly.
//	Once set myProxy is never changed until 
//	Destruction - where it is set to OMInDestruction
// myMask  - the interest mask is set on creation to OMNoInterest
//	it is changed once when the real proxy message arrives and may 
//	change again if a changeMask message arrives

const int AOMNoMultiplicity = (-1);

class AOMSMethod;
class AOMSData;

class AnimMessage;

class RP_FRAMEWORK_DLL AOMAnimationItem {
private:
	static short MagicCookie;
	short myCookie;
protected:
	OMInterestMask myMask;
	void * myProxy;

	// Auxilaries
	void unexpectedCommand(OMNotify msgCode);

	// Basic mutators
	void setProxy(void * theProxy, OMInterestMask theMask) {
		myProxy = theProxy;
		setInterestMask(theMask);
	}

	virtual int getDefaultMask() const { return OMExistInterest | OMInstanceInterest; }
public:
	// Constructurs/destructors
	virtual ~AOMAnimationItem();
	AOMAnimationItem();

	void waitForProxy(); // Wait until proxy is created

	void * getProxy() const {	return myProxy; }

	bool aomIsValid() const;

	virtual void sendMyself( OMInterestMask ) { }

	virtual void handleMessage(AnimMessage *animMessage);
	virtual void handleMessage(OMNotify r, OMSData* s, OMSPosition& p);

	// Needed as they are used by more than one sub class
	virtual void notifyGotControl() const;
	virtual void notifyLostControl() const;
	virtual void notifySynchronize() const { }
	virtual void serializeSuperClasses(AOMSData& ) const { }

	// to avoid crash while registering
	virtual void registerOperations() { }


	bool isInteresting(unsigned int theMask = OMAllInterest) const
	{ 
		return myMask.isInteresting(theMask);
	}
	OMInterestMask getInterestMask() const { return myMask; }
	void setInterestMask(OMInterestMask theMask) { 
		myMask = theMask;
	}

	void setProxyInConstruction() {
		myProxy = OMInConstruction;
		setInterestMask(getDefaultMask());
	}
};


template<class T> TMPL_INL bool aomIsValidItem(const T * const i) {
	OMTRY {
		// Check:	1. That we can "cast"
		//			2. That the virtual table is valid
		//			3. That the object is not marked deleted
		if (isCodeItem(i))
			return false;
		return ((AOMAnimationItem *)i)->aomIsValid();
	} OMCATCH_ALL { return false; }
}
// bool aomIsValidItem(const void * const i);

//
// $Log: aomitem.h $
// Revision 1.40  2007/03/11 11:57:52  ilgiga
// Change copyright comment
// Revision 1.39  2007/03/01 16:31:24  ilgiga
// Telelogic instead of i-Logix
// Revision 1.38  2006/07/26 13:32:29  eldad
// To main branch
// Revision 1.37.1.2  2006/07/24 13:48:48  eldad
// AOMPackage should not notify got and lost control.
// For that, the notify methods are now virtual for AOMAnimationItem
// Revision 1.37.1.1  2005/04/21 10:03:24  eldad
// Duplicate revision
// Revision 1.36.1.2  2005/03/16 14:02:33  amos
// Revision 1.36  2002/07/29 11:42:06  Eldad
// Anim Operation Calls.
// Revision 1.35  2001/12/03 12:06:18  Eldad
// Support for instance names in animation.
// Revision 1.34.2.2  2001/11/29 07:26:59  Eldad
// Revision 1.34.2.1  2001/04/02 07:18:09  Eldad
// Duplicate revision
// Revision 1.33  2000/12/27 08:45:02  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.32  1999/02/16 06:08:02  yachin
// Speed up of construction during animation
// Revision 1.31  1999/01/25 16:56:26  amos
// change inline to TMPL_INL to avoid borland warnings
// Revision 1.30  1998/08/02 15:02:05  beery
// changing boolean->bool
// Revision 1.29  1998/06/29 12:24:43  ofer
// bugfix 4805 the problem was that the sender send the event and
//  then  kill itself and the notification relate to the sender,
// so we put magic cookie and aomIsValid use that cookie
// to check wether the proxy item is valid or not (aomitem.cpp/h)
// Revision 1.28  1998/06/23 12:33:44  yachin
// Fix borland bugs
// Revision 1.27  1997/11/19 08:43:06  yachin
// Fixed 'inline' problems for Borland compiler
// Revision 1.26  1997/10/28 08:17:08  yachin
// try/catch(...) replaced by OMTRY and OMCATCH 
// so we catch bus-error segmentation-fault on UNIX 
// Revision 1.25  1997/07/24 05:23:36  yachin
// Revision 1.24  1997/05/13 08:27:16  yachin
// renamed isValid to aomIsValid (bug#3192)
// Revision 1.23  1997/04/07 22:59:56  ofer
// Move file names and includes to lowercase
// so UNIX will work with lowercase versions
// Revision 1.22  1997/04/06 11:36:52  yachin
// Assorted bug fixes
// Revision 1.21  1997/02/06 13:31:04  yachin
// Switch from try to aomIsValidItem
// Revision 1.20  1997/02/05 13:47:02  yachin
// Add virtual isValid()
// Revision 1.19  1997/02/03 06:31:29  yachin
// Revision 1.18  1997/01/21 11:02:27  yachin
// changed _int32 to int
// Revision 1.17  1997/01/21 09:20:25  yachin
// removed AOMStatic
// Revision 1.16  1996/11/24 12:55:25  yachin
// Revision 1.15  1996/11/11 11:46:52  yachin
// Support multi-thread part I
// Revision 1.14  1996/11/10 07:51:00  yachin
// fixed gotControl breakpoint + breakPoint to dead objects
// Revision 1.13  1996/10/09 07:33:58  yachin
// Revision 1.12  1996/08/29 10:46:08  ofer
// Revision 1.11  1996/08/15 08:40:49  yachin
// Revision 1.10  1996/08/14 12:38:19  yachin
// Separate "updated" data from "show" data
// Revision 1.9  1996/08/12 12:34:41  yachin
// Seperated show from trace (possibly has bug if existence is canceled and then turned on).
// Revision 1.8  1996/08/06 12:49:52  yachin
// Tracer for Prototype 4
// Revision 1.7  1996/07/18 10:48:54  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.6  1996/07/10 09:12:08  yachin
// Revision 1.5  1996/07/10 05:46:59  yachin
// Reorganization + some stuff for OMANIMATOR
// Revision 1.4  1996/07/04 12:37:44  yachin
// Revision 1.3  1996/07/03 12:44:39  yachin
// Fixing bugs for "const" and "static" functions
// Revision 1.2  1996/06/19 10:18:50  yachin
// Revision 1.1  1996/06/17 05:33:18  yachin
// Initial revision
//

#endif
