#ifndef aomevent_H
#define aomevent_H "$Id: aomevent.h 1.35 2007/03/11 11:57:51 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomevent.h $
//	file version:	$Revision: 1.35 $
//
//	purpose: Classes AOMEvent and AOMEventClass
//			The classes of events and meta-events
//			These are NOT derived from AOMAnimationItem since they
//			do not have or need "proxyItems"
//
//	author(s):	Yachin Pnueli
//	date started:	13.6.96
//	date changed:	$Date: 2007/03/11 11:57:51 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//

#include "aomitem.h"

//
//	AOMEventClass	-	The Classes of Meta-Events
//
class AOMEvent;
class AOMSEvent;
class IOxfEvent;

class RP_FRAMEWORK_DLL AOMEventClass :public AOMAnimationItem
{
public:
	typedef AOMEvent*(*EventUnserializeOp)(OMSData&);
	// Destructor
	virtual ~AOMEventClass();

	// Constructors
	AOMEventClass(	const char * theName,
					const char * theSignature, 
					EventUnserializeOp theFactory,
					const char * theContext,
					AOMEvent * theSuperEvent = 0);

	void serializeSuperClasses(AOMSData& s) const;
	// simple accessors/mutators
	void setAttributeCount(int theCount);
	int getAttributeCount() const;
	const OMHandle * getEventName();
	const OMHandle * getEventSignature();

	// Methods that do something
	AOMEvent *createEvent(OMSData &plist);

private:
	const OMHandle * name;		// For example "Kuku"
	const OMHandle * signature;// For example "Kuku(int, char *)"
	int attributeCount;			// How many parameters in this event class
								// Currently a constant so it is counted once
	EventUnserializeOp factory;	// The event factory for "my class"
	AOMEventClass * superEvent;	// The base class of this event class
};


class RP_FRAMEWORK_DLL AOMEvent
{
public:
	AOMEvent(AOMAnimationItem* theSender = 0) : mySender(theSender), theEventPart(0)
	{
	}

	AOMEvent(IOxfEvent* theOMEventPtr) : mySender(0), theEventPart(theOMEventPtr)
	{
	}

	virtual ~AOMEvent() { }
	IOxfEvent *getEventPart() const { return theEventPart;} 
	// Methods which should be overloaded for every actual event
 	virtual AOMEventClass * getEventClass() const { return 0; }
 	virtual void  serialize(AOMSEvent * ) const { }

	// Methods which should be overloaded only for timeout events
 	virtual OMSData* cserialize(bool withParameters) const;

	// Simple accessors/mutators
	AOMAnimationItem * getSender() const { return mySender; }
	void setSender(AOMAnimationItem *const theSender) { mySender = theSender; }
private:
	// The receiver is stored in the "real event"
	AOMAnimationItem * mySender;
	IOxfEvent * theEventPart;
};


// instrumentation services to the framework events
class AOMFrameworkEvent : public AOMEvent
{
public:
	AOMFrameworkEvent(IOxfEvent* ev);

	// overriden
 	virtual OMSData* cserialize(bool withParameters) const;
};


//
// $Log: aomevent.h $
// Revision 1.35  2007/03/11 11:57:51  ilgiga
// Change copyright comment
// Revision 1.34  2007/03/01 16:31:24  ilgiga
// Telelogic instead of i-Logix
// Revision 1.33  2005/04/21 10:03:20  amos
// Revision 1.32.1.4  2005/04/10 15:25:21  amos
// Revision 1.32.1.3  2005/04/07 12:49:59  amos
// Revision 1.32.1.2  2005/03/16 14:02:31  amos
// Revision 1.32  2004/09/08 13:02:38  amos
// 75108 to main branch
// Revision 1.31.1.2  2004/09/07 14:17:42  amos
// Rename the framework interfaces and types to ensure unique names as well as updating all references.
// - IActive changed to IOxfActive
// - IReactive changed to IOxfReactive
// - IEvent changed to IOxfEvent
// - ITimeout changed to IOxfTimeout
// - IEventGenerationParams changed to IOxfEventGenerationParams
// - TimeUnit changed to OxfTimeUnit
// Revision 1.31.1.1  2004/06/27 15:43:03  amos
// Duplicate revision
// Revision 1.30.1.2  2004/02/03 14:51:52  amos
// Revision 1.30.1.1  2001/03/20 11:17:32  amos
// Duplicate revision
// Revision 1.29.1.2  2001/02/20 09:47:01  vova
// Partial Animation friend using scheme
// Revision 1.31  2001/02/15 09:41:37  vova
// Partial Animation friend using scheme
// Revision 1.30  2001/02/07 14:01:01  vova
// Revision 1.29  2001/01/10 16:20:02  vova
// Merge with Partial Animation additions
// Revision 1.28  2000/12/27 08:44:48  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.27.1.2  2001/01/09 09:31:09  vova
// virtual function getOMEventPart added
// Revision 1.27  2000/11/21 15:45:48  amos
// modify AOMEventClass::getClass() to AOMEventClass::getEventClass().
// - this change is made to allow customization of the event base class, using animated classes.
// - conform with the new signature
// Revision 1.26  2000/03/17 09:54:39  amos
// back to main branch
// Revision 1.25.1.2  2000/03/15 08:11:55  amos
// add AOM event class for OMStartBehaviorEvent
// Revision 1.25.1.1  2000/03/14 08:38:45  amos
// Duplicate revision
// Revision 1.24.2.1  2000/03/09 07:55:13  amos
// modify AOMEventClass constructor last parameter, from AOMEventClass* to AOMEvent*.
// in the ctor body use the AOMEvent to get its AOMEventClass.
// also remove inlined functions from AOMEventClass (psos x86 support).
// Revision 1.24  1999/02/16 06:08:00  yachin
// Speed up of construction during animation
// Revision 1.23  1998/08/02 15:04:03  beery
// changing boolean->bool
// Revision 1.22  1997/07/24 05:23:35  yachin
// Revision 1.21  1997/02/11 10:00:02  yachin
// Changes for name-spaces
// 
// Revision 1.20  1997/02/03 09:26:23  yachin
// Events with parameters
// Revision 1.19  1997/01/21 11:46:23  yachin
// instrumentation macros moved to aommacro.h
// Revision 1.18  1996/11/24 12:55:24  yachin
// Revision 1.17  1996/10/21 11:38:25  yachin
// Cleanup on state notifies + fixes on timeouts + support for breakpoints
// Revision 1.16  1996/10/09 07:33:57  yachin
// Revision 1.15  1996/09/02 13:40:42  yachin
// Preparations for connecting with call stack view and MSC
// Revision 1.14  1996/08/28 05:35:22  ofer
// Revision 1.13  1996/08/08 08:22:15  yachin
// Prototype 4 major revision
// Revision 1.12  1996/08/06 12:49:51  yachin
// Tracer for Prototype 4
// Revision 1.11  1996/07/18 10:48:53  yachin
// Post Prototype 3 rewrite: virtual destructors, remarks, type changes and safe programing on deleted items
// Revision 1.10  1996/07/10 05:46:57  yachin
// Reorganization + some stuff for OMANIMATOR
// Revision 1.9  1996/07/04 12:37:43  yachin
// Revision 1.8  1996/07/03 12:44:37  yachin
// Fixing bugs for "const" and "static" functions
// Revision 1.7  1996/06/24 11:15:19  yachin
// OMANIMATOR version should work
// Revision 1.6  1996/06/24 05:10:34  yachin
// Revision 1.5  1996/06/23 11:18:50  yachin
// Changes for integration with oxf
// Revision 1.4  1996/06/20 11:14:29  yachin
// Revision 1.3  1996/06/20 10:21:51  yachin
// Revision 1.2  1996/06/19 10:18:48  yachin
// Revision 1.1  1996/06/17 05:33:13  yachin
// Initial revision
//

#endif
