#ifndef aomcalls_H
#define aomcalls_H "$Id: aomcalls.h 1.16 2007/03/11 11:57:50 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aomcalls.h $
//	file version:	$Revision: 1.16 $
//
//	purpose:	AOMCallStack class
//
//	author(s):	  Yachin Pnueli
//	date started:	27.1.97 (split from aomother.h
//	date changed:	$Date: 2007/03/11 11:57:50 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//


#include "aomitem.h"
#include <oxf/omstack.h>

//
//	AOMCallStack	-	The "executable" call stack
//						Also responsible for registration/deregistration
//						of objects in classes
//						
class AOMInstance;
class AOMSMethod;
class AOMThread;
class OMOSMutex;


class AOMCallStack : public AOMAnimationItem
{
public:
	RP_FRAMEWORK_DLL virtual ~AOMCallStack() { }

	RP_FRAMEWORK_DLL AOMCallStack(AOMThread* theThread);
	RP_FRAMEWORK_DLL AOMInstance* getRegistrationCandidate(){ return registrationCandidate; }

	RP_FRAMEWORK_DLL void setRegistrationCandidate(AOMInstance *);
	RP_FRAMEWORK_DLL void notify(const AOMAnimationItem * const instance,
					const OMMethodType type);
	RP_FRAMEWORK_DLL void push(const AOMAnimationItem * const instance, 
					 AOMSMethod * method,
					 OMMethodType type);
	RP_FRAMEWORK_DLL void pop();
	RP_FRAMEWORK_DLL AOMAnimationItem * top() { return instanceStack.top(); }

	RP_FRAMEWORK_DLL bool isEmpty() const { return instanceStack.isEmpty(); }

	RP_FRAMEWORK_DLL void makeTransient() { isTransient = true; }
	RP_FRAMEWORK_DLL bool getIsTransient() { return isTransient; }
	RP_FRAMEWORK_DLL void sendMyself(OMInterestMask theMask);
	RP_FRAMEWORK_DLL void restToMain(); // Used only from oxfInit() !!!
	RP_FRAMEWORK_DLL void setNextCallFromEnv(bool value) { nextCallIsFromEnv = value; }

	// Add the specified instance to the instancesForDeletion list
	RP_FRAMEWORK_DLL void registerInstanceForDeletion(const AOMInstance* inst);

private:
	void resetRegistrationCandidate();
	void registerCandidate();
	void deregisterItem(AOMInstance *, AOMAnimationItem *);
	bool shouldNotifyMethodCall(const AOMAnimationItem *const item, const OMMethodType type);
	bool shouldNotifyMethodReturn(const OMMethodType type);
	virtual int getDefaultMask() const { return OMAllInterest; }
	
	// executes stack tasks that should be done when the context thread is idle (empy stack)
	void checkAndDoEmptyStackActivities(OMMethodType type);
	
	// delete instances waiting for deletion
	void deleteInstancesForDeletion();

	bool isTransient;
	AOMThread * myThread;
	OMStack<AOMAnimationItem *> instanceStack;
	OMStack<AOMSMethod *> methodStack;
	OMStack<OMMethodType> typeStack;

	// List of AOMInstances that should be deleted when the context thread becomes idle
	// We wait until the thread is idle in order to avoid destruction in the before a base class destructor is called
	OMList<const AOMInstance*> instancesForDeletion;

	// a static mutex to syncronize push() and pop() calls between callstacks
	// this is needed when passing an animated class (as an event parameter),
	// from one thread to the other, where the first thread create the class and the other -
	// destroy it.
	// DO NOT use this mutex for any other reason!!
	static OMOSMutex* callstackMutex;

	// this is a flag that indicates that the next push was made using
	// the CALL command.
	bool nextCallIsFromEnv; 


	AOMInstance * registrationCandidate;
	AOMAnimationItem * theCreator;
	AOMInstance * lastDeregistered;
};

//
// $Log: aomcalls.h $
// Revision 1.16  2007/03/11 11:57:50  ilgiga
// Change copyright comment
// Revision 1.15  2007/03/01 16:31:22  ilgiga
// Telelogic instead of i-Logix
// Revision 1.14  2005/06/06 15:34:25  amos
// Revision 1.12.3.1.1.3  2005/06/01 13:00:07  amos
// modify checkAndDoEmptyStackActivities() to get the poped operation type and to call deleteInstancesForDeletion() only if the type is not omDestructorMethod
// Revision 1.12.3.1.1.2  2005/05/31 16:21:27  amos
// Add to AOMCallStack a list of instances that should be deleted
// The instances are added by NOTIFY_DESTRUCTOR_BODY and the deletion is done when the callstack is empty
// We wait for an empty callstack in order to make sure that we are not inside a destruction sequence
// Revision 1.12.3.1.1.1  2005/04/21 10:03:13  amos
// Duplicate revision
// Revision 1.12.2.2  2005/03/16 14:02:27  amos
// Revision 1.12  2002/11/25 09:31:33  Eldad
// b#59702 - Ensure caller of CALL operation is the system border.
// Revision 1.11.1.1  2002/11/05 07:48:01  Eldad
// Duplicate revision
// Revision 1.10  2002/01/01 08:49:58  vova
// 52365:Purifying shows leaks in Dishwasher running in Animation mode
// Revision 1.9  2001/07/04 08:34:07  Eldad
// 1.8.1.2 to main branch.
// Revision 1.8.1.2  2001/07/03 12:55:33  Eldad
// getIsTransient() added.
// Revision 1.8  2000/12/27 08:44:06  amos
// Add support for framework as DLL - for support in Rhapsody C++ COM
// Revision 1.7  2000/07/20 09:42:27  amos
// OSE: initialize AOMCallStack::callstackMutex as 0, and set its value in AOMCallStack CTOR (if its not set).
// to support the call to theOSFactory() in AOMCallStack CTOR I moved the CTOR body to the cpp file.
// Revision 1.6  2000/06/19 13:49:00  amos
// Add a new member to AOMCallStack, the member - callstackMutex is a private static mutex to syncronize push() and pop() calls between callstacks,
// this is needed when passing an animated class (as an event parameter) from one thread to the other, 
// where the first thread create the class and the other destroy it.
// DO NOT use this mutex for any other reason!!
// Revision 1.5  1999/03/10 08:10:23  amos
// Clear callStack registration candidate between pre-main and main
// (fixes bug of crash on double registration of 'global' instance)
// Revision 1.4  1999/02/16 06:07:58  yachin
// Speed up of construction during animation
// Revision 1.3  1998/08/02 15:03:59  beery
// changing boolean->bool
// Revision 1.2  1997/04/06 11:36:51  yachin
// Assorted bug fixes
// Revision 1.1  1997/01/27 09:44:41  yachin
// Initial revision
//

#endif
