#ifndef aombrk_H
#define aombrk_H "$Id: aombrk.h 1.18 2007/03/11 11:57:49 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/aombrk.h $
//	file version:	$Revision: 1.18 $
//
//	purpose:	The Breakpoint reasons
//
//	author(s):	  Yachin Pnueli
//	date started:	16.10.96
//	date changed:	$Date: 2007/03/11 11:57:49 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1995, 2007
//
#include "aomitem.h"
#include <oxf/omlist.h>
#include <omcom/ombrk.h>

class AOMClass;
class AOMInstance;

class AnimMessage;

class AOMBreakPoint: public OMBreakPoint {
protected:
	bool classMatchesItem(AOMClass *theClass);
	bool instanceMatchesItem(AOMInstance *theClass);
	virtual bool checkTypeData(OMNotify theType, const char *theData="");
public:
	AOMBreakPoint(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :OMBreakPoint(theType,theItem,theData) { }
	virtual ~AOMBreakPoint() { }
	virtual bool checkBreakPoint(OMNotify theType, 
									const void *const theItem,
									const char *theData);
	AOMAnimationItem* getMyItem() const { return (AOMAnimationItem *)myItem; }
	void serialize(AOMSData&);
};


class AOMClassOnlyBreakPoint: public AOMBreakPoint {
public:
	AOMClassOnlyBreakPoint(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :AOMBreakPoint(theType,theItem,theData) { }
	virtual bool checkBreakPoint(OMNotify theType,
				 const void *const theItem,
				 const char *theData);
};


class AOMBPControlModified: public AOMBreakPoint {
	virtual bool checkTypeData(OMNotify theType, const char *theData="");
public:
	AOMBPControlModified(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :AOMBreakPoint(theType,theItem,theData) { }
};

class AOMBPStateBreakPoint: public AOMBreakPoint {
	virtual bool checkTypeData(OMNotify theType, const char *theData="");
	bool checkState(const char *theState="");
public:
	AOMBPStateBreakPoint(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :AOMBreakPoint(theType,theItem,theData) { }
};

class AOMBPRelation: public AOMBreakPoint {
	virtual bool checkTypeData(OMNotify theType, const char *theData="");
public:
	AOMBPRelation(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :AOMBreakPoint(theType,theItem,theData) { }
};

class AOMAttributeBreakPoint: public AOMBreakPoint {
public:
	AOMAttributeBreakPoint(OMNotify theType,
				 void * theItem,
				 const char *theData="")
				 :AOMBreakPoint(theType,theItem,theData) { }
	virtual bool checkBreakPoint(OMNotify theType, 
									const void *const theItem,
									const char *theData);
};

extern AOMBreakPoint * breakPointFactory(OMNotify theType,
				 void * theItem,
				 const char *theData);


class AOMBreakPointManager: public AOMAnimationItem {
	static AOMBreakPointManager* _instance;
	OMList<AOMBreakPoint *> theBreakPoints;
public:
	AOMBreakPointManager();
	virtual ~AOMBreakPointManager() { _instance = 0; }
	void notifyBreakPoint(AOMBreakPoint *brk);
	void checkBreakPoint(OMNotify theType,
							const void *const theItem,
							const char *theData="");
	void handleMessage(AnimMessage *animMessage);
	void handleMessage(OMNotify r, OMSData* s, OMSPosition& p);
	static AOMBreakPointManager* instance() {
		if (_instance==0) _instance = new AOMBreakPointManager;
		return _instance;
	}
};

extern void notifyRunTimeError(const AOMAnimationItem* const item,
							   const char* const msg);

//
// $Log: aombrk.h $
// Revision 1.18  2007/03/11 11:57:49  ilgiga
// Change copyright comment
// Revision 1.17  2007/03/01 16:31:21  ilgiga
// Telelogic instead of i-Logix
// Revision 1.16  2005/04/21 10:03:12  amos
// Revision 1.15.1.2  2005/03/16 14:02:26  amos
// Revision 1.15  2004/05/11 07:44:52  vova
// Linux warnings: order of initializers changed
// Revision 1.14  2001/04/17 15:21:17  Eldad
// Using new translation mechanism.
// Revision 1.13.1.2  2001/04/09 15:03:49  Eldad
// Refactoring of AnimMessages.
// Revision 1.13.1.1  2000/03/14 09:45:24  Eldad
// Duplicate revision
// Revision 1.12  1999/02/16 06:07:57  yachin
// Speed up of construction during animation
// Revision 1.11  1998/08/02 15:03:58  beery
// changing boolean->bool
// Revision 1.10  1997/07/20 11:41:01  yachin
// Adding globals to animation
// Revision 1.9  1997/04/07 22:59:38  ofer
// Move file names and includes to lowercase
// so UNIX will work with lowercase versions
// Revision 1.8  1997/04/06 11:36:50  yachin
// Assorted bug fixes
// Revision 1.7  1997/01/21 09:20:24  yachin
// removed AOMStatic
// Revision 1.6  1996/12/02 08:48:47  yachin
// Revision 1.5  1996/11/24 12:55:21  yachin
// Revision 1.4  1996/11/11 11:46:47  yachin
// Support multi-thread part I
// Revision 1.3  1996/11/11 06:35:45  yachin
// Revision 1.2  1996/11/10 07:50:58  yachin
// fixed gotControl breakpoint + breakPoint to dead objects
// Revision 1.1  1996/10/21 11:40:48  yachin
// Initial revision
//

#endif
