PATH_SEP=/
CC=wpp386 -w0 -e=150 -zq -od -d3 -bt=qnx386 -mf -xs
RM=rm -fr
CP=cp
RHAP_FLAGS=
WLIB=wlib
WLIBFLAGS=-b -q
DEFAULT_CPP_FLAGS=
SOURCES_DIR=..\oxf
AOM_SOURCES_DIR=..\aom
OMCOM_SOURCES_DIR=..\omcom
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I. -I$(WATCOM)\h\qnx386 -I$(WATCOM)\h -I$(SOURCES_DIR) -I$(OMCOM_SOURCES_DIR) -I$(AOM_SOURCES_DIR) -I.. -I..\..\osconfig\QNX425 $(RHAP_FLAGS)

targets=aomtrace aomanim

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)

.SUFFIXES: .cpp

LIB_EXT=.lib
OBJ_EXT=.o
OBJ_EXT2=.obj
CPP_EXT=.cpp
H_EXT=.h

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) $< 

ifeq ($(CFG),aomtrace)
RHAP_FLAGS:=-DOMTRACER
all: QNX425$(CFG)$(CPU).lib

else
ifeq ($(CFG),aomanim)
RHAP_FLAGS:=-DOMANIMATOR
all: QNX425$(CFG)$(CPU).lib

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

include qnx425_aomFiles.list

SRCS = $(AOM_SRC)
HDRS = $(AOM_HDR)
OBJS = $(AOM_OBJ)

define BUILD_LIB
#Remove OLD libs 		
	#$(RM) ../../lib/$@
#Linkink lib
	$(WLIB) $(WLIBFLAGS) $@ +aombrk$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomcalls$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomclass$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomdisp$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomeque$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomevent$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aominst$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomitem$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomstep$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomthrd$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aompack$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomoperation$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +OMAnimCommandLineParser$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +OMAnimResourceGuardNotifier$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +AOMMessageSender$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +AnimServices$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomNotifyUtils$(OBJ_EXT2)
	$(WLIB) $(WLIBFLAGS) $@ +aomtimerservice$(OBJ_EXT2)
$(CP) $@ ../../lib/$@
$(RM) $(OBJS) $@
$(RM) *.err
$(RM) *.obj
endef

QNX425aomtrace$(CPU).lib: $(OBJS)
	$(BUILD_LIB)

QNX425aomanim$(CPU).lib: $(OBJS)
	$(BUILD_LIB)
