#ifndef AOMMessageSender_H
#define AOMMessageSender_H "$Id: AOMMessageSender.h 1.9 2007/03/11 11:57:48 ilgiga Exp $"

//
//	file name   :	$Source: R:/StmOO/Master/cg/LangCpp/aom/rcs/AOMMessageSender.h $
//	file version:	$Revision: 1.9 $
//
//	purpose:	
//
//	author(s):	
//	date started:	
//	date changed:	$Date: 2007/03/11 11:57:48 $
//	last change by:	$Author: ilgiga $
//
//	(c) Copyright Telelogic 1997, 2007
//
#ifdef OMANIMATOR

#include "aomitem.h"
#include <oxf/omlist.h>
#include <oxf/omqueue.h>


class OMOSConnectionPort;
class OMOSThread;
class OMOSMutex;
class OMSData;
class OMOSEventFlag;
class OMOSMessageQueue;

class MsgCounter;
class MsgSenderQueue;

class AOMMessageSender
{
public:
	AOMMessageSender(OMOSConnectionPort* port);
	void start();
	void sendMessage(OMSData *msg);
	void terminate();
	void suspend();
	void resume();

protected:

	static void doExecute(void *me);
	virtual void execute();

	virtual ~AOMMessageSender();

private:
	OMOSConnectionPort *connPort;
	MsgSenderQueue *msgQueue;
	OMOSThread *thread;
	OMOSMutex *m_mutex;
	bool m_terminate;
	// BUSY or READY states
	int state; 
	static const int UNAVAILABLE;
	static const int READY;
	MsgCounter *msgCounter;

	void sendMessageFromQueue();
};

// protected counter (by Mutex)
class MsgCounter
{
public:
	MsgCounter();
	int get();
	void set(int val);
	int inc();
	int dec();
	~MsgCounter();
private:
	int m_count;
	OMOSMutex *m_mutex;
};


// An infinite queue copied from NTOSMessageQueue
class MsgSenderQueue {
private:
	OMQueue<void*> m_theQueue;
	OMOSMutex*	m_QueueMutex;
	OMOSEventFlag* m_QueueEventFlag;
	OMOSEventFlag* m_putEventFlag;
	int m_putCount;
public:
	  MsgSenderQueue(bool shouldGrow = true, int initSize = 128);
	  virtual ~MsgSenderQueue();
	  bool put(void *, bool fromISR = false);
	  void * get();
	  int isEmpty() { return m_theQueue.isEmpty(); }
	  void pend();
	  void getMessageList(OMList<void*>& c);
	  bool isFull() {return m_theQueue.isFull();}
	  virtual void* getOsHandle() const { return (void*) 0; }
};


#else // !OMANIMATOR

// dummy to avoid linker warning
void AOMMessageSender_dummyOp();

#endif // OMANIMATOR

#endif // AOMMessageSender_H
//
// $Log: AOMMessageSender.h $
// Revision 1.9  2007/03/11 11:57:48  ilgiga
// Change copyright comment
// Revision 1.8  2007/03/01 16:31:20  ilgiga
// Telelogic instead of i-Logix
// Revision 1.7  2005/04/21 10:03:08  amos
// Revision 1.6.1.2  2005/03/16 14:02:24  amos
// Revision 1.6  2004/05/11 07:45:14  vova
// Linux warnings: order of initializers changed
// --- Added comments ---  vova [2004/05/11 07:45:46 GMT]
// Virtual destructor added
// Revision 1.5  2002/12/17 14:50:25  amos
// Replace the usage of a general message queue with message sender specific queue that has blocking put()
// Block the entering tasks when the number of messages in the queue is greater than 10
// Revision 1.4.1.1  2002/12/15 14:23:41  vova
// Duplicate revision
// Revision 1.3  2002/07/23 07:16:46  amos
// add dummy method AOMMessageSender_dummyOp() to avoid linker warnings in .NET
// Revision 1.2  2002/07/03 15:53:46  Eldad
// Message Sender
//
