PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT) -lang-c++ 
RM=rm -fr
CP=cp 
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include -Wno-write-strings -I.. -I../osconfig/QNX -DUSE_IOSTREAM -DQNX $(RHAP_FLAGS)

targets=oxf oxfinst

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .cpp

.cpp.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<

ifeq ($(CFG),oxf)
RHAP_FLAGS:=
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),oxfinst)
RHAP_FLAGS:=-D_OMINSTRUMENT
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

CPP_EXT=.cpp
H_EXT=.h
OBJ_EXT=.o

include oxfFiles.list

SRCS = QNXOS$(CPP_EXT) \
  $(OXF_SRC)

HDRS = QNXOS$(H_EXT) \
  $(OXF_INC)

OBJS = QNXOS$(OBJ_EXT) \
  $(OXF_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)oxf$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)

qnx$(VERSION)oxfinst$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)


