PATH_SEP=/
CC=qcc -Vgcc_nto$(CPU)$(CPUEXT)
RM=rm -fr
CP=cp 
RHAP_FLAGS=
AR=nto$(CPU)-ar
ARFLAGS=-rvus
DEFAULT_CPP_FLAGS=-g
ADDED_CPP_FLAGS = $(DEFAULT_CPP_FLAGS) -I$(QNX_TARGET)/usr/include -Wno-write-strings -I.. -I../osconfig/QNX -DQNX $(RHAP_FLAGS) -DRIC_DISTRIBUTED_SYSTEM

targets=dox doxinst

.DEFAULT : all

.PHONY : all

.FAILED :
	$(RM) $(OBJS)


.SUFFIXES: .c

.c.o:
	$(CC) $(ADDED_CPP_FLAGS) $(CPPFLAGS) -c $<


CPP_EXT=.c
H_EXT=.h
OBJ_EXT=.o

include doxFiles.list

SRCS = RiDOSqnx$(C_EXT) \
  $(DOX_SRC)

HDRS = RiDOSqnx$(H_EXT) \
  $(DOX_INC)

OBJS = RiDOSqnx$(OBJ_EXT) \
  $(DOX_OBJ)

define BUILD_LIB
$(AR) $(ARFLAGS) $@ $?
$(CP) $@  ..$(PATH_SEP)lib$(PATH_SEP)$@
$(RM) $(OBJS) $@
endef

qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a: $(OBJS)
	$(BUILD_LIB)

ifeq ($(CFG),dox)
RHAP_FLAGS:=
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
ifeq ($(CFG),doxinst)
RHAP_FLAGS:=-DUSE_IOSTREAM -D_OMINSTRUMENT
all: qnx$(VERSION)$(CFG)$(CPU)$(CPUEXT).a

else
all :
	@echo "Usage: $(MAKE) all CFG=<target>."
	@echo "where target is one of $(targets)"
endif
endif

