package
{
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;
    
	public class MovingImage extends Sprite
	{

		public var xspeed:Number;
		public var yspeed:Number;
        
		private var oldx:Number
		private var oldy:Number;

		private var curpos_x:Number = 1;
		private var curpos_y:Number = 1;

		private var gfx1:Bitmap;
		private var gfx2:Bitmap;

		[ Embed ( source = "logo1.png" ) ] private var logo1GFXClass:Class;
		[ Embed ( source = "logo2.png" ) ] private var logo2GFXClass:Class;
		
		public function MovingImage( index:Number )
		{
			if ( index == 1 ) {
				gfx1 = new logo1GFXClass( );
	
				addChild( gfx1 );

				// skin repositioning to middle to make bouncing more precise
				gfx1.x = - width / 2;
				gfx1.y = - height / 2;
			}
			
			if ( index == 2 ) {
				gfx2 = new logo2GFXClass( );
				addChild( gfx2 );
				gfx2.x = - width / 2;
				gfx2.y = - height / 2;
			}
		}

		// initialization, called after parent addChild
		public function init( ):void                    
		{
			// x , y and stage are inherited properties
			x = ( width / 2 + Math.random( ) ) % ( stage.stageWidth - width / 2 );        
			y = ( height / 2 + Math.random( ) ) % ( stage.stageHeight - height / 2 );

			xspeed = Math.random( ) * 10;
			yspeed = Math.random( ) * 10;
            
			// start step triggering function based on enterframe event
			addEventListener( Event.ENTER_FRAME , step );    

			// add mouseevents to make ourself draggable
			addEventListener( MouseEvent.MOUSE_DOWN , dragImage );
			addEventListener( MouseEvent.MOUSE_UP , releaseImage );

		}
		
		// Drag image handler
		private function dragImage ( event:MouseEvent ):void
		{
			// removing stage mousemove listening
			stage.addEventListener( MouseEvent.MOUSE_MOVE , moveImage );
            
			// we stop stepping during dragging
			removeEventListener( Event.ENTER_FRAME , step );
		}
		
		// Mouse up event handler
		private function releaseImage ( event:MouseEvent ):void
		{
			stage.removeEventListener( MouseEvent.MOUSE_MOVE , moveImage );
            
			// start stepping
			addEventListener( Event.ENTER_FRAME , step );
		}
	
		// Mouse move event handler
		private function moveImage ( event:MouseEvent ):void
		{

			// Set borders for image
			if ( event.stageX < width / 2 ) 
				curpos_x = width / 2;
			else {
				if ( event.stageX > stage.stageWidth - width / 2 ) 
					curpos_x = stage.stageWidth - width / 2;
				else
					curpos_x = 0;
			}

			if ( event.stageY < height / 2 ) 
				curpos_y = height / 2;
			else
				if ( event.stageY > stage.stageHeight - height / 2 ) 
					curpos_y = stage.stageHeight - height / 2;
				else
					curpos_y = 0;
            
			// store previous coordinates
			oldx = x;
			oldy = y;
            
			if ( curpos_x == 0 )
				if ( event.stageX != 0 )
					x = event.stageX;
				
			else
				x = curpos_x;

			if ( curpos_y == 0 )
				if ( event.stageY != 0 )
					y = event.stageY;
			else
				y = curpos_y;
            
			// calculate new speed components
			xspeed = x - oldx;
			yspeed = y - oldy;

			if ( xspeed > 20 )
				xspeed = 20;
			else
				if ( xspeed < -20 )
					xspeed = -20

			if ( yspeed > 20 )
				yspeed = 20;
			else
				if ( yspeed < -20 )
					yspeed = -20;
       
		}

		public function step ( event:Event ):void
		{
			// sett position
			x += xspeed;
			y += yspeed;

			// bounce ball at stage edges
			if ( x + xspeed > stage.stageWidth - width / 2 ) 
				xspeed *= -1;
            else 
				if ( x + xspeed < width / 2 ) 
					xspeed *= -1;	
            
			if ( y + yspeed > stage.stageHeight - height / 2 ) 
                yspeed *= -1;
            else 
				if ( y + yspeed < height / 2 )
					yspeed *= -1;

		}
   	}
}