package
{
	import caurina.transitions.Tweener;

	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.events.Event;
	import flash.utils.Timer;
	import flash.text.TextFormat;
	import flash.desktop.*;

	import qnx.ui.buttons.LabelButton;
	import qnx.ui.buttons.ToggleSwitch;
	import qnx.ui.text.Label;

	public class MenuBar extends Sprite
	{
		public static const WIDTH:int = 1024;
		public static const HEIGHT:int = 70;
		public static const VISIBLE_Y:int = 0;
		public static const HIDDEN_Y:int = -HEIGHT;
		public static const SLIDE_TIME:Number = 0.5;

		private var _active:Boolean;
		private	var tgButton:ToggleSwitch;
		private var bgNextButton:LabelButton;
		private var bgPrevButton:LabelButton;
		private var logoNextButton:LabelButton;
		private var logoPrevButton:LabelButton;

		// Constructor
		public function MenuBar()
		{
			initializeUI();
		}

		// First initialization
		private function initializeUI():void
		{
			_active = false;

			// set default position (HIDDEN_Y) of the menu bar
			this.x = 0;
			this.y = HIDDEN_Y;

			this.graphics.beginFill( 0x222222,0.7 );
			this.graphics.drawRect( 0,0,WIDTH,HEIGHT );
			this.graphics.endFill();

			// Toggle switch button Label
			var labelFormat:TextFormat = new TextFormat();
			var firstLabel:Label = new Label();
			
			labelFormat.size = 22;
			labelFormat.color = 0xFFFFFF;


			firstLabel.format = labelFormat;
//			firstLabel.text = "Keep the screen";
			firstLabel.text = "Не откл. экран";
			firstLabel.x = 6;
			firstLabel.y = 18;

			firstLabel.width = 150;
			this.addChild( firstLabel );

			// place button on the menu bar
			tgButton = new ToggleSwitch();
			tgButton.height = 55;
			tgButton.selected = false;
			tgButton.defaultLabel = "Нет";
			tgButton.selectedLabel = "Да";

			// set the button in 10 pixels from the left, and center it vertically in the menu bar
			tgButton.x = 160;
			tgButton.y = 15;
			tgButton.addEventListener( Event.SELECT, stateChange );
			this.addChild( tgButton );

			// Logo switch  Label
			var secondLabel:Label = new Label();
			
			secondLabel.format = labelFormat;
//			secondLabel.text = "Change the logo";
			secondLabel.text = "Изменить логотип";
			secondLabel.x = 345;
			secondLabel.y = 18;

			secondLabel.width = 180;
			this.addChild( secondLabel );

			// place logo prev button on the menu bar
			logoPrevButton = new LabelButton();
			logoPrevButton.height = 45;
			logoPrevButton.width = 55;
			logoPrevButton.label = "<<"
			// set the button in 10 pixels from the left, and center it vertically in the menu bar
			logoPrevButton.x = 530;
			logoPrevButton.y = 12;
			logoPrevButton.enabled = false;
			logoPrevButton.addEventListener( MouseEvent.CLICK, logoPrevClickHandler ); 
			this.addChild( logoPrevButton );

			// place logo next button on the menu bar
			logoNextButton = new LabelButton();
			logoNextButton.height = 45;
			logoNextButton.width = 55;
			logoNextButton.label = ">>"
			// set the button in 10 pixels from the left, and center it vertically in the menu bar
			logoNextButton.x = 595;
			logoNextButton.y = 12;
			logoNextButton.addEventListener( MouseEvent.CLICK, logoNextClickHandler ); 
			this.addChild( logoNextButton );

			// Background switch Label
			var thirdLabel:Label = new Label();
			
			thirdLabel.format = labelFormat;
//			thirdLabel.text = "Change the background";
			thirdLabel.text = "Изменить фон";
			thirdLabel.x = 675;
			thirdLabel.y = 18;

			thirdLabel.width = 240;
			this.addChild( thirdLabel );

			// place background prev button on the menu bar
			bgPrevButton = new LabelButton();
			bgPrevButton.height = 45;
			bgPrevButton.width = 55;
			bgPrevButton.label = "<<"
			// set the button in 10 pixels from the left, and center it vertically in the menu bar
			bgPrevButton.x = 825;
			bgPrevButton.y = 12;
			bgPrevButton.enabled = false;
			bgPrevButton.addEventListener( MouseEvent.CLICK, bgPrevClickHandler ); 
			this.addChild( bgPrevButton );

			// place logo next button on the menu bar
			bgNextButton = new LabelButton();
			bgNextButton.height = 45;
			bgNextButton.width = 55;
			bgNextButton.label = ">>"
			
			bgNextButton.x = 890;
			bgNextButton.y = 12;

			bgNextButton.addEventListener( MouseEvent.CLICK, bgNextClickHandler ); 
			this.addChild( bgNextButton );

		}

		public function isVisible():Boolean
		{
			return _active;
		}

		public function show():void
		{
			_active = true;
			Tweener.addTween( this, {y:VISIBLE_Y, time:SLIDE_TIME, transition:"linear"} );
		}

		public function hide():void
		{
			_active = false;
			Tweener.addTween(this, {y:HIDDEN_Y, time:SLIDE_TIME, transition:"linear"});
		}

		public function processEvent( event:MouseEvent ):void
		{
			if ( event.localY > HEIGHT )
				hide();
        }
		
		private function stateChange( event:Event ):void
		{
			if ( tgButton.selected == true ) {
				NativeApplication.nativeApplication.systemIdleMode = SystemIdleMode.KEEP_AWAKE;
			}
			else {
				NativeApplication.nativeApplication.systemIdleMode = SystemIdleMode.NORMAL;
			}
		}

		private function bgNextClickHandler( event:MouseEvent ):void
		{
			if ( DemoApp.bg_cur < DemoApp.BG_MAX_NUM - 1 ) {
				DemoApp.changeBg( DemoApp.bg_cur + 1 );

				if ( DemoApp.bg_cur >= DemoApp.BG_MAX_NUM - 1 )  {
					bgNextButton.enabled = false;
				}
				bgPrevButton.enabled = true;
//				bgNextButton.label = DemoApp.bg_cur.toString();
			}

		}

		private function bgPrevClickHandler( event:MouseEvent ):void
		{
			if ( DemoApp.bg_cur > 0 ) {
				DemoApp.changeBg( DemoApp.bg_cur - 1 );
				if ( DemoApp.bg_cur <= 0 )  {
					bgPrevButton.enabled = false;
				}
				bgNextButton.enabled = true;
//				bgPrevButton.label = DemoApp.bg_cur.toString();
			}

		}

		private function logoNextClickHandler( event:MouseEvent ):void
		{
			if ( DemoApp.logo_cur < DemoApp.LOGO_MAX_NUM - 1 ) {
				DemoApp.changeLogo( DemoApp.logo_cur + 1 );

				if ( DemoApp.logo_cur >= DemoApp.LOGO_MAX_NUM - 1 )  {
					logoNextButton.enabled = false;
				}
				logoPrevButton.enabled = true;
			}
		}

		private function logoPrevClickHandler( event:MouseEvent ):void
		{
			if ( DemoApp.logo_cur > 0 ) {
				DemoApp.changeLogo( DemoApp.logo_cur - 1 );

				if ( DemoApp.logo_cur <= 0 )  {
					logoPrevButton.enabled = false;
				}
				logoNextButton.enabled = true;
			}
		}

	}
}